/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.NFS4Client;
import org.dcache.chimera.nfs.v4.OperationPUTFH;
import org.dcache.chimera.nfs.v4.xdr.SETCLIENTID_CONFIRM4res;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationSETCLIENTID_CONFIRM
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationPUTFH.class);

    OperationSETCLIENTID_CONFIRM(nfs_argop4 args) {
        super(args, 36);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        SETCLIENTID_CONFIRM4res res = new SETCLIENTID_CONFIRM4res();
        try {
            Long clientid = this._args.opsetclientid_confirm.clientid.value.value;
            NFS4Client client = context.getStateHandler().getClientByID(clientid);
            if (client == null) {
                throw new ChimeraNFSException(10022, "Bad client id");
            }
            res.status = 22;
            if (client.verifierEquals(this._args.opsetclientid_confirm.setclientid_confirm)) {
                res.status = 0;
                client.setConfirmed();
            }
        }
        catch (ChimeraNFSException he) {
            _log.debug("SETCLIENTID_CONFIRM: {}", (Object)he.getMessage());
            res.status = he.getStatus();
        }
        this._result.opsetclientid_confirm = res;
        return this._result;
    }
}

