/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import java.net.Inet6Address;
import java.net.InetSocketAddress;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.ClientCB;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.NFS4Client;
import org.dcache.chimera.nfs.v4.xdr.SETCLIENTID4res;
import org.dcache.chimera.nfs.v4.xdr.SETCLIENTID4resok;
import org.dcache.chimera.nfs.v4.xdr.clientaddr4;
import org.dcache.chimera.nfs.v4.xdr.clientid4;
import org.dcache.chimera.nfs.v4.xdr.netaddr4;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.v4.xdr.uint64_t;
import org.dcache.chimera.nfs.v4.xdr.verifier4;
import org.dcache.utils.net.InetSocketAddresses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationSETCLIENTID
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationSETCLIENTID.class);

    OperationSETCLIENTID(nfs_argop4 args) {
        super(args, 35);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        SETCLIENTID4res res = new SETCLIENTID4res();
        try {
            verifier4 verifier = this._args.opsetclientid.client.verifier;
            NFS4Client client = context.getStateHandler().getClientByVerifier(verifier);
            if (client != null) {
                netaddr4 addr = new netaddr4();
                addr.na_r_netid = client.getRemoteAddress().getAddress() instanceof Inet6Address ? "tcp6" : "tcp";
                addr.na_r_addr = InetSocketAddresses.uaddrOf((InetSocketAddress)client.getRemoteAddress());
                res.status = 10017;
                res.client_using = new clientaddr4(addr);
                throw new ChimeraNFSException(10017, "Client Id In use");
            }
            String r_addr = this._args.opsetclientid.callback.cb_location.na_r_addr;
            String r_netid = this._args.opsetclientid.callback.cb_location.na_r_netid;
            int program = this._args.opsetclientid.callback.cb_program.value;
            client = context.getStateHandler().createClient(context.getRpcCall().getTransport().getRemoteSocketAddress(), context.getRpcCall().getTransport().getLocalSocketAddress(), this._args.opsetclientid.client.id, this._args.opsetclientid.client.verifier, null);
            try {
                ClientCB cb = new ClientCB(r_addr, r_netid, program);
                cb = new ClientCB(InetSocketAddresses.uaddrOf((InetSocketAddress)context.getRpcCall().getTransport().getRemoteSocketAddress()), r_netid, program);
                _log.debug("Client callback: {}", (Object)cb);
                client.setCB(cb);
            }
            catch (Exception ignode_call_back) {
                _log.debug("no callback defined for: {}", (Object)context.getRpcCall().getTransport().getRemoteSocketAddress().getAddress());
            }
            context.getStateHandler().addClient(client);
            res.resok4 = new SETCLIENTID4resok();
            res.resok4.clientid = new clientid4();
            res.resok4.clientid.value = new uint64_t(client.getId());
            res.resok4.setclientid_confirm = client.verifier();
            res.status = 0;
        }
        catch (ChimeraNFSException he) {
            _log.debug("SETCLIENTID: ", (Object)he.getMessage());
            res.status = he.getStatus();
        }
        catch (Exception e) {
            _log.error("SETCLIENTID: ", (Throwable)e);
            res.status = 10006;
        }
        this._result.opsetclientid = res;
        return this._result;
    }
}

