/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.xdr.SAVEFH4res;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationSAVEFH
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationSAVEFH.class);

    OperationSAVEFH(nfs_argop4 args) {
        super(args, 32);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        SAVEFH4res res = new SAVEFH4res();
        try {
            context.saveCurrentInode();
            res.status = 0;
        }
        catch (ChimeraNFSException he) {
            _log.debug("SAVEFH4: {}", (Object)he.getMessage());
            res.status = he.getStatus();
        }
        catch (Exception e) {
            _log.error("SAVEFH4:", (Throwable)e);
            res.status = 10018;
        }
        this._result.opsavefh = res;
        return this._result;
    }
}

