/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.NFS4Client;
import org.dcache.chimera.nfs.v4.xdr.RENEW4res;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationRENEW
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationRENEW.class);

    OperationRENEW(nfs_argop4 args) {
        super(args, 30);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        RENEW4res res = new RENEW4res();
        try {
            Long clientid = this._args.oprenew.clientid.value.value;
            NFS4Client client = context.getStateHandler().getClientByID(clientid);
            if (client == null) {
                throw new ChimeraNFSException(10022, "Bad client id");
            }
            client.updateLeaseTime();
            res.status = 0;
        }
        catch (ChimeraNFSException he) {
            _log.debug("RENEW: {}", (Object)he.getMessage());
            res.status = he.getStatus();
        }
        this._result.oprenew = res;
        return this._result;
    }
}

