/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.FileNotFoundHimeraFsException;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.NameFilter;
import org.dcache.chimera.nfs.v4.xdr.RENAME4res;
import org.dcache.chimera.nfs.v4.xdr.RENAME4resok;
import org.dcache.chimera.nfs.v4.xdr.change_info4;
import org.dcache.chimera.nfs.v4.xdr.changeid4;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.v4.xdr.uint64_t;
import org.dcache.chimera.posix.Acl;
import org.dcache.chimera.posix.Stat;
import org.dcache.chimera.posix.UnixAcl;
import org.dcache.chimera.posix.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationRENAME
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationRENAME.class);

    OperationRENAME(nfs_argop4 args) {
        super(args, 29);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        RENAME4res res = new RENAME4res();
        try {
            FsInode sourceDir = context.savedInode();
            FsInode destDir = context.currentInode();
            if (!sourceDir.isDirectory()) {
                throw new ChimeraNFSException(20, "source path not a directory");
            }
            if (!destDir.isDirectory()) {
                throw new ChimeraNFSException(20, "destination path  not a directory");
            }
            String oldName = NameFilter.convert(this._args.oprename.oldname.value.value.value);
            String newName = NameFilter.convert(this._args.oprename.newname.value.value.value);
            if (oldName.length() == 0) {
                throw new ChimeraNFSException(22, "zero-length name");
            }
            if (newName.length() == 0) {
                throw new ChimeraNFSException(22, "zero-length name");
            }
            if (oldName.equals(".") || oldName.equals("..")) {
                throw new ChimeraNFSException(10041, "bad name '.' or '..'");
            }
            if (newName.equals(".") || newName.equals("..")) {
                throw new ChimeraNFSException(10041, "bad name '.' or '..'");
            }
            if (sourceDir.fsId() != destDir.fsId()) {
                throw new ChimeraNFSException(18, "cross filesystem request");
            }
            _log.debug("Rename: src={} name={} dest={} name={}", new Object[]{sourceDir, oldName, destDir, newName});
            Stat fromStat = sourceDir.stat();
            Stat toStat = destDir.stat();
            UnixAcl fromAcl = new UnixAcl(fromStat.getUid(), fromStat.getGid(), fromStat.getMode() & 0x1FF);
            UnixAcl toAcl = new UnixAcl(toStat.getUid(), toStat.getGid(), toStat.getMode() & 0x1FF);
            if (!context.getAclHandler().isAllowed((Acl)fromAcl, (User)context.getUser(), 3) || !context.getAclHandler().isAllowed((Acl)toAcl, (User)context.getUser(), 6)) {
                throw new ChimeraNFSException(13, "Permission denied.");
            }
            context.getFs().move(sourceDir, oldName, destDir, newName);
            res.resok4 = new RENAME4resok();
            res.resok4.source_cinfo = new change_info4();
            res.resok4.source_cinfo.atomic = true;
            res.resok4.source_cinfo.before = new changeid4(new uint64_t(sourceDir.statCache().getMTime()));
            res.resok4.source_cinfo.after = new changeid4(new uint64_t(System.currentTimeMillis()));
            res.resok4.target_cinfo = new change_info4();
            res.resok4.target_cinfo.atomic = true;
            res.resok4.target_cinfo.before = new changeid4(new uint64_t(sourceDir.statCache().getMTime()));
            res.resok4.target_cinfo.after = new changeid4(new uint64_t(System.currentTimeMillis()));
            res.status = 0;
        }
        catch (FileNotFoundHimeraFsException fnf) {
            res.status = 2;
        }
        catch (ChimeraNFSException he) {
            _log.error("RENAME: {}", (Object)he.getMessage());
            res.status = he.getStatus();
        }
        catch (ChimeraFsException hfe) {
            res.status = 10006;
            _log.error("RENAME: {}", (Object)hfe.getMessage());
        }
        this._result.oprename = res;
        return this._result;
    }
}

