/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import org.dcache.chimera.FileNotFoundHimeraFsException;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.NameFilter;
import org.dcache.chimera.nfs.v4.xdr.REMOVE4res;
import org.dcache.chimera.nfs.v4.xdr.REMOVE4resok;
import org.dcache.chimera.nfs.v4.xdr.change_info4;
import org.dcache.chimera.nfs.v4.xdr.changeid4;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.v4.xdr.uint64_t;
import org.dcache.chimera.posix.Acl;
import org.dcache.chimera.posix.Stat;
import org.dcache.chimera.posix.UnixAcl;
import org.dcache.chimera.posix.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationREMOVE
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationREMOVE.class);

    OperationREMOVE(nfs_argop4 args) {
        super(args, 28);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        REMOVE4res res = new REMOVE4res();
        try {
            FsInode parentInode = context.currentInode();
            if (!context.currentInode().isDirectory()) {
                throw new ChimeraNFSException(20, "parent not a directory");
            }
            String name2 = NameFilter.convert(this._args.opremove.target.value.value.value);
            if (name2.length() > 255) {
                throw new ChimeraNFSException(63, "name too long");
            }
            if (name2.length() == 0) {
                throw new ChimeraNFSException(22, "zero-length name");
            }
            if (name2.equals(".") || name2.equals("..")) {
                throw new ChimeraNFSException(10041, "bad name '.' or '..'");
            }
            _log.debug("REMOVE: {} : {}", new Object[]{parentInode.toString(), name2});
            Stat inodeStat = context.currentInode().inodeOf(name2).statCache();
            Stat parentStat = parentInode.statCache();
            UnixAcl acl = new UnixAcl(inodeStat.getUid(), inodeStat.getGid(), inodeStat.getMode() & 0x1FF);
            acl = new UnixAcl(parentStat.getUid(), parentStat.getGid(), parentStat.getMode() & 0x1FF);
            if (!context.getAclHandler().isAllowed((Acl)acl, (User)context.getUser(), 3)) {
                throw new ChimeraNFSException(13, "Permission denied.");
            }
            boolean rc = context.currentInode().remove(name2);
            if (!rc && context.currentInode().isDirectory()) {
                throw new ChimeraNFSException(66, "directory not empty");
            }
            res.status = 0;
            res.resok4 = new REMOVE4resok();
            res.resok4.cinfo = new change_info4();
            res.resok4.cinfo.atomic = true;
            res.resok4.cinfo.before = new changeid4(new uint64_t(context.currentInode().statCache().getMTime()));
            res.resok4.cinfo.after = new changeid4(new uint64_t(System.currentTimeMillis()));
        }
        catch (FileNotFoundHimeraFsException e) {
            res.status = 2;
        }
        catch (ChimeraNFSException he) {
            _log.debug("REMOVE: {}", (Object)he.getMessage());
            res.status = he.getStatus();
        }
        catch (Exception e) {
            _log.error("REMOVE: ", (Throwable)e);
            res.status = 10006;
        }
        this._result.opremove = res;
        return this._result;
    }
}

