/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.xdr.READLINK4res;
import org.dcache.chimera.nfs.v4.xdr.READLINK4resok;
import org.dcache.chimera.nfs.v4.xdr.linktext4;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.v4.xdr.utf8str_cs;
import org.dcache.chimera.nfs.v4.xdr.utf8string;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationREADLINK
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationREADLINK.class);

    OperationREADLINK(nfs_argop4 args) {
        super(args, 27);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        READLINK4res res = new READLINK4res();
        try {
            if (!context.currentInode().isLink()) {
                throw new ChimeraNFSException(22, "not a symlink");
            }
            byte[] link = context.currentInode().readlink();
            _log.debug("NFS Request  READLINK4 link: {}", (Object)new String(link));
            res.resok4 = new READLINK4resok();
            res.resok4.link = new linktext4();
            res.resok4.link.value = new utf8str_cs();
            res.resok4.link.value.value = new utf8string();
            res.resok4.link.value.value.value = link;
            res.status = 0;
        }
        catch (ChimeraNFSException he) {
            _log.debug("READLINK: {}", (Object)he.getMessage());
            res.status = he.getStatus();
        }
        catch (Exception e) {
            _log.error("READLINK4", (Throwable)e);
            res.status = 10006;
        }
        this._result.opreadlink = res;
        return this._result;
    }
}

