/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import com.google.common.collect.MapMaker;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.DirectoryStreamHelper;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.HimeraDirectoryEntry;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.InodeCacheEntry;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.OperationGETATTR;
import org.dcache.chimera.nfs.v4.xdr.READDIR4res;
import org.dcache.chimera.nfs.v4.xdr.READDIR4resok;
import org.dcache.chimera.nfs.v4.xdr.attrlist4;
import org.dcache.chimera.nfs.v4.xdr.bitmap4;
import org.dcache.chimera.nfs.v4.xdr.component4;
import org.dcache.chimera.nfs.v4.xdr.dirlist4;
import org.dcache.chimera.nfs.v4.xdr.entry4;
import org.dcache.chimera.nfs.v4.xdr.fattr4;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_cookie4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.v4.xdr.uint32_t;
import org.dcache.chimera.nfs.v4.xdr.uint64_t;
import org.dcache.chimera.nfs.v4.xdr.utf8str_cs;
import org.dcache.chimera.nfs.v4.xdr.verifier4;
import org.dcache.chimera.posix.Acl;
import org.dcache.chimera.posix.Stat;
import org.dcache.chimera.posix.UnixAcl;
import org.dcache.chimera.posix.User;
import org.dcache.utils.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationREADDIR
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationREADDIR.class);
    private static final int ENTRY4_SIZE = 36;
    private static final int DIRLIST4_SIZE = 56;
    private static final int READDIR4RESOK_SIZE = 92;
    private static final ConcurrentMap<InodeCacheEntry<verifier4>, List<HimeraDirectoryEntry>> _dlCache = new MapMaker().expireAfterAccess(10L, TimeUnit.MINUTES).softValues().maximumSize(512).makeMap();

    OperationREADDIR(nfs_argop4 args) {
        super(args, 26);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        READDIR4res res = new READDIR4res();
        try {
            verifier4 verifier;
            FsInode dir = context.currentInode();
            Stat dirStat = dir.statCache();
            UnixAcl acl = new UnixAcl(dirStat.getUid(), dirStat.getGid(), dirStat.getMode() & 0x1FF);
            if (!context.getAclHandler().isAllowed((Acl)acl, (User)context.getUser(), 4)) {
                throw new ChimeraNFSException(13, "Permission denied.");
            }
            if (!dir.exists()) {
                throw new ChimeraNFSException(2, "Path Do not exist.");
            }
            if (!dir.isDirectory()) {
                throw new ChimeraNFSException(20, "Path is not a directory.");
            }
            List dirList = null;
            long startValue = this._args.opreaddir.cookie.value.value;
            long COOKIE_OFFSET = 3L;
            if (startValue != 0L) {
                ++startValue;
                verifier = this._args.opreaddir.cookieverf;
                this.checkVerifier(dir, verifier);
            } else {
                verifier = this.generateDirectoryVerifier(dir);
                startValue = 3L;
            }
            InodeCacheEntry<verifier4> cacheKey = new InodeCacheEntry<verifier4>(dir, verifier);
            dirList = (List)_dlCache.get(cacheKey);
            if (dirList == null) {
                _log.debug("No cached list found for {}", (Object)dir);
                dirList = DirectoryStreamHelper.listOf((FsInode)dir);
                _dlCache.put(cacheKey, dirList);
            } else {
                _log.debug("Cached list found for {}", (Object)dir);
            }
            if (startValue > (long)dirList.size() + 3L || startValue < 3L) {
                throw new ChimeraNFSException(10003, "bad cookie : " + startValue + " " + dirList.size());
            }
            if (this._args.opreaddir.maxcount.value.value < 92) {
                throw new ChimeraNFSException(10005, "maxcount too small");
            }
            res.resok4 = new READDIR4resok();
            res.resok4.reply = new dirlist4();
            res.resok4.cookieverf = verifier;
            int currcount = 92;
            int dircount = 0;
            entry4 currentEntry = res.resok4.reply.entries = new entry4();
            entry4 lastEntry = null;
            res.resok4.reply.eof = true;
            int fcount = 0;
            for (long i = startValue; i < (long)dirList.size() + 3L; ++i) {
                HimeraDirectoryEntry le = (HimeraDirectoryEntry)dirList.get((int)(i - 3L));
                String name2 = le.getName();
                if (name2.equals(".") || name2.equals("..")) continue;
                ++fcount;
                FsInode ei = le.getInode();
                currentEntry.name = new component4(new utf8str_cs(name2));
                currentEntry.cookie = new nfs_cookie4(new uint64_t(i));
                try {
                    currentEntry.attrs = OperationGETATTR.getAttributes(this._args.opreaddir.attr_request, ei, context);
                }
                catch (ChimeraNFSException e) {
                    currentEntry.attrs = new fattr4();
                    currentEntry.attrs.attrmask = new bitmap4();
                    currentEntry.attrs.attrmask.value = new uint32_t[0];
                    currentEntry.attrs.attr_vals = new attrlist4(new byte[0]);
                }
                currentEntry.nextentry = null;
                int newSize = 36 + name2.length() + currentEntry.name.value.value.value.length + currentEntry.attrs.attr_vals.value.length;
                int newDirSize = name2.length() + 4;
                if (currcount + newSize > this._args.opreaddir.maxcount.value.value || dircount + newDirSize > this._args.opreaddir.dircount.value.value) {
                    res.resok4.reply.eof = false;
                    _log.debug("Sending {} entries ({} bytes from {}, dircount = {} from {} ) cookie = {} total {}", new Object[]{i - startValue, currcount, this._args.opreaddir.maxcount.value.value, dircount, this._args.opreaddir.dircount.value.value, startValue, dirList.size()});
                    break;
                }
                dircount += newDirSize;
                currcount += newSize;
                lastEntry = currentEntry;
                if (i + 1L >= (long)dirList.size() + 3L) continue;
                currentEntry = currentEntry.nextentry = new entry4();
            }
            if (lastEntry == null) {
                res.resok4.reply.entries = null;
            } else {
                lastEntry.nextentry = null;
            }
            res.status = 0;
            _log.debug("Sending {} entries ({} bytes from {}, dircount = {} from {} ) cookie = {} total {} EOF={}", new Object[]{fcount, currcount, this._args.opreaddir.maxcount.value.value, startValue, this._args.opreaddir.dircount.value.value, dirList.size(), res.resok4.reply.eof});
        }
        catch (ChimeraNFSException he) {
            _log.debug("READDIR: {}", (Object)he.getMessage());
            res.status = he.getStatus();
        }
        catch (Exception e) {
            res.status = 10006;
            _log.error("READDIR4", (Throwable)e);
        }
        this._result.opreaddir = res;
        return this._result;
    }

    private verifier4 generateDirectoryVerifier(FsInode dir) throws IllegalArgumentException, ChimeraFsException {
        byte[] verifier = new byte[8];
        Bytes.putLong((byte[])verifier, (int)0, (long)dir.statCache().getMTime());
        return new verifier4(verifier);
    }

    private void checkVerifier(FsInode dir, verifier4 verifier) throws ChimeraNFSException, ChimeraFsException {
        long mtime = Bytes.getLong((byte[])verifier.value, (int)0);
        if (mtime > dir.statCache().getMTime()) {
            throw new ChimeraNFSException(10003, "bad cookie");
        }
    }
}

