/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import java.nio.ByteBuffer;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.IOHimeraFsException;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.xdr.READ4res;
import org.dcache.chimera.nfs.v4.xdr.READ4resok;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.posix.Acl;
import org.dcache.chimera.posix.Stat;
import org.dcache.chimera.posix.UnixAcl;
import org.dcache.chimera.posix.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationREAD
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationREAD.class);

    public OperationREAD(nfs_argop4 args) {
        super(args, 25);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        READ4res res = new READ4res();
        try {
            if (context.currentInode().isDirectory()) {
                throw new ChimeraNFSException(21, "path is a directory");
            }
            if (context.currentInode().isLink()) {
                throw new ChimeraNFSException(22, "path is a symlink");
            }
            Stat inodeStat = context.currentInode().statCache();
            UnixAcl fileAcl = new UnixAcl(inodeStat.getUid(), inodeStat.getGid(), inodeStat.getMode() & 0x1FF);
            if (!context.getAclHandler().isAllowed((Acl)fileAcl, (User)context.getUser(), 0)) {
                throw new ChimeraNFSException(13, "Permission denied.");
            }
            if (context.getMinorversion() == 0) {
                context.getStateHandler().updateClientLeaseTime(this._args.opread.stateid);
            }
            long offset = this._args.opread.offset.value.value;
            int count = this._args.opread.count.value.value;
            ByteBuffer buf = ByteBuffer.allocate(count);
            int bytesReaded = context.currentInode().read(offset, buf.array(), 0, count);
            if (bytesReaded < 0) {
                throw new IOHimeraFsException("IO not allowd");
            }
            buf.position(bytesReaded);
            res.status = 0;
            res.resok4 = new READ4resok();
            res.resok4.data = buf;
            if (offset + (long)bytesReaded >= inodeStat.getSize()) {
                res.resok4.eof = true;
            }
        }
        catch (IOHimeraFsException hioe) {
            _log.debug("READ: {}", (Object)hioe.getMessage());
            res.status = 5;
        }
        catch (ChimeraNFSException he) {
            _log.debug("READ: {}", (Object)he.getMessage());
            res.status = he.getStatus();
        }
        catch (ChimeraFsException hfe) {
            res.status = 10020;
        }
        this._result.opread = res;
        return this._result;
    }
}

