/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.xdr.PUTFH4res;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationPUTFH
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationPUTFH.class);

    public OperationPUTFH(nfs_argop4 args) {
        super(args, 22);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        PUTFH4res res = new PUTFH4res();
        try {
            context.currentInode(context.getFs().inodeFromBytes(this._args.opputfh.object.value));
            _log.debug("NFS Request  PUTFH4 current: {}", (Object)context.currentInode());
            res.status = 0;
        }
        catch (IllegalArgumentException iae) {
            res.status = 10001;
        }
        catch (Exception e) {
            _log.error("PUTFH4:", (Throwable)e);
            res.status = 10018;
        }
        this._result.opputfh = res;
        return this._result;
    }
}

