/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import org.dcache.chimera.FsInode;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.NFS4Client;
import org.dcache.chimera.nfs.v4.NFS4State;
import org.dcache.chimera.nfs.v4.xdr.OPEN_CONFIRM4res;
import org.dcache.chimera.nfs.v4.xdr.OPEN_CONFIRM4resok;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.v4.xdr.stateid4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationOPEN_CONFIRM
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationOPEN_CONFIRM.class);

    OperationOPEN_CONFIRM(nfs_argop4 args) {
        super(args, 20);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        OPEN_CONFIRM4res res = new OPEN_CONFIRM4res();
        try {
            FsInode inode = context.currentInode();
            if (inode.isDirectory()) {
                throw new ChimeraNFSException(21, "path is a directory");
            }
            if (inode.isLink()) {
                throw new ChimeraNFSException(22, "path is a symlink");
            }
            stateid4 stateid = this._args.opopen_confirm.open_stateid;
            _log.debug("confirmed stateID: {}", (Object)stateid);
            NFS4Client client = context.getStateHandler().getClientIdByStateId(stateid);
            if (client == null) {
                throw new ChimeraNFSException(10025, "bad client id.");
            }
            NFS4State state = client.state(stateid);
            if (state.stateid().seqid.value != this._args.opopen_confirm.seqid.value.value) {
                throw new ChimeraNFSException(10026, "bad seqid.");
            }
            state.bumpSeqid();
            state.confirm();
            res.resok4 = new OPEN_CONFIRM4resok();
            res.resok4.open_stateid = state.stateid();
            res.status = 0;
        }
        catch (ChimeraNFSException he) {
            _log.debug("open_confirm failed: {}", (Object)he.getMessage());
            res.status = he.getStatus();
        }
        catch (Exception e) {
            _log.error("open_confirm failed:", (Throwable)e);
            res.status = 10006;
        }
        this._result.opopen_confirm = res;
        return this._result;
    }
}

