/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.FileExistsChimeraFsException;
import org.dcache.chimera.FileNotFoundHimeraFsException;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.NFS4Client;
import org.dcache.chimera.nfs.v4.NFS4State;
import org.dcache.chimera.nfs.v4.NameFilter;
import org.dcache.chimera.nfs.v4.OperationSETATTR;
import org.dcache.chimera.nfs.v4.xdr.OPEN4res;
import org.dcache.chimera.nfs.v4.xdr.OPEN4resok;
import org.dcache.chimera.nfs.v4.xdr.bitmap4;
import org.dcache.chimera.nfs.v4.xdr.change_info4;
import org.dcache.chimera.nfs.v4.xdr.changeid4;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.v4.xdr.open_delegation4;
import org.dcache.chimera.nfs.v4.xdr.uint32_t;
import org.dcache.chimera.nfs.v4.xdr.uint64_t;
import org.dcache.chimera.posix.Acl;
import org.dcache.chimera.posix.Stat;
import org.dcache.chimera.posix.UnixAcl;
import org.dcache.chimera.posix.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationOPEN
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationOPEN.class);

    OperationOPEN(nfs_argop4 args) {
        super(args, 18);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        OPEN4res res = new OPEN4res();
        try {
            NFS4Client client;
            Long clientid = this._args.opopen.owner.value.clientid.value.value;
            if (context.getSession() == null) {
                client = context.getStateHandler().getClientByID(clientid);
                if (client == null || !client.isConfirmed()) {
                    throw new ChimeraNFSException(10022, "bad client id.");
                }
                client.updateLeaseTime();
                _log.debug("open request form clientid: {}, owner: {}", new Object[]{client, new String(this._args.opopen.owner.value.owner)});
            } else {
                client = context.getSession().getClient();
            }
            res.resok4 = new OPEN4resok();
            res.resok4.attrset = new bitmap4();
            res.resok4.attrset.value = new uint32_t[2];
            res.resok4.attrset.value[0] = new uint32_t(0);
            res.resok4.attrset.value[1] = new uint32_t(0);
            res.resok4.delegation = new open_delegation4();
            res.resok4.delegation.delegation_type = 0;
            switch (this._args.opopen.claim.claim) {
                case 0: {
                    FsInode inode;
                    if (!context.currentInode().isDirectory()) {
                        throw new ChimeraNFSException(20, "not a directory");
                    }
                    String name2 = NameFilter.convert(this._args.opopen.claim.file.value.value.value);
                    _log.debug("regular open for : {}", (Object)name2);
                    if (this._args.opopen.openhow.opentype == 1) {
                        boolean exclusive = this._args.opopen.openhow.how.mode == 2 || this._args.opopen.openhow.how.mode == 3;
                        try {
                            inode = context.currentInode().inodeOf(name2);
                            if (exclusive) {
                                throw new ChimeraNFSException(17, "file already exist");
                            }
                            _log.debug("Opening existing file: {}", (Object)name2);
                            _log.trace("Check permission");
                            Stat fileStat = inode.statCache();
                            _log.debug("UID  : {}", (Object)fileStat.getUid());
                            _log.debug("GID  : {}", (Object)fileStat.getGid());
                            _log.debug("Mode : 0{}", (Object)Integer.toOctalString(fileStat.getMode() & 0x1FF));
                            UnixAcl fileAcl = new UnixAcl(fileStat.getUid(), fileStat.getGid(), fileStat.getMode() & 0x1FF);
                            if (!context.getAclHandler().isAllowed((Acl)fileAcl, (User)context.getUser(), 2)) {
                                throw new ChimeraNFSException(13, "Permission denied.");
                            }
                            OperationSETATTR.setAttributes(this._args.opopen.openhow.how.createattrs, inode, context);
                        }
                        catch (FileNotFoundHimeraFsException he) {
                            Stat parentStat = context.currentInode().statCache();
                            UnixAcl parentAcl = new UnixAcl(parentStat.getUid(), parentStat.getGid(), parentStat.getMode() & 0x1FF);
                            if (!context.getAclHandler().isAllowed((Acl)parentAcl, (User)context.getUser(), 6)) {
                                throw new ChimeraNFSException(13, "Permission denied.");
                            }
                            _log.debug("Creating a new file: {}", (Object)name2);
                            inode = context.currentInode().create(name2, context.getUser().getUID(), context.getUser().getGID(), 384);
                            switch (this._args.opopen.openhow.how.mode) {
                                case 0: 
                                case 1: {
                                    res.resok4.attrset = OperationSETATTR.setAttributes(this._args.opopen.openhow.how.createattrs, inode, context);
                                    break;
                                }
                            }
                        }
                    } else {
                        inode = context.currentInode().inodeOf(name2);
                        Stat inodeStat = inode.statCache();
                        UnixAcl fileAcl = new UnixAcl(inodeStat.getUid(), inodeStat.getGid(), inodeStat.getMode() & 0x1FF);
                        if (!context.getAclHandler().isAllowed((Acl)fileAcl, (User)context.getUser(), 0)) {
                            throw new ChimeraNFSException(13, "Permission denied.");
                        }
                        if (inode.isDirectory()) {
                            throw new ChimeraNFSException(21, "path is a directory");
                        }
                        if (inode.isLink()) {
                            throw new ChimeraNFSException(10029, "path is a symlink");
                        }
                    }
                    context.currentInode(inode);
                    break;
                }
                case 1: {
                    _log.debug("open by Inode for : {}", (Object)context.currentInode());
                    break;
                }
                case 2: {
                    break;
                }
            }
            res.resok4.cinfo = new change_info4();
            res.resok4.cinfo.atomic = true;
            res.resok4.cinfo.before = new changeid4(new uint64_t(context.currentInode().statCache().getMTime()));
            res.resok4.cinfo.after = new changeid4(new uint64_t(System.currentTimeMillis()));
            res.resok4.rflags = context.getSession() == null ? new uint32_t(6) : new uint32_t(4);
            NFS4State nfs4state = client.createState();
            res.resok4.stateid = nfs4state.stateid();
            _log.debug("New stateID: {}", (Object)nfs4state.stateid());
            res.status = 0;
        }
        catch (ChimeraNFSException he) {
            _log.debug("OPEN:", (Object)he.getMessage());
            res.status = he.getStatus();
        }
        catch (FileExistsChimeraFsException e) {
            _log.debug("OPEN: {}", (Object)e.getMessage());
            res.status = 17;
        }
        catch (FileNotFoundHimeraFsException fnf) {
            _log.debug("OPEN: {}", (Object)fnf.getMessage());
            res.status = 2;
        }
        catch (ChimeraFsException hfe) {
            _log.error("OPEN:", (Throwable)hfe);
            res.status = 10006;
        }
        catch (Exception e) {
            _log.error("OPEN:", (Throwable)e);
            res.status = 10006;
        }
        this._result.opopen = res;
        return this._result;
    }
}

