/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.xdr.LOOKUPP4res;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLOOKUPP
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationLOOKUPP.class);

    OperationLOOKUPP(nfs_argop4 args) {
        super(args, 16);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        LOOKUPP4res res = new LOOKUPP4res();
        try {
            if (!context.currentInode().isDirectory()) {
                throw new ChimeraNFSException(20, "parent not a directory");
            }
            FsInode parent = context.currentInode().getParent();
            if (parent == null || context.currentInode().toString().equals(FsInode.getRoot((FileSystemProvider)context.getFs()).toString())) {
                res.status = 2;
            } else {
                context.currentInode(parent);
                res.status = 0;
            }
        }
        catch (ChimeraNFSException he) {
            _log.debug("LOOKUPP: {}", (Object)he.getMessage());
            res.status = he.getStatus();
        }
        catch (Exception e) {
            _log.error("Error: ", (Throwable)e);
            res.status = 10018;
        }
        this._result.oplookupp = res;
        return this._result;
    }
}

