/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import org.dcache.chimera.FileNotFoundHimeraFsException;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.NameFilter;
import org.dcache.chimera.nfs.v4.xdr.LOOKUP4res;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLOOKUP
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationLOOKUP.class);

    OperationLOOKUP(nfs_argop4 args) {
        super(args, 15);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        LOOKUP4res res = new LOOKUP4res();
        try {
            String name2 = NameFilter.convert(this._args.oplookup.objname.value.value.value);
            if (context.currentInode().isLink()) {
                throw new ChimeraNFSException(10029, "parent not a symbolic link");
            }
            if (!context.currentInode().isDirectory()) {
                throw new ChimeraNFSException(20, "parent not a directory");
            }
            if (name2.length() < 1) {
                throw new ChimeraNFSException(22, "invalid path");
            }
            if (name2.length() > 255) {
                throw new ChimeraNFSException(63, "path too long");
            }
            if (name2.equals(".") || name2.equals("..")) {
                throw new ChimeraNFSException(10041, "bad name '.' or '..'");
            }
            FsInode newInode = context.currentInode().inodeOf(name2);
            context.currentInode(newInode);
            res.status = 0;
        }
        catch (FileNotFoundHimeraFsException he) {
            res.status = 2;
        }
        catch (ChimeraNFSException he) {
            res.status = he.getStatus();
        }
        catch (Exception e) {
            _log.error("Error: ", (Throwable)e);
            res.status = 10018;
        }
        this._result.oplookup = res;
        return this._result;
    }
}

