/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.xdr.LINK4res;
import org.dcache.chimera.nfs.v4.xdr.LINK4resok;
import org.dcache.chimera.nfs.v4.xdr.change_info4;
import org.dcache.chimera.nfs.v4.xdr.changeid4;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.v4.xdr.uint64_t;
import org.dcache.chimera.posix.Acl;
import org.dcache.chimera.posix.Stat;
import org.dcache.chimera.posix.UnixAcl;
import org.dcache.chimera.posix.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLINK
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationLINK.class);

    OperationLINK(nfs_argop4 args) {
        super(args, 11);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        this._result.oplink = new LINK4res();
        String newName = new String(this._args.oplink.newname.value.value.value);
        try {
            Stat parentStat = context.currentInode().statCache();
            UnixAcl acl = new UnixAcl(parentStat.getUid(), parentStat.getGid(), parentStat.getMode() & 0x1FF);
            if (!context.getAclHandler().isAllowed((Acl)acl, (User)context.getUser(), 6)) {
                throw new ChimeraNFSException(13, "Permission denied.");
            }
            context.getFs().createHLink(context.currentInode(), context.savedInode(), newName);
            this._result.oplink.resok4 = new LINK4resok();
            this._result.oplink.resok4.cinfo = new change_info4();
            this._result.oplink.resok4.cinfo.atomic = true;
            this._result.oplink.resok4.cinfo.before = new changeid4(new uint64_t(context.savedInode().statCache().getMTime()));
            this._result.oplink.resok4.cinfo.after = new changeid4(new uint64_t(System.currentTimeMillis()));
            this._result.oplink.status = 0;
        }
        catch (ChimeraNFSException hne) {
            this._result.oplink.status = hne.getStatus();
        }
        catch (Exception e) {
            _log.error("LINK: ", (Throwable)e);
            this._result.oplink.status = 10018;
        }
        return this._result;
    }
}

