/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.Layout;
import org.dcache.chimera.nfs.v4.xdr.LAYOUTGET4res;
import org.dcache.chimera.nfs.v4.xdr.LAYOUTGET4resok;
import org.dcache.chimera.nfs.v4.xdr.length4;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.v4.xdr.uint64_t;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLAYOUTGET
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationLAYOUTGET.class);

    OperationLAYOUTGET(nfs_argop4 args) {
        super(args, 50);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        LAYOUTGET4res res = new LAYOUTGET4res();
        try {
            length4 lengthRange = new length4();
            lengthRange.value = new uint64_t(-1L);
            if (this._args.oplayoutget.loga_offset.value.value != 0L && this._args.oplayoutget.loga_length.value.value == 0L) {
                throw new ChimeraNFSException(22, "length == 0");
            }
            if (this._args.oplayoutget.loga_iomode != 2 && this._args.oplayoutget.loga_iomode != 1) {
                throw new ChimeraNFSException(10049, "invalid loga_iomode");
            }
            if (this._args.oplayoutget.loga_layout_type > 3) {
                throw new ChimeraNFSException(10050, "layouts supported but no matching found (" + this._args.oplayoutget.loga_layout_type + ")");
            }
            if (this._args.oplayoutget.loga_layout_type != 1) {
                throw new ChimeraNFSException(10059, "layout not supported");
            }
            res.logr_resok4 = new LAYOUTGET4resok();
            Layout ioLayout = context.getDeviceManager().layoutGet(context.currentInode(), this._args.oplayoutget.loga_iomode, context.getSession().getClient(), this._args.oplayoutget.loga_stateid);
            res.logr_resok4.logr_layout = ioLayout.getLayoutSegments();
            res.logr_resok4.logr_stateid = ioLayout.getStateid();
            res.logr_resok4.logr_return_on_close = ioLayout.returnOnClose();
            res.logr_status = 0;
        }
        catch (ChimeraNFSException he) {
            _log.debug("LAYOUTGET: {}", (Object)he.getMessage());
            res.logr_status = he.getStatus();
        }
        catch (Exception e) {
            _log.error("LAYOUTGET:", (Throwable)e);
            res.logr_status = 10006;
        }
        this._result.oplayoutget = res;
        return this._result;
    }
}

