/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.xdr.LAYOUTCOMMIT4res;
import org.dcache.chimera.nfs.v4.xdr.LAYOUTCOMMIT4resok;
import org.dcache.chimera.nfs.v4.xdr.length4;
import org.dcache.chimera.nfs.v4.xdr.newsize4;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.v4.xdr.uint64_t;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLAYOUTCOMMIT
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationLAYOUTCOMMIT.class);

    OperationLAYOUTCOMMIT(nfs_argop4 args) {
        super(args, 49);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        LAYOUTCOMMIT4res res = new LAYOUTCOMMIT4res();
        try {
            long currentSize;
            long newSize;
            _log.debug("LAYOUTCOMMIT: inode=" + context.currentInode() + " length=" + this._args.oplayoutcommit.loca_length.value.value + " offset=" + this._args.oplayoutcommit.loca_offset.value.value + " loca_last_write_offset=" + (this._args.oplayoutcommit.loca_last_write_offset.no_newoffset ? this._args.oplayoutcommit.loca_last_write_offset.no_offset.value : "notset"));
            res.locr_resok4 = new LAYOUTCOMMIT4resok();
            res.locr_resok4.locr_newsize = new newsize4();
            res.locr_resok4.locr_newsize.ns_sizechanged = false;
            if (this._args.oplayoutcommit.loca_last_write_offset.no_newoffset && (newSize = this._args.oplayoutcommit.loca_last_write_offset.no_offset.value.value + 1L) > (currentSize = context.currentInode().stat().getSize())) {
                context.currentInode().setSize(newSize);
                res.locr_resok4.locr_newsize.ns_sizechanged = true;
                res.locr_resok4.locr_newsize.ns_size = new length4(new uint64_t(newSize));
            }
            res.locr_status = 0;
        }
        catch (ChimeraNFSException hne) {
            _log.error("LAYOUTCOMMIT: {}", (Object)hne.getMessage());
            res.locr_status = hne.getStatus();
        }
        catch (ChimeraFsException hfe) {
            _log.error("LAYOUTCOMMIT:", (Throwable)hfe);
            res.locr_status = 10006;
        }
        catch (Exception e) {
            _log.error("LAYOUTCOMMIT:", (Throwable)e);
            res.locr_status = 10006;
        }
        this._result.oplayoutcommit = res;
        return this._result;
    }
}

