/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.xdr.GETFH4res;
import org.dcache.chimera.nfs.v4.xdr.GETFH4resok;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_fh4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationGETFH
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationGETFH.class);

    OperationGETFH(nfs_argop4 args) {
        super(args, 10);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        GETFH4res res = new GETFH4res();
        try {
            res.resok4 = new GETFH4resok();
            res.resok4.object = new nfs_fh4();
            res.resok4.object.value = context.getFs().inodeToBytes(context.currentInode());
            res.status = 0;
        }
        catch (ChimeraNFSException he) {
            res.status = he.getStatus();
        }
        catch (Exception e) {
            _log.error("GETFH4:", (Throwable)e);
            res.status = 10018;
        }
        this._result.opgetfh = res;
        return this._result;
    }
}

