/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import java.util.List;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.xdr.GETDEVICELIST4res;
import org.dcache.chimera.nfs.v4.xdr.GETDEVICELIST4resok;
import org.dcache.chimera.nfs.v4.xdr.deviceid4;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_cookie4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.v4.xdr.uint64_t;
import org.dcache.chimera.nfs.v4.xdr.verifier4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationGETDEVICELIST
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationGETDEVICELIST.class);

    OperationGETDEVICELIST(nfs_argop4 args) {
        super(args, 48);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        GETDEVICELIST4res res = new GETDEVICELIST4res();
        try {
            if (this._args.opgetdevicelist.gdla_maxdevices.value.value < 0) {
                throw new ChimeraNFSException(22, "negative maxcount");
            }
            if (this._args.opgetdevicelist.gdla_maxdevices.value.value < 1) {
                throw new ChimeraNFSException(10005, "device list too small");
            }
            res.gdlr_resok4 = new GETDEVICELIST4resok();
            res.gdlr_resok4.gdlr_cookie = new nfs_cookie4(new uint64_t(1L));
            res.gdlr_resok4.gdlr_cookieverf = new verifier4();
            res.gdlr_resok4.gdlr_cookieverf.value = new byte[8];
            List<deviceid4> deviceIDs = context.getDeviceManager().getDeviceList(context.getSession().getClient());
            int deviceListSize = Math.min(deviceIDs.size(), this._args.opgetdevicelist.gdla_maxdevices.value.value);
            res.gdlr_resok4.gdlr_deviceid_list = new deviceid4[deviceListSize];
            for (int i = 0; i < deviceListSize; ++i) {
                deviceid4 deviceId;
                res.gdlr_resok4.gdlr_deviceid_list[i] = deviceId = deviceIDs.get(i);
            }
            if (_log.isDebugEnabled()) {
                _log.debug("GETDEVICELIST4: new list of #{}, maxcount {}", new Object[]{res.gdlr_resok4.gdlr_deviceid_list.length, this._args.opgetdevicelist.gdla_maxdevices.value.value});
            }
            res.gdlr_resok4.gdlr_eof = true;
            res.gdlr_status = 0;
        }
        catch (ChimeraNFSException he) {
            _log.debug("GETDEVICELIST4: {}", (Object)he.getMessage());
            res.gdlr_status = he.getStatus();
        }
        catch (Exception e) {
            _log.error("GETDEVICELIST4:", (Throwable)e);
            res.gdlr_status = 10006;
        }
        this._result.opgetdevicelist = res;
        return this._result;
    }
}

