/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.dcache.acl.ACE;
import org.dcache.acl.enums.Who;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsStat;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.PseudoFsProvider;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.NfsIdMapping;
import org.dcache.chimera.nfs.v4.xdr.GETATTR4res;
import org.dcache.chimera.nfs.v4.xdr.GETATTR4resok;
import org.dcache.chimera.nfs.v4.xdr.aceflag4;
import org.dcache.chimera.nfs.v4.xdr.acemask4;
import org.dcache.chimera.nfs.v4.xdr.acetype4;
import org.dcache.chimera.nfs.v4.xdr.attrlist4;
import org.dcache.chimera.nfs.v4.xdr.bitmap4;
import org.dcache.chimera.nfs.v4.xdr.changeid4;
import org.dcache.chimera.nfs.v4.xdr.component4;
import org.dcache.chimera.nfs.v4.xdr.fattr4;
import org.dcache.chimera.nfs.v4.xdr.fattr4_acl;
import org.dcache.chimera.nfs.v4.xdr.fattr4_aclsupport;
import org.dcache.chimera.nfs.v4.xdr.fattr4_cansettime;
import org.dcache.chimera.nfs.v4.xdr.fattr4_case_insensitive;
import org.dcache.chimera.nfs.v4.xdr.fattr4_case_preserving;
import org.dcache.chimera.nfs.v4.xdr.fattr4_change;
import org.dcache.chimera.nfs.v4.xdr.fattr4_fh_expire_type;
import org.dcache.chimera.nfs.v4.xdr.fattr4_filehandle;
import org.dcache.chimera.nfs.v4.xdr.fattr4_fileid;
import org.dcache.chimera.nfs.v4.xdr.fattr4_files_avail;
import org.dcache.chimera.nfs.v4.xdr.fattr4_files_free;
import org.dcache.chimera.nfs.v4.xdr.fattr4_files_total;
import org.dcache.chimera.nfs.v4.xdr.fattr4_fs_layout_types;
import org.dcache.chimera.nfs.v4.xdr.fattr4_fs_locations;
import org.dcache.chimera.nfs.v4.xdr.fattr4_fsid;
import org.dcache.chimera.nfs.v4.xdr.fattr4_hidden;
import org.dcache.chimera.nfs.v4.xdr.fattr4_homogeneous;
import org.dcache.chimera.nfs.v4.xdr.fattr4_lease_time;
import org.dcache.chimera.nfs.v4.xdr.fattr4_link_support;
import org.dcache.chimera.nfs.v4.xdr.fattr4_maxfilesize;
import org.dcache.chimera.nfs.v4.xdr.fattr4_maxlink;
import org.dcache.chimera.nfs.v4.xdr.fattr4_maxname;
import org.dcache.chimera.nfs.v4.xdr.fattr4_maxread;
import org.dcache.chimera.nfs.v4.xdr.fattr4_maxwrite;
import org.dcache.chimera.nfs.v4.xdr.fattr4_mode;
import org.dcache.chimera.nfs.v4.xdr.fattr4_mounted_on_fileid;
import org.dcache.chimera.nfs.v4.xdr.fattr4_named_attr;
import org.dcache.chimera.nfs.v4.xdr.fattr4_no_trunc;
import org.dcache.chimera.nfs.v4.xdr.fattr4_numlinks;
import org.dcache.chimera.nfs.v4.xdr.fattr4_owner;
import org.dcache.chimera.nfs.v4.xdr.fattr4_rawdev;
import org.dcache.chimera.nfs.v4.xdr.fattr4_rdattr_error;
import org.dcache.chimera.nfs.v4.xdr.fattr4_size;
import org.dcache.chimera.nfs.v4.xdr.fattr4_space_free;
import org.dcache.chimera.nfs.v4.xdr.fattr4_space_total;
import org.dcache.chimera.nfs.v4.xdr.fattr4_space_used;
import org.dcache.chimera.nfs.v4.xdr.fattr4_supported_attrs;
import org.dcache.chimera.nfs.v4.xdr.fattr4_symlink_support;
import org.dcache.chimera.nfs.v4.xdr.fattr4_system;
import org.dcache.chimera.nfs.v4.xdr.fattr4_time_access;
import org.dcache.chimera.nfs.v4.xdr.fattr4_time_create;
import org.dcache.chimera.nfs.v4.xdr.fattr4_time_metadata;
import org.dcache.chimera.nfs.v4.xdr.fattr4_time_modify;
import org.dcache.chimera.nfs.v4.xdr.fattr4_type;
import org.dcache.chimera.nfs.v4.xdr.fattr4_unique_handles;
import org.dcache.chimera.nfs.v4.xdr.fs_location4;
import org.dcache.chimera.nfs.v4.xdr.fs_locations4;
import org.dcache.chimera.nfs.v4.xdr.fsid4;
import org.dcache.chimera.nfs.v4.xdr.int64_t;
import org.dcache.chimera.nfs.v4.xdr.mode4;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_fh4;
import org.dcache.chimera.nfs.v4.xdr.nfs_lease4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.v4.xdr.nfsace4;
import org.dcache.chimera.nfs.v4.xdr.nfstime4;
import org.dcache.chimera.nfs.v4.xdr.pathname4;
import org.dcache.chimera.nfs.v4.xdr.specdata4;
import org.dcache.chimera.nfs.v4.xdr.uint32_t;
import org.dcache.chimera.nfs.v4.xdr.uint64_t;
import org.dcache.chimera.nfs.v4.xdr.utf8str_cis;
import org.dcache.chimera.nfs.v4.xdr.utf8str_cs;
import org.dcache.chimera.nfs.v4.xdr.utf8str_mixed;
import org.dcache.chimera.nfs.v4.xdr.utf8string;
import org.dcache.xdr.XdrAble;
import org.dcache.xdr.XdrBuffer;
import org.dcache.xdr.XdrEncodingStream;
import org.glassfish.grizzly.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationGETATTR
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationGETATTR.class);

    public OperationGETATTR(nfs_argop4 args) {
        super(args, 9);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        GETATTR4res res = new GETATTR4res();
        try {
            res.resok4 = new GETATTR4resok();
            res.resok4.obj_attributes = OperationGETATTR.getAttributes(this._args.opgetattr.attr_request, context.currentInode(), context);
            res.status = 0;
        }
        catch (ChimeraNFSException he) {
            res.status = he.getStatus();
        }
        catch (Exception e) {
            _log.error("GETATTR:", (Throwable)e);
            res.status = 10018;
        }
        this._result.opgetattr = res;
        return this._result;
    }

    static fattr4 getAttributes(bitmap4 bitmap, FsInode inode, CompoundContext context) throws Exception {
        int[] mask = new int[bitmap.value.length];
        for (int i = 0; i < mask.length; ++i) {
            mask[i] = bitmap.value[i].value;
            _log.debug("getAttributes[{}]: {}", new Object[]{i, Integer.toBinaryString(mask[i])});
        }
        int[] retMask = new int[mask.length];
        XdrBuffer xdr = new XdrBuffer(1024);
        xdr.beginEncoding();
        if (mask.length != 0) {
            int maxAttr = 32 * mask.length;
            for (int i = 0; i < maxAttr; ++i) {
                int newmask = mask[i / 32] >> i - 32 * (i / 32);
                if ((newmask & 1) <= 0) continue;
                XdrAble attrXdr = OperationGETATTR.fattr2xdr(i, inode, context);
                if (attrXdr != null) {
                    _log.debug("   getAttributes : {} ({}) OK.", new Object[]{i, OperationGETATTR.attrMask2String(i)});
                    attrXdr.xdrEncode((XdrEncodingStream)xdr);
                    int attrmask = 1 << i - 32 * (i / 32);
                    int n = i / 32;
                    retMask[n] = retMask[n] | attrmask;
                    continue;
                }
                _log.debug("   getAttributes : {} ({}) NOT SUPPORTED.", new Object[]{i, OperationGETATTR.attrMask2String(i)});
            }
        }
        xdr.endEncoding();
        Buffer body = xdr.body();
        byte[] retBytes = new byte[body.remaining()];
        body.get(retBytes);
        fattr4 attributes = new fattr4();
        attributes.attrmask = new bitmap4();
        attributes.attrmask.value = new uint32_t[retMask.length];
        for (int i = 0; i < retMask.length; ++i) {
            attributes.attrmask.value[i] = new uint32_t(retMask[i]);
            _log.debug("getAttributes[{}] reply : {}", new Object[]{i, Integer.toBinaryString(retMask[i])});
        }
        attributes.attr_vals = new attrlist4(retBytes);
        return attributes;
    }

    private static FsStat getFsStat(FsStat fsStat, FsInode inode) throws ChimeraFsException {
        if (fsStat != null) {
            return fsStat;
        }
        return inode.getFs().getFsStat();
    }

    private static XdrAble fattr2xdr(int fattr, FsInode inode, CompoundContext context) throws Exception {
        Object ret = null;
        FsStat fsStat = null;
        if (inode instanceof PseudoFsProvider.ReferralInode && fattr != 24 && fattr != 8 && fattr != 55) {
            throw new ChimeraNFSException(10019, "inode is a referral");
        }
        switch (fattr) {
            case 0: {
                bitmap4 bitmap = new bitmap4();
                bitmap.value = new uint32_t[2];
                bitmap.value[0] = new uint32_t(-50348033);
                bitmap.value[1] = new uint32_t(1090371134);
                fattr4_supported_attrs supported_attrs = new fattr4_supported_attrs(bitmap);
                ret = supported_attrs;
                break;
            }
            case 1: {
                fattr4_type type = new fattr4_type(OperationGETATTR.unixType2NFS(inode.statCache().getMode()));
                ret = type;
                break;
            }
            case 2: {
                uint32_t fh_type = new uint32_t(0);
                fattr4_fh_expire_type fh_expire_type = new fattr4_fh_expire_type(fh_type);
                ret = fh_expire_type;
                break;
            }
            case 3: {
                changeid4 cid = new changeid4(new uint64_t(inode.stat().getCTime()));
                fattr4_change change = new fattr4_change(cid);
                ret = change;
                break;
            }
            case 4: {
                fattr4_size size = new fattr4_size(new uint64_t(inode.statCache().getSize()));
                ret = size;
                break;
            }
            case 5: {
                fattr4_link_support link_support;
                ret = link_support = new fattr4_link_support(true);
                break;
            }
            case 6: {
                fattr4_symlink_support symlink_support = new fattr4_symlink_support(true);
                ret = symlink_support;
                break;
            }
            case 7: {
                fattr4_named_attr named_attr = new fattr4_named_attr(false);
                ret = named_attr;
                break;
            }
            case 8: {
                fsid4 fsid = new fsid4();
                fsid.major = new uint64_t(inode.fsId());
                fsid.minor = new uint64_t(17L);
                fattr4_fsid id = new fattr4_fsid(fsid);
                ret = id;
                break;
            }
            case 9: {
                fattr4_unique_handles unique_handles = new fattr4_unique_handles(true);
                ret = unique_handles;
                break;
            }
            case 10: {
                fattr4_lease_time lease_time = new fattr4_lease_time(new nfs_lease4(new uint32_t(90)));
                ret = lease_time;
                break;
            }
            case 11: {
                fattr4_rdattr_error rdattr_error = new fattr4_rdattr_error(0);
                ret = rdattr_error;
                break;
            }
            case 19: {
                nfs_fh4 fh = new nfs_fh4();
                fh.value = context.getFs().inodeToBytes(inode);
                fattr4_filehandle filehandle = new fattr4_filehandle(fh);
                ret = filehandle;
                break;
            }
            case 12: {
                nfsace4[] aces;
                List dacl = context.getFs().getACL(inode);
                if (dacl != null && !dacl.isEmpty()) {
                    aces = new nfsace4[dacl.size()];
                    int i = 0;
                    for (ACE ace : dacl) {
                        aces[i] = OperationGETATTR.valueOf(ace, context.getIdMapping());
                        ++i;
                    }
                } else {
                    aces = new nfsace4[]{};
                }
                fattr4_acl acl = new fattr4_acl(aces);
                ret = acl;
                break;
            }
            case 13: {
                fattr4_aclsupport aclSupport = new fattr4_aclsupport();
                aclSupport.value = new uint32_t();
                aclSupport.value.value = 3;
                ret = aclSupport;
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                fattr4_cansettime cansettime = new fattr4_cansettime(true);
                ret = cansettime;
                break;
            }
            case 16: {
                fattr4_case_insensitive caseinsensitive = new fattr4_case_insensitive(true);
                ret = caseinsensitive;
                break;
            }
            case 17: {
                fattr4_case_preserving casepreserving = new fattr4_case_preserving(true);
                ret = casepreserving;
                break;
            }
            case 18: {
                break;
            }
            case 20: {
                fattr4_fileid fileid = new fattr4_fileid(new uint64_t(inode.id()));
                ret = fileid;
                break;
            }
            case 21: {
                fsStat = OperationGETATTR.getFsStat(fsStat, inode);
                fattr4_files_avail files_avail = new fattr4_files_avail(new uint64_t(fsStat.getTotalFiles() - fsStat.getUsedFiles()));
                ret = files_avail;
                break;
            }
            case 22: {
                fsStat = OperationGETATTR.getFsStat(fsStat, inode);
                fattr4_files_free files_free = new fattr4_files_free(new uint64_t(fsStat.getTotalFiles() - fsStat.getUsedFiles()));
                ret = files_free;
                break;
            }
            case 23: {
                fsStat = OperationGETATTR.getFsStat(fsStat, inode);
                fattr4_files_total files_total = new fattr4_files_total(new uint64_t(fsStat.getTotalFiles()));
                ret = files_total;
                break;
            }
            case 24: {
                PseudoFsProvider.ReferralInode referral = (PseudoFsProvider.ReferralInode)inode;
                String myserver = referral.getHost();
                String rootPath = referral.getPath();
                String st = referral.getExport();
                fs_location4 fs_location42 = new fs_location4();
                utf8str_cis[] servers = new utf8str_cis[]{new utf8str_cis(new utf8string(myserver.getBytes()))};
                fs_location42.server = servers;
                component4[] compRootPath = new component4[]{new component4(new utf8str_cs(new utf8string(rootPath.getBytes())))};
                fs_location42.rootpath = new pathname4(compRootPath);
                fs_locations4 fs_locations42 = new fs_locations4();
                component4[] comp = new component4[]{new component4(new utf8str_cs(new utf8string(st.getBytes())))};
                fs_locations42.fs_root = new pathname4(comp);
                fs_location4[] locations = new fs_location4[]{fs_location42};
                fs_locations42.locations = locations;
                fattr4_fs_locations att_fs_locations = new fattr4_fs_locations(fs_locations42);
                ret = att_fs_locations;
                break;
            }
            case 25: {
                fattr4_hidden hidden = new fattr4_hidden(false);
                ret = hidden;
                break;
            }
            case 26: {
                fattr4_homogeneous homogeneous = new fattr4_homogeneous(true);
                ret = homogeneous;
                break;
            }
            case 27: {
                fattr4_maxfilesize maxfilesize = new fattr4_maxfilesize(new uint64_t(Long.MAX_VALUE));
                ret = maxfilesize;
                break;
            }
            case 28: {
                fattr4_maxlink maxlink = new fattr4_maxlink(new uint32_t(255));
                ret = maxlink;
                break;
            }
            case 29: {
                fattr4_maxname maxname = new fattr4_maxname(new uint32_t(255));
                ret = maxname;
                break;
            }
            case 30: {
                fattr4_maxread maxread = new fattr4_maxread(new uint64_t(0x400000L));
                ret = maxread;
                break;
            }
            case 31: {
                fattr4_maxwrite maxwrite = new fattr4_maxwrite(new uint64_t(0x400000L));
                ret = maxwrite;
                break;
            }
            case 32: {
                break;
            }
            case 33: {
                mode4 fmode = new mode4();
                fmode.value = new uint32_t(inode.statCache().getMode() & 0xFFF);
                fattr4_mode mode = new fattr4_mode(fmode);
                ret = mode;
                break;
            }
            case 34: {
                fattr4_no_trunc no_trunc = new fattr4_no_trunc(true);
                ret = no_trunc;
                break;
            }
            case 35: {
                uint32_t nlinks = new uint32_t(inode.statCache().getNlink());
                fattr4_numlinks numlinks = new fattr4_numlinks(nlinks);
                ret = numlinks;
                break;
            }
            case 36: {
                String owner_s = context.getIdMapping().uidToPrincipal(inode.statCache().getUid());
                utf8str_mixed user = new utf8str_mixed(owner_s);
                fattr4_owner owner = new fattr4_owner(user);
                ret = owner;
                break;
            }
            case 37: {
                String group_s = context.getIdMapping().gidToPrincipal(inode.statCache().getGid());
                utf8str_mixed group = new utf8str_mixed(group_s);
                fattr4_owner owner_group = new fattr4_owner(group);
                ret = owner_group;
                break;
            }
            case 38: {
                break;
            }
            case 39: {
                break;
            }
            case 40: {
                break;
            }
            case 41: {
                specdata4 dev = new specdata4();
                dev.specdata1 = new uint32_t(0);
                dev.specdata2 = new uint32_t(0);
                fattr4_rawdev rawdev = new fattr4_rawdev(dev);
                ret = rawdev;
                break;
            }
            case 42: {
                fsStat = OperationGETATTR.getFsStat(fsStat, inode);
                uint64_t spaceAvail = new uint64_t(fsStat.getTotalSpace() - fsStat.getUsedSpace());
                ret = spaceAvail;
                break;
            }
            case 43: {
                fsStat = OperationGETATTR.getFsStat(fsStat, inode);
                fattr4_space_free space_free = new fattr4_space_free(new uint64_t(fsStat.getTotalSpace() - fsStat.getUsedSpace()));
                ret = space_free;
                break;
            }
            case 44: {
                fsStat = OperationGETATTR.getFsStat(fsStat, inode);
                fattr4_space_total space_total = new fattr4_space_total(new uint64_t(fsStat.getTotalSpace()));
                ret = space_total;
                break;
            }
            case 45: {
                fattr4_space_used space_used = new fattr4_space_used(new uint64_t(inode.statCache().getSize()));
                ret = space_used;
                break;
            }
            case 46: {
                fattr4_system system = new fattr4_system(false);
                ret = system;
                break;
            }
            case 47: {
                nfstime4 atime = new nfstime4();
                atime.seconds = new int64_t(TimeUnit.SECONDS.convert(inode.statCache().getATime(), TimeUnit.MILLISECONDS));
                atime.nseconds = new uint32_t(0);
                fattr4_time_access time_access = new fattr4_time_access(atime);
                ret = time_access;
                break;
            }
            case 49: {
                break;
            }
            case 50: {
                nfstime4 ctime = new nfstime4();
                ctime.seconds = new int64_t(TimeUnit.SECONDS.convert(inode.statCache().getCTime(), TimeUnit.MILLISECONDS));
                ctime.nseconds = new uint32_t(0);
                fattr4_time_create time_create = new fattr4_time_create(ctime);
                ret = time_create;
                break;
            }
            case 51: {
                break;
            }
            case 52: {
                nfstime4 mdtime = new nfstime4();
                mdtime.seconds = new int64_t(TimeUnit.SECONDS.convert(inode.statCache().getCTime(), TimeUnit.MILLISECONDS));
                mdtime.nseconds = new uint32_t(0);
                fattr4_time_metadata time_metadata = new fattr4_time_metadata(mdtime);
                ret = time_metadata;
                break;
            }
            case 53: {
                nfstime4 mtime = new nfstime4();
                mtime.seconds = new int64_t(TimeUnit.SECONDS.convert(inode.statCache().getMTime(), TimeUnit.MILLISECONDS));
                mtime.nseconds = new uint32_t(0);
                fattr4_time_modify time_modify = new fattr4_time_modify(mtime);
                ret = time_modify;
                break;
            }
            case 55: {
                long mofi = inode.id();
                if (mofi == 11575866L) {
                    mofi = 305419896L;
                }
                uint64_t rootid = new uint64_t(mofi);
                fattr4_mounted_on_fileid mounted_on_fileid = new fattr4_mounted_on_fileid(rootid);
                ret = mounted_on_fileid;
                break;
            }
            case 62: {
                fattr4_fs_layout_types fs_layout_type = new fattr4_fs_layout_types();
                fs_layout_type.value = new int[1];
                fs_layout_type.value[0] = 1;
                ret = fs_layout_type;
                break;
            }
            case 48: 
            case 54: {
                throw new ChimeraNFSException(22, "getattr of write-only attributes");
            }
            default: {
                _log.debug("GETATTR for #{}", (Object)fattr);
            }
        }
        return ret;
    }

    public static String attrMask2String(int offset) {
        String maskName = "Unknown";
        switch (offset) {
            case 0: {
                maskName = " FATTR4_SUPPORTED_ATTRS ";
                break;
            }
            case 1: {
                maskName = " FATTR4_TYPE ";
                break;
            }
            case 2: {
                maskName = " FATTR4_FH_EXPIRE_TYPE ";
                break;
            }
            case 3: {
                maskName = " FATTR4_CHANGE ";
                break;
            }
            case 4: {
                maskName = " FATTR4_SIZE ";
                break;
            }
            case 5: {
                maskName = " FATTR4_LINK_SUPPORT ";
                break;
            }
            case 6: {
                maskName = " FATTR4_SYMLINK_SUPPORT ";
                break;
            }
            case 7: {
                maskName = " FATTR4_NAMED_ATTR ";
                break;
            }
            case 8: {
                maskName = " FATTR4_FSID ";
                break;
            }
            case 9: {
                maskName = " FATTR4_UNIQUE_HANDLES ";
                break;
            }
            case 10: {
                maskName = " FATTR4_LEASE_TIME ";
                break;
            }
            case 11: {
                maskName = " FATTR4_RDATTR_ERROR ";
                break;
            }
            case 19: {
                maskName = " FATTR4_FILEHANDLE ";
                break;
            }
            case 12: {
                maskName = " FATTR4_ACL ";
                break;
            }
            case 13: {
                maskName = " FATTR4_ACLSUPPORT ";
                break;
            }
            case 14: {
                maskName = " FATTR4_ARCHIVE ";
                break;
            }
            case 15: {
                maskName = " FATTR4_CANSETTIME ";
                break;
            }
            case 16: {
                maskName = " FATTR4_CASE_INSENSITIVE ";
                break;
            }
            case 17: {
                maskName = " FATTR4_CASE_PRESERVING ";
                break;
            }
            case 18: {
                maskName = " FATTR4_CHOWN_RESTRICTED ";
                break;
            }
            case 20: {
                maskName = " FATTR4_FILEID ";
                break;
            }
            case 21: {
                maskName = " FATTR4_FILES_AVAIL ";
                break;
            }
            case 22: {
                maskName = " FATTR4_FILES_FREE ";
                break;
            }
            case 23: {
                maskName = " FATTR4_FILES_TOTAL ";
                break;
            }
            case 24: {
                maskName = " FATTR4_FS_LOCATIONS ";
                break;
            }
            case 25: {
                maskName = " FATTR4_HIDDEN ";
                break;
            }
            case 26: {
                maskName = " FATTR4_HOMOGENEOUS ";
                break;
            }
            case 27: {
                maskName = " FATTR4_MAXFILESIZE ";
                break;
            }
            case 28: {
                maskName = " FATTR4_MAXLINK ";
                break;
            }
            case 29: {
                maskName = " FATTR4_MAXNAME ";
                break;
            }
            case 30: {
                maskName = " FATTR4_MAXREAD ";
                break;
            }
            case 31: {
                maskName = " FATTR4_MAXWRITE ";
                break;
            }
            case 32: {
                maskName = " FATTR4_MIMETYPE ";
                break;
            }
            case 33: {
                maskName = " FATTR4_MODE ";
                break;
            }
            case 34: {
                maskName = " FATTR4_NO_TRUNC ";
                break;
            }
            case 35: {
                maskName = " FATTR4_NUMLINKS ";
                break;
            }
            case 36: {
                maskName = " FATTR4_OWNER ";
                break;
            }
            case 37: {
                maskName = " FATTR4_OWNER_GROUP ";
                break;
            }
            case 38: {
                maskName = " FATTR4_QUOTA_AVAIL_HARD ";
                break;
            }
            case 39: {
                maskName = " FATTR4_QUOTA_AVAIL_SOFT ";
                break;
            }
            case 40: {
                maskName = " FATTR4_QUOTA_USED ";
                break;
            }
            case 41: {
                maskName = " FATTR4_RAWDEV ";
                break;
            }
            case 42: {
                maskName = " FATTR4_SPACE_AVAIL ";
                break;
            }
            case 43: {
                maskName = " FATTR4_SPACE_FREE ";
                break;
            }
            case 44: {
                maskName = " FATTR4_SPACE_TOTAL ";
                break;
            }
            case 45: {
                maskName = " FATTR4_SPACE_USED ";
                break;
            }
            case 46: {
                maskName = " FATTR4_SYSTEM ";
                break;
            }
            case 47: {
                maskName = " FATTR4_TIME_ACCESS ";
                break;
            }
            case 48: {
                maskName = " FATTR4_TIME_ACCESS_SET ";
                break;
            }
            case 49: {
                maskName = " FATTR4_TIME_BACKUP ";
                break;
            }
            case 50: {
                maskName = " FATTR4_TIME_CREATE ";
                break;
            }
            case 51: {
                maskName = " FATTR4_TIME_DELTA ";
                break;
            }
            case 52: {
                maskName = " FATTR4_TIME_METADATA ";
                break;
            }
            case 53: {
                maskName = " FATTR4_TIME_MODIFY ";
                break;
            }
            case 54: {
                maskName = " FATTR4_TIME_MODIFY_SET ";
                break;
            }
            case 55: {
                maskName = " FATTR4_MOUNTED_ON_FILEID ";
                break;
            }
            case 62: {
                maskName = " FATTR4_FS_LAYOUT_TYPE ";
                break;
            }
            case 63: {
                maskName = " FATTR4_LAYOUT_HINT ";
                break;
            }
            case 64: {
                maskName = " FATTR4_LAYOUT_TYPE ";
                break;
            }
            case 65: {
                maskName = " FATTR4_LAYOUT_BLKSIZE ";
                break;
            }
            case 66: {
                maskName = " FATTR4_LAYOUT_ALIGNMENT ";
                break;
            }
            case 67: {
                maskName = " FATTR4_FS_LOCATIONS_INFO ";
                break;
            }
            case 68: {
                maskName = " FATTR4_MDSTHRESHOLD ";
                break;
            }
            case 69: {
                maskName = " FATTR4_RETENTION_GET ";
                break;
            }
            case 70: {
                maskName = " FATTR4_RETENTION_SET ";
                break;
            }
            case 71: {
                maskName = " FATTR4_RETENTEVT_GET ";
                break;
            }
            case 72: {
                maskName = " FATTR4_RETENTEVT_SET ";
                break;
            }
            case 73: {
                maskName = " FATTR4_RETENTION_HOLD ";
                break;
            }
            case 74: {
                maskName = " FATTR4_MODE_SET_MASKED ";
                break;
            }
            case 76: {
                maskName = " FATTR4_FS_CHARSET_CAP ";
                break;
            }
            default: {
                maskName = maskName + "(" + offset + ")";
            }
        }
        return maskName;
    }

    static int unixType2NFS(int type) {
        int ret = 0;
        int mask = 258048;
        switch (type & mask) {
            case 32768: {
                ret = 1;
                break;
            }
            case 16384: {
                ret = 2;
                break;
            }
            case 40960: {
                ret = 5;
                break;
            }
            case 49152: {
                ret = 6;
                break;
            }
            case 24576: {
                ret = 3;
                break;
            }
            case 8192: {
                ret = 4;
                break;
            }
            case 4096: {
                ret = 7;
                break;
            }
            default: {
                _log.info("Unknown mode [" + Integer.toOctalString(type) + "]");
                ret = 0;
            }
        }
        return ret;
    }

    private static nfsace4 valueOf(ACE ace, NfsIdMapping idMapping) {
        String subject = ace.getWho() == Who.USER ? idMapping.uidToPrincipal(ace.getWhoID()) : idMapping.gidToPrincipal(ace.getWhoID());
        nfsace4 nfsace = new nfsace4();
        nfsace.access_mask = new acemask4(new uint32_t(ace.getAccessMsk()));
        nfsace.flag = new aceflag4(new uint32_t(ace.getFlags()));
        nfsace.type = new acetype4(new uint32_t(ace.getType().getValue()));
        nfsace.who = new utf8str_mixed(subject);
        return nfsace;
    }
}

