/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.NFS4Client;
import org.dcache.chimera.nfs.v4.NFSv41Session;
import org.dcache.chimera.nfs.v4.xdr.CREATE_SESSION4res;
import org.dcache.chimera.nfs.v4.xdr.CREATE_SESSION4resok;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.v4.xdr.uint32_t;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationCREATE_SESSION
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationCREATE_SESSION.class);

    public OperationCREATE_SESSION(nfs_argop4 args) {
        super(args, 43);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        CREATE_SESSION4res res = new CREATE_SESSION4res();
        Long clientId = this._args.opcreate_session.csa_clientid.value.value;
        try {
            if (this._args.opcreate_session.csa_fore_chan_attrs.ca_rdma_ird.length > 1) {
                throw new ChimeraNFSException(10036, "bad size of rdma_ird");
            }
            if ((this._args.opcreate_session.csa_flags.value & 0xFFFFFFF8) != 0) {
                throw new ChimeraNFSException(22, "bad ceate_session flag");
            }
            NFS4Client client = context.getStateHandler().getClientByID(clientId);
            if (client == null) {
                throw new ChimeraNFSException(10022, "client not known");
            }
            if (!client.principal().equals(Integer.toString(context.getUser().getUID())) && !client.isConfirmed()) {
                throw new ChimeraNFSException(10017, "client already in use: " + client.principal() + " " + context.getUser().getUID());
            }
            NFSv41Session session = client.createSession(this._args.opcreate_session.csa_sequence.value.value, this._args.opcreate_session.csa_fore_chan_attrs.ca_maxrequests.value.value);
            _log.debug("adding new session [{}]", (Object)session);
            context.getStateHandler().sessionById(session.id(), session);
            client.refreshLeaseTime();
            res.csr_resok4 = new CREATE_SESSION4resok();
            res.csr_resok4.csr_sessionid = session.id();
            res.csr_resok4.csr_sequence = this._args.opcreate_session.csa_sequence;
            res.csr_resok4.csr_flags = new uint32_t(this._args.opcreate_session.csa_flags.value ^ 2);
            res.csr_resok4.csr_fore_chan_attrs = this._args.opcreate_session.csa_fore_chan_attrs;
            res.csr_resok4.csr_back_chan_attrs = this._args.opcreate_session.csa_back_chan_attrs;
            res.csr_status = 0;
        }
        catch (ChimeraNFSException ne) {
            _log.debug("CREATE_SESSION4res : {}", (Object)ne.getMessage());
            res.csr_status = ne.getStatus();
        }
        catch (Exception e) {
            _log.error("CREATE_SESSION4 :", (Throwable)e);
            res.csr_status = 10006;
        }
        this._result.opcreate_session = res;
        return this._result;
    }
}

