/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import org.dcache.chimera.FileNotFoundHimeraFsException;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.OperationSETATTR;
import org.dcache.chimera.nfs.v4.xdr.CREATE4res;
import org.dcache.chimera.nfs.v4.xdr.CREATE4resok;
import org.dcache.chimera.nfs.v4.xdr.change_info4;
import org.dcache.chimera.nfs.v4.xdr.changeid4;
import org.dcache.chimera.nfs.v4.xdr.fattr4;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.v4.xdr.uint64_t;
import org.dcache.chimera.posix.Acl;
import org.dcache.chimera.posix.Stat;
import org.dcache.chimera.posix.UnixAcl;
import org.dcache.chimera.posix.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationCREATE
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationCREATE.class);

    OperationCREATE(nfs_argop4 args) {
        super(args, 6);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        CREATE4res res = new CREATE4res();
        fattr4 objAttr = this._args.opcreate.createattrs;
        int type = this._args.opcreate.objtype.type;
        String name2 = new String(this._args.opcreate.objname.value.value.value);
        FsInode inode = null;
        try {
            Stat parentStat = context.currentInode().statCache();
            UnixAcl fileAcl = new UnixAcl(parentStat.getUid(), parentStat.getGid(), parentStat.getMode() & 0x1FF);
            if (!context.getAclHandler().isAllowed((Acl)fileAcl, (User)context.getUser(), 6)) {
                throw new ChimeraNFSException(13, "Permission denied.");
            }
            if (name2.length() == 0) {
                throw new ChimeraNFSException(22, "bad path name");
            }
            if (name2.length() > 255) {
                throw new ChimeraNFSException(63, "name too long");
            }
            if (!context.currentInode().isDirectory()) {
                throw new ChimeraNFSException(20, "not a directory");
            }
            if (name2.equals(".") || name2.equals("..")) {
                throw new ChimeraNFSException(10041, "bad name '.' or '..'");
            }
            try {
                inode = context.currentInode().inodeOf(name2);
                throw new ChimeraNFSException(17, "path already exist");
            }
            catch (FileNotFoundHimeraFsException hfe) {
                switch (type) {
                    case 2: {
                        inode = context.currentInode().mkdir(name2);
                        break;
                    }
                    case 5: {
                        byte[] linkDest = this._args.opcreate.objtype.linkdata.value.value.value;
                        inode = context.getFs().createLink(context.currentInode(), name2, context.getUser().getUID(), context.getUser().getGID(), 777, linkDest);
                        break;
                    }
                    case 3: {
                        inode = context.getFs().createFile(context.currentInode(), name2, context.getUser().getUID(), context.getUser().getGID(), 777, 24576);
                        break;
                    }
                    case 4: {
                        inode = context.getFs().createFile(context.currentInode(), name2, context.getUser().getUID(), context.getUser().getGID(), 777, 8192);
                        break;
                    }
                    case 7: {
                        inode = context.getFs().createFile(context.currentInode(), name2, context.getUser().getUID(), context.getUser().getGID(), 777, 4096);
                        break;
                    }
                    case 6: {
                        inode = context.getFs().createFile(context.currentInode(), name2, context.getUser().getUID(), context.getUser().getGID(), 777, 49152);
                        break;
                    }
                    case 8: 
                    case 9: {
                        throw new ChimeraNFSException(10004, "create of this type not supported");
                    }
                    case 1: {
                        throw new ChimeraNFSException(10007, "create of regular files handled by OPEN");
                    }
                    default: {
                        throw new ChimeraNFSException(10007, "bad file type");
                    }
                }
                inode.setGID(context.getUser().getGID());
                inode.setUID(context.getUser().getUID());
                res.status = 0;
                res.resok4 = new CREATE4resok();
                res.resok4.attrset = OperationSETATTR.setAttributes(objAttr, inode, context);
                res.resok4.cinfo = new change_info4();
                res.resok4.cinfo.atomic = true;
                res.resok4.cinfo.before = new changeid4(new uint64_t(context.currentInode().statCache().getMTime()));
                res.resok4.cinfo.after = new changeid4(new uint64_t(System.currentTimeMillis()));
                context.currentInode(inode);
            }
        }
        catch (ChimeraNFSException he) {
            _log.debug("CREATE: {}", (Object)he.getMessage());
            res.status = he.getStatus();
        }
        catch (Exception e) {
            _log.error("CREATE: ", (Throwable)e);
            res.status = 10006;
        }
        this._result.opcreate = res;
        return this._result;
    }
}

