/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import java.io.IOException;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.xdr.CLOSE4res;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.v4.xdr.stateid4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationCLOSE
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationCLOSE.class);

    OperationCLOSE(nfs_argop4 args) {
        super(args, 4);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        CLOSE4res res = new CLOSE4res();
        try {
            FsInode inode = context.currentInode();
            if (context.getMinorversion() > 0) {
                context.getSession().getClient().updateLeaseTime();
                try {
                    context.getDeviceManager().layoutReturn(context.getSession().getClient(), this._args.opclose.open_stateid);
                }
                catch (IOException e) {
                    _log.error("Failed to return a layout: {}", (Object)e.getMessage());
                }
            } else {
                context.getStateHandler().updateClientLeaseTime(this._args.opclose.open_stateid);
            }
            res.open_stateid = stateid4.INVAL_STATEID;
            res.status = 0;
        }
        catch (ChimeraNFSException he) {
            _log.debug("CLOSE: {}", (Object)he.getMessage());
            res.status = he.getStatus();
        }
        this._result.opclose = res;
        return this._result;
    }
}

