/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.xdr.ACCESS4res;
import org.dcache.chimera.nfs.v4.xdr.ACCESS4resok;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.nfs.v4.xdr.uint32_t;
import org.dcache.chimera.posix.Acl;
import org.dcache.chimera.posix.Stat;
import org.dcache.chimera.posix.UnixAcl;
import org.dcache.chimera.posix.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationACCESS
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationACCESS.class);

    OperationACCESS(nfs_argop4 args) {
        super(args, 3);
    }

    @Override
    public nfs_resop4 process(CompoundContext context) {
        ACCESS4res res = new ACCESS4res();
        _log.debug("NFS Request ACCESS uid: {}", (Object)context.getUser());
        try {
            int reqAccess = this._args.opaccess.access.value;
            Stat objStat = context.currentInode().statCache();
            UnixAcl acl = new UnixAcl(objStat.getUid(), objStat.getGid(), objStat.getMode() & 0x1FF);
            int realAccess = 0;
            if ((reqAccess & 0x20) == 32 && context.getAclHandler().isAllowed((Acl)acl, (User)context.getUser(), 8)) {
                realAccess |= 0x20;
            }
            if ((reqAccess & 8) == 8 && context.getAclHandler().isAllowed((Acl)acl, (User)context.getUser(), 6)) {
                realAccess |= 8;
            }
            if ((reqAccess & 2) == 2 && context.getAclHandler().isAllowed((Acl)acl, (User)context.getUser(), 4)) {
                realAccess |= 2;
            }
            if ((reqAccess & 0x10) == 16 && context.getAclHandler().isAllowed((Acl)acl, (User)context.getUser(), 3)) {
                realAccess |= 0x10;
            }
            if ((reqAccess & 4) == 4 && context.getAclHandler().isAllowed((Acl)acl, (User)context.getUser(), 2)) {
                realAccess |= 4;
            }
            if ((reqAccess & 1) == 1 && context.getAclHandler().isAllowed((Acl)acl, (User)context.getUser(), 0)) {
                realAccess |= 1;
            }
            res.resok4 = new ACCESS4resok();
            res.resok4.access = new uint32_t(realAccess);
            res.resok4.supported = new uint32_t(realAccess);
            res.status = 0;
        }
        catch (ChimeraNFSException he) {
            _log.debug("ACCESS: {}", (Object)he.getMessage());
            res.status = he.getStatus();
        }
        catch (Exception e) {
            _log.error("ACCESS:", (Throwable)e);
            res.status = 10018;
        }
        this._result.opaccess = res;
        return this._result;
    }
}

