/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.ExportFile;
import org.dcache.chimera.nfs.PseudoFsProvider;
import org.dcache.chimera.nfs.v4.CompoundContext;
import org.dcache.chimera.nfs.v4.NFS4Client;
import org.dcache.chimera.nfs.v4.NFSv41DeviceManager;
import org.dcache.chimera.nfs.v4.NFSv4OperationFactory;
import org.dcache.chimera.nfs.v4.NFSv4StateHandler;
import org.dcache.chimera.nfs.v4.NfsIdMapping;
import org.dcache.chimera.nfs.v4.ServerIdProvider;
import org.dcache.chimera.nfs.v4.xdr.COMPOUND4args;
import org.dcache.chimera.nfs.v4.xdr.COMPOUND4res;
import org.dcache.chimera.nfs.v4.xdr.nfs4_prot_NFS4_PROGRAM_ServerStub;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.nfs_opnum4;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.posix.AclHandler;
import org.dcache.commons.stats.RequestExecutionTimeGauges;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.RpcCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class NFSServerV41
extends nfs4_prot_NFS4_PROGRAM_ServerStub {
    private final FileSystemProvider _fs;
    private final ExportFile _exportFile;
    private static final Logger _log = LoggerFactory.getLogger(NFSServerV41.class);
    private final NFSv4OperationFactory _operationFactory;
    private final NFSv41DeviceManager _deviceManager;
    private final AclHandler _aclHandler;
    private final NFSv4StateHandler _statHandler = new NFSv4StateHandler();
    private final NfsIdMapping _idMapping;
    private final ServerIdProvider _idProvider;
    private static final RequestExecutionTimeGauges<String> GAUGES = new RequestExecutionTimeGauges(NFSServerV41.class.getName());

    public NFSServerV41(NFSv4OperationFactory operationFactory, NFSv41DeviceManager deviceManager, AclHandler aclHandler, FileSystemProvider fs, NfsIdMapping idMapping, ExportFile exportFile, ServerIdProvider idProvider) throws OncRpcException, IOException {
        this._deviceManager = deviceManager;
        this._fs = fs;
        this._exportFile = exportFile;
        this._operationFactory = operationFactory;
        this._aclHandler = aclHandler;
        this._idMapping = idMapping;
        this._idProvider = idProvider;
    }

    @Override
    public void NFSPROC4_NULL_4(RpcCall call$) {
        _log.debug("NFS PING client: {}", (Object)call$.getTransport().getRemoteSocketAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public COMPOUND4res NFSPROC4_COMPOUND_4(RpcCall call$, COMPOUND4args arg1) {
        COMPOUND4res res = new COMPOUND4res();
        try {
            _log.debug("NFS COMPOUND client: {}, tag: [{}]", (Object)call$.getTransport().getRemoteSocketAddress(), (Object)new String(arg1.tag.value.value));
            MDC.put((String)"mdc.tag", (String)arg1.tag.toString());
            MDC.put((String)"mdc.client", (String)call$.getTransport().getRemoteSocketAddress().toString());
            int minorversion = arg1.minorversion.value;
            if (minorversion > 1) {
                throw new ChimeraNFSException(10021, String.format("Unsupported minor version [%d]", arg1.minorversion.value));
            }
            PseudoFsProvider vfs = new PseudoFsProvider(this._fs, this._exportFile, call$);
            CompoundContext context = new CompoundContext(arg1.minorversion.value, vfs, this._statHandler, this._deviceManager, this._aclHandler, call$, this._idMapping, this._exportFile, this._idProvider, arg1.argarray.length);
            res.status = 0;
            res.resarray = new ArrayList<nfs_resop4>(arg1.argarray.length);
            res.tag = arg1.tag;
            boolean retransmit = false;
            for (nfs_argop4 op : arg1.argarray) {
                context.nextOperation();
                int position = context.getOperationPosition();
                if (minorversion > 0) {
                    List<nfs_resop4> cache;
                    NFSServerV41.checkOpPosition(op.argop, position);
                    if (position == 1 && (cache = context.getCache()) != null) {
                        res.resarray.addAll(cache.subList(position, cache.size()));
                        res.status = NFSServerV41.statusOfLastOperation(cache);
                        retransmit = true;
                        break;
                    }
                }
                long t0 = System.currentTimeMillis();
                nfs_resop4 opResult = this._operationFactory.getOperation(op).process(context);
                GAUGES.update((Object)nfs_opnum4.toString(op.argop), System.currentTimeMillis() - t0);
                res.resarray.add(opResult);
                res.status = opResult.getStatus();
                if (res.status != 0) break;
            }
            if (!retransmit && context.cacheThis()) {
                context.getSession().updateSlotCache(context.getSlotId(), res.resarray);
            }
            _log.debug("OP: [{}] status: {}", (Object)res.tag, (Object)res.status);
        }
        catch (ChimeraNFSException e) {
            _log.info("NFS operation failed: {}", (Object)e.getMessage());
            res.resarray = Collections.EMPTY_LIST;
            res.status = e.getStatus();
            res.tag = arg1.tag;
        }
        catch (Exception e) {
            _log.error("Unhandled exception:", (Throwable)e);
            res.resarray = Collections.EMPTY_LIST;
            res.status = 10006;
            res.tag = arg1.tag;
        }
        finally {
            MDC.remove((String)"mdc.tag");
            MDC.remove((String)"mdc.client");
            MDC.remove((String)"mdc.session");
        }
        return res;
    }

    public List<NFS4Client> getClients() {
        return this._statHandler.getClients();
    }

    private static void checkOpPosition(int opCode, int position) throws ChimeraNFSException {
        block8: {
            block7: {
                if (opCode > 58 || opCode < 3) {
                    return;
                }
                if (position != 0) break block7;
                switch (opCode) {
                    case 42: 
                    case 43: 
                    case 44: 
                    case 53: {
                        break block8;
                    }
                    default: {
                        throw new ChimeraNFSException(10071, "not in session");
                    }
                }
            }
            switch (opCode) {
                case 53: {
                    throw new ChimeraNFSException(10064, "not a first operation");
                }
            }
        }
    }

    private static int statusOfLastOperation(List<nfs_resop4> ops) {
        return ops.get(ops.size() - 1).getStatus();
    }

    public RequestExecutionTimeGauges<String> getStatistics() {
        return GAUGES;
    }
}

