/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import org.dcache.chimera.nfs.v4.ServerIdProvider;
import org.dcache.chimera.nfs.v4.xdr.nfsace4;
import org.dcache.chimera.nfs.v4.xdr.server_owner4;
import org.dcache.chimera.nfs.v4.xdr.uint64_t;

public class HimeraNFS4Utils {
    private HimeraNFS4Utils() {
    }

    public static String aceToString(nfsace4 ace) {
        String who = new String(ace.who.value.value);
        int type = ace.type.value.value;
        int flag = ace.flag.value.value;
        int mask = ace.access_mask.value.value;
        return who + " " + HimeraNFS4Utils.aceType2String(type) + " " + Integer.toBinaryString(flag) + " " + Integer.toBinaryString(mask);
    }

    private static String aceType2String(int type) {
        switch (type) {
            case 0: {
                return "ALLOW";
            }
            case 1: {
                return "DENY ";
            }
            case 3: {
                return "ALARM";
            }
            case 2: {
                return "AUDIT";
            }
        }
        return ">BAD<";
    }

    public static ServerIdProvider cellNameToServerIdProvider(final String cellName) {
        return new ServerIdProvider(){

            @Override
            public server_owner4 getOwner() {
                server_owner4 owner = new server_owner4();
                owner.so_minor_id = new uint64_t(0L);
                owner.so_major_id = new byte[0];
                return owner;
            }

            @Override
            public byte[] getScope() {
                return cellName.getBytes();
            }
        };
    }
}

