/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4;

import java.util.List;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.ExportFile;
import org.dcache.chimera.nfs.NfsUser;
import org.dcache.chimera.nfs.v4.NFSv41DeviceManager;
import org.dcache.chimera.nfs.v4.NFSv41Session;
import org.dcache.chimera.nfs.v4.NFSv4StateHandler;
import org.dcache.chimera.nfs.v4.NfsIdMapping;
import org.dcache.chimera.nfs.v4.ServerIdProvider;
import org.dcache.chimera.nfs.v4.xdr.nfs_resop4;
import org.dcache.chimera.posix.AclHandler;
import org.dcache.chimera.posix.UnixUser;
import org.dcache.xdr.RpcCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompoundContext {
    private static final Logger _log = LoggerFactory.getLogger(CompoundContext.class);
    private FsInode _rootInode = null;
    private FsInode _currentInode = null;
    private FsInode _savedInode = null;
    private final int _minorversion;
    private NFSv41Session _session = null;
    private final FileSystemProvider _fs;
    private final RpcCall _callInfo;
    private final UnixUser _user;
    private final ExportFile _exportFile;
    private final NFSv41DeviceManager _deviceManager;
    private final AclHandler _aclHandler;
    private final NFSv4StateHandler _stateHandler;
    private final NfsIdMapping _idMapping;
    private final ServerIdProvider _idProvider;
    private int _slotId;
    private boolean _cacheThis;
    private final int _totalOperationsCount;
    private int _currentOpPosition = -1;
    private List<nfs_resop4> _cache;

    public CompoundContext(int minorversion, FileSystemProvider fs, NFSv4StateHandler stateHandler, NFSv41DeviceManager deviceManager, AclHandler aclHandler, RpcCall call, NfsIdMapping idMapping, ExportFile exportFile, ServerIdProvider idProvider, int opCount) {
        this._minorversion = minorversion;
        this._fs = fs;
        this._deviceManager = deviceManager;
        this._aclHandler = aclHandler;
        this._callInfo = call;
        this._exportFile = exportFile;
        this._user = NfsUser.remoteUser(this._callInfo, this._exportFile);
        this._stateHandler = stateHandler;
        this._idMapping = idMapping;
        this._idProvider = idProvider;
        this._totalOperationsCount = opCount;
    }

    public RpcCall getRpcCall() {
        return this._callInfo;
    }

    public UnixUser getUser() {
        return this._user;
    }

    public FileSystemProvider getFs() {
        return this._fs;
    }

    public NFSv41DeviceManager getDeviceManager() {
        return this._deviceManager;
    }

    public AclHandler getAclHandler() {
        return this._aclHandler;
    }

    public int getMinorversion() {
        return this._minorversion;
    }

    public FsInode currentInode() throws ChimeraNFSException {
        if (this._currentInode == null) {
            throw new ChimeraNFSException(10020, "no file handle");
        }
        return this._currentInode;
    }

    public void currentInode(FsInode inode) throws ChimeraNFSException {
        this._currentInode = inode;
        _log.debug("current Inode: {}", (Object)this._currentInode);
    }

    public void clearCurrentInode() throws ChimeraNFSException {
        this._currentInode = null;
    }

    public FsInode rootInode() {
        return this._rootInode;
    }

    public void rootInode(FsInode inode) {
        this._rootInode = inode;
        _log.debug("root Inode: {}", (Object)this._rootInode);
    }

    public void restoreSavedInode() throws ChimeraNFSException {
        if (this._savedInode == null) {
            throw new ChimeraNFSException(10030, "no saved file handle");
        }
        this._currentInode = this._savedInode;
        _log.debug("restored Inode: {}", (Object)this._currentInode);
    }

    public FsInode savedInode() throws ChimeraNFSException {
        if (this._savedInode == null) {
            throw new ChimeraNFSException(10020, "no file handle");
        }
        return this._savedInode;
    }

    public void saveCurrentInode() throws ChimeraNFSException {
        if (this._currentInode == null) {
            throw new ChimeraNFSException(10020, "no file handle");
        }
        this._savedInode = this._currentInode;
        _log.debug("saved Inode: {}", (Object)this._savedInode);
    }

    public void setSession(NFSv41Session session) {
        this._session = session;
    }

    public NFSv41Session getSession() {
        return this._session;
    }

    public NFSv4StateHandler getStateHandler() {
        return this._stateHandler;
    }

    public NfsIdMapping getIdMapping() {
        return this._idMapping;
    }

    public ServerIdProvider getServerIdProvider() {
        return this._idProvider;
    }

    public int getSlotId() {
        return this._slotId;
    }

    public void setSlotId(int slotId) {
        this._slotId = slotId;
    }

    public boolean cacheThis() {
        return this._cacheThis;
    }

    public void setCacheThis(boolean cacheThis) {
        this._cacheThis = cacheThis;
    }

    public List<nfs_resop4> getCache() {
        return this._cache;
    }

    public void setCache(List<nfs_resop4> cache) {
        this._cache = cache;
    }

    public int getOperationPosition() {
        return this._currentOpPosition;
    }

    public int getTotalOperationCount() {
        return this._totalOperationsCount;
    }

    public void nextOperation() {
        assert (this._currentOpPosition < this._totalOperationsCount);
        ++this._currentOpPosition;
    }
}

