/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v3;

import com.google.common.collect.MapMaker;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.DirectoryStreamHelper;
import org.dcache.chimera.FileNotFoundHimeraFsException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsStat;
import org.dcache.chimera.HimeraDirectoryEntry;
import org.dcache.chimera.IOHimeraFsException;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.ExportFile;
import org.dcache.chimera.nfs.InodeCacheEntry;
import org.dcache.chimera.nfs.NfsUser;
import org.dcache.chimera.nfs.v3.HimeraNfsUtils;
import org.dcache.chimera.nfs.v3.xdr.ACCESS3args;
import org.dcache.chimera.nfs.v3.xdr.ACCESS3res;
import org.dcache.chimera.nfs.v3.xdr.ACCESS3resfail;
import org.dcache.chimera.nfs.v3.xdr.ACCESS3resok;
import org.dcache.chimera.nfs.v3.xdr.COMMIT3args;
import org.dcache.chimera.nfs.v3.xdr.COMMIT3res;
import org.dcache.chimera.nfs.v3.xdr.COMMIT3resfail;
import org.dcache.chimera.nfs.v3.xdr.CREATE3args;
import org.dcache.chimera.nfs.v3.xdr.CREATE3res;
import org.dcache.chimera.nfs.v3.xdr.CREATE3resfail;
import org.dcache.chimera.nfs.v3.xdr.CREATE3resok;
import org.dcache.chimera.nfs.v3.xdr.FSINFO3args;
import org.dcache.chimera.nfs.v3.xdr.FSINFO3res;
import org.dcache.chimera.nfs.v3.xdr.FSINFO3resfail;
import org.dcache.chimera.nfs.v3.xdr.FSINFO3resok;
import org.dcache.chimera.nfs.v3.xdr.FSSTAT3args;
import org.dcache.chimera.nfs.v3.xdr.FSSTAT3res;
import org.dcache.chimera.nfs.v3.xdr.FSSTAT3resfail;
import org.dcache.chimera.nfs.v3.xdr.FSSTAT3resok;
import org.dcache.chimera.nfs.v3.xdr.GETATTR3args;
import org.dcache.chimera.nfs.v3.xdr.GETATTR3res;
import org.dcache.chimera.nfs.v3.xdr.GETATTR3resok;
import org.dcache.chimera.nfs.v3.xdr.LINK3args;
import org.dcache.chimera.nfs.v3.xdr.LINK3res;
import org.dcache.chimera.nfs.v3.xdr.LINK3resfail;
import org.dcache.chimera.nfs.v3.xdr.LINK3resok;
import org.dcache.chimera.nfs.v3.xdr.LOOKUP3args;
import org.dcache.chimera.nfs.v3.xdr.LOOKUP3res;
import org.dcache.chimera.nfs.v3.xdr.LOOKUP3resfail;
import org.dcache.chimera.nfs.v3.xdr.LOOKUP3resok;
import org.dcache.chimera.nfs.v3.xdr.MKDIR3args;
import org.dcache.chimera.nfs.v3.xdr.MKDIR3res;
import org.dcache.chimera.nfs.v3.xdr.MKDIR3resfail;
import org.dcache.chimera.nfs.v3.xdr.MKDIR3resok;
import org.dcache.chimera.nfs.v3.xdr.MKNOD3args;
import org.dcache.chimera.nfs.v3.xdr.MKNOD3res;
import org.dcache.chimera.nfs.v3.xdr.MKNOD3resfail;
import org.dcache.chimera.nfs.v3.xdr.PATHCONF3args;
import org.dcache.chimera.nfs.v3.xdr.PATHCONF3res;
import org.dcache.chimera.nfs.v3.xdr.PATHCONF3resok;
import org.dcache.chimera.nfs.v3.xdr.READ3args;
import org.dcache.chimera.nfs.v3.xdr.READ3res;
import org.dcache.chimera.nfs.v3.xdr.READ3resfail;
import org.dcache.chimera.nfs.v3.xdr.READ3resok;
import org.dcache.chimera.nfs.v3.xdr.READDIR3args;
import org.dcache.chimera.nfs.v3.xdr.READDIR3res;
import org.dcache.chimera.nfs.v3.xdr.READDIR3resfail;
import org.dcache.chimera.nfs.v3.xdr.READDIR3resok;
import org.dcache.chimera.nfs.v3.xdr.READDIRPLUS3args;
import org.dcache.chimera.nfs.v3.xdr.READDIRPLUS3res;
import org.dcache.chimera.nfs.v3.xdr.READDIRPLUS3resfail;
import org.dcache.chimera.nfs.v3.xdr.READDIRPLUS3resok;
import org.dcache.chimera.nfs.v3.xdr.READLINK3args;
import org.dcache.chimera.nfs.v3.xdr.READLINK3res;
import org.dcache.chimera.nfs.v3.xdr.READLINK3resfail;
import org.dcache.chimera.nfs.v3.xdr.READLINK3resok;
import org.dcache.chimera.nfs.v3.xdr.REMOVE3args;
import org.dcache.chimera.nfs.v3.xdr.REMOVE3res;
import org.dcache.chimera.nfs.v3.xdr.REMOVE3resfail;
import org.dcache.chimera.nfs.v3.xdr.REMOVE3resok;
import org.dcache.chimera.nfs.v3.xdr.RENAME3args;
import org.dcache.chimera.nfs.v3.xdr.RENAME3res;
import org.dcache.chimera.nfs.v3.xdr.RENAME3resfail;
import org.dcache.chimera.nfs.v3.xdr.RENAME3resok;
import org.dcache.chimera.nfs.v3.xdr.RMDIR3args;
import org.dcache.chimera.nfs.v3.xdr.RMDIR3res;
import org.dcache.chimera.nfs.v3.xdr.RMDIR3resfail;
import org.dcache.chimera.nfs.v3.xdr.RMDIR3resok;
import org.dcache.chimera.nfs.v3.xdr.SETATTR3args;
import org.dcache.chimera.nfs.v3.xdr.SETATTR3res;
import org.dcache.chimera.nfs.v3.xdr.SETATTR3resfail;
import org.dcache.chimera.nfs.v3.xdr.SETATTR3resok;
import org.dcache.chimera.nfs.v3.xdr.SYMLINK3args;
import org.dcache.chimera.nfs.v3.xdr.SYMLINK3res;
import org.dcache.chimera.nfs.v3.xdr.SYMLINK3resfail;
import org.dcache.chimera.nfs.v3.xdr.SYMLINK3resok;
import org.dcache.chimera.nfs.v3.xdr.WRITE3args;
import org.dcache.chimera.nfs.v3.xdr.WRITE3res;
import org.dcache.chimera.nfs.v3.xdr.WRITE3resfail;
import org.dcache.chimera.nfs.v3.xdr.WRITE3resok;
import org.dcache.chimera.nfs.v3.xdr.cookie3;
import org.dcache.chimera.nfs.v3.xdr.cookieverf3;
import org.dcache.chimera.nfs.v3.xdr.count3;
import org.dcache.chimera.nfs.v3.xdr.dirlist3;
import org.dcache.chimera.nfs.v3.xdr.dirlistplus3;
import org.dcache.chimera.nfs.v3.xdr.entry3;
import org.dcache.chimera.nfs.v3.xdr.entryplus3;
import org.dcache.chimera.nfs.v3.xdr.fattr3;
import org.dcache.chimera.nfs.v3.xdr.fileid3;
import org.dcache.chimera.nfs.v3.xdr.filename3;
import org.dcache.chimera.nfs.v3.xdr.gid3;
import org.dcache.chimera.nfs.v3.xdr.nfs3_protServerStub;
import org.dcache.chimera.nfs.v3.xdr.nfs_fh3;
import org.dcache.chimera.nfs.v3.xdr.nfspath3;
import org.dcache.chimera.nfs.v3.xdr.nfstime3;
import org.dcache.chimera.nfs.v3.xdr.post_op_attr;
import org.dcache.chimera.nfs.v3.xdr.post_op_fh3;
import org.dcache.chimera.nfs.v3.xdr.pre_op_attr;
import org.dcache.chimera.nfs.v3.xdr.sattr3;
import org.dcache.chimera.nfs.v3.xdr.size3;
import org.dcache.chimera.nfs.v3.xdr.uid3;
import org.dcache.chimera.nfs.v3.xdr.uint32;
import org.dcache.chimera.nfs.v3.xdr.uint64;
import org.dcache.chimera.nfs.v3.xdr.wcc_attr;
import org.dcache.chimera.nfs.v3.xdr.wcc_data;
import org.dcache.chimera.nfs.v3.xdr.writeverf3;
import org.dcache.chimera.posix.Acl;
import org.dcache.chimera.posix.AclHandler;
import org.dcache.chimera.posix.Stat;
import org.dcache.chimera.posix.UnixAcl;
import org.dcache.chimera.posix.UnixPermissionHandler;
import org.dcache.chimera.posix.UnixUser;
import org.dcache.chimera.posix.User;
import org.dcache.utils.Bytes;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.RpcCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NfsServerV3
extends nfs3_protServerStub {
    private static final int ENTRY3_SIZE = 24;
    private static final int ENTRYPLUS3_SIZE = 124;
    private static final int READDIR3RESOK_SIZE = 104;
    private static final int READDIRPLUS3RESOK_SIZE = 104;
    private static final Logger _log = LoggerFactory.getLogger(NfsServerV3.class);
    private static final AclHandler _permissionHandler = UnixPermissionHandler.getInstance();
    private final FileSystemProvider _fs;
    private final ExportFile _exports;
    private static final ConcurrentMap<InodeCacheEntry<cookieverf3>, List<HimeraDirectoryEntry>> _dlCacheFull = new MapMaker().expireAfterAccess(10L, TimeUnit.MINUTES).softValues().maximumSize(512).makeMap();

    public NfsServerV3(ExportFile exports2, FileSystemProvider fs) throws OncRpcException, IOException {
        this._fs = fs;
        this._exports = exports2;
    }

    @Override
    public ACCESS3res NFSPROC3_ACCESS_3(RpcCall call$, ACCESS3args arg1) {
        ACCESS3res res = new ACCESS3res();
        UnixUser user = NfsUser.remoteUser(call$, this._exports);
        _log.debug("NFS Request ACCESS uid: {}", (Object)user);
        try {
            res.status = 0;
            res.resok = new ACCESS3resok();
            int reqAccess = arg1.access.value;
            res.resok.obj_attributes = new post_op_attr();
            res.resok.obj_attributes.attributes_follow = true;
            res.resok.obj_attributes.attributes = new fattr3();
            FsInode inode = this._fs.inodeFromBytes(arg1.object.data);
            if (!inode.exists()) {
                throw new ChimeraNFSException(70, "Path do not exist.");
            }
            Stat objStat = inode.statCache();
            HimeraNfsUtils.fill_attributes(objStat, res.resok.obj_attributes.attributes);
            UnixAcl acl = new UnixAcl(objStat.getUid(), objStat.getGid(), objStat.getMode() & 0x1FF);
            int realAccess = 0;
            if ((reqAccess & 0x20) == 32 && _permissionHandler.isAllowed((Acl)acl, (User)user, 8)) {
                realAccess |= 0x20;
            }
            if ((reqAccess & 8) == 8 && _permissionHandler.isAllowed((Acl)acl, (User)user, 6)) {
                realAccess |= 8;
            }
            if ((reqAccess & 2) == 2 && _permissionHandler.isAllowed((Acl)acl, (User)user, 4)) {
                realAccess |= 2;
            }
            if ((reqAccess & 0x10) == 16 && _permissionHandler.isAllowed((Acl)acl, (User)user, 3)) {
                realAccess |= 0x10;
            }
            if ((reqAccess & 4) == 4 && _permissionHandler.isAllowed((Acl)acl, (User)user, 2)) {
                realAccess |= 4;
            }
            if ((reqAccess & 1) == 1 && _permissionHandler.isAllowed((Acl)acl, (User)user, 0)) {
                realAccess |= 1;
            }
            res.resok.access = new uint32(realAccess);
        }
        catch (ChimeraNFSException hne) {
            _log.error("ACCESS: {}", (Object)hne.toString());
            res.status = hne.getStatus();
            res.resfail = new ACCESS3resfail();
            res.resfail.obj_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        catch (ChimeraFsException e) {
            res.status = 10006;
            res.resfail = new ACCESS3resfail();
            res.resfail.obj_attributes = HimeraNfsUtils.defaultPostOpAttr();
            _log.error("ACCESS", (Throwable)e);
        }
        catch (Exception e) {
            _log.error("ACCESS", (Throwable)e);
            res.status = 10006;
            res.resfail = new ACCESS3resfail();
            res.resfail.obj_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        return res;
    }

    @Override
    public COMMIT3res NFSPROC3_COMMIT_3(RpcCall call$, COMMIT3args arg1) {
        COMMIT3res res = new COMMIT3res();
        res.status = 10004;
        res.resfail = new COMMIT3resfail();
        res.resfail.file_wcc = HimeraNfsUtils.defaultWccData();
        return res;
    }

    @Override
    public CREATE3res NFSPROC3_CREATE_3(RpcCall call$, CREATE3args arg1) {
        UnixUser user = NfsUser.remoteUser(call$, this._exports);
        _log.debug("NFS Request CREATE3 uid: {}", (Object)user);
        CREATE3res res = new CREATE3res();
        String path = arg1.where.name.value;
        try {
            FsInode parent = this._fs.inodeFromBytes(arg1.where.dir.data);
            sattr3 newAttr = null;
            int mode = arg1.how.mode;
            if (mode == 0 || mode == 1) {
                newAttr = arg1.how.obj_attributes;
            }
            FsInode inode = null;
            Stat inodeStat = new Stat();
            Stat parentStat = null;
            boolean exists = true;
            long now = System.currentTimeMillis();
            try {
                inode = parent.inodeOf(path);
            }
            catch (FileNotFoundHimeraFsException hfe) {
                exists = false;
            }
            if (exists && mode != 0) {
                throw new ChimeraNFSException(17, "File alredy exist.");
            }
            parentStat = parent.statCache();
            UnixAcl acl = new UnixAcl(parentStat.getUid(), parentStat.getGid(), parentStat.getMode() & 0x1FF);
            if (!_permissionHandler.isAllowed((Acl)acl, (User)user, 6)) {
                throw new ChimeraNFSException(13, "Permission denied.");
            }
            try {
                int fmode = 33188;
                if (newAttr != null) {
                    fmode = newAttr.mode.mode.value.value | 0x8000;
                }
                inode = parent.create(path, user.getUID(), user.getGID(), fmode);
                inodeStat.setATime(now);
                inodeStat.setCTime(now);
                inodeStat.setMTime(now);
                inodeStat.setGid(user.getGID());
                inodeStat.setUid(user.getUID());
                inodeStat.setSize(0L);
                inodeStat.setNlink(1);
                inodeStat.setIno((int)inode.id());
                inodeStat.setMode(fmode);
            }
            catch (ChimeraFsException hfe) {
                throw new ChimeraNFSException(13, "Permission denied.");
            }
            res.status = 0;
            res.resok = new CREATE3resok();
            res.resok.obj_attributes = new post_op_attr();
            res.resok.obj_attributes.attributes_follow = true;
            res.resok.obj_attributes.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(inodeStat, res.resok.obj_attributes.attributes);
            res.resok.obj = new post_op_fh3();
            res.resok.obj.handle_follows = true;
            res.resok.obj.handle = new nfs_fh3();
            res.resok.obj.handle.data = this._fs.inodeToBytes(inode);
            res.resok.dir_wcc = new wcc_data();
            res.resok.dir_wcc.after = new post_op_attr();
            res.resok.dir_wcc.after.attributes_follow = true;
            res.resok.dir_wcc.after.attributes = new fattr3();
            parentStat.setNlink(parentStat.getNlink() + 1);
            parentStat.setMTime(now);
            HimeraNfsUtils.fill_attributes(parentStat, res.resok.dir_wcc.after.attributes);
            res.resok.dir_wcc.before = new pre_op_attr();
            res.resok.dir_wcc.before.attributes_follow = false;
        }
        catch (ChimeraNFSException hne) {
            _log.debug(hne.getMessage());
            res.resfail = new CREATE3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
            res.status = hne.getStatus();
        }
        catch (ChimeraFsException e) {
            _log.error("Create {}", (Object)path);
            res.status = 5;
            res.resfail = new CREATE3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
        }
        catch (Exception e) {
            _log.error("create", (Throwable)e);
            res.status = 10006;
            res.resfail = new CREATE3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
        }
        return res;
    }

    @Override
    public FSINFO3res NFSPROC3_FSINFO_3(RpcCall call$, FSINFO3args arg1) {
        UnixUser user = NfsUser.remoteUser(call$, this._exports);
        _log.debug("NFS Request FSINFO from: {}", (Object)user);
        FSINFO3res res = new FSINFO3res();
        try {
            FsInode inode = this._fs.inodeFromBytes(arg1.fsroot.data);
            res.status = 0;
            res.resok = new FSINFO3resok();
            res.resok.rtmax = new uint32(32768);
            res.resok.rtpref = new uint32(32768);
            res.resok.rtmult = new uint32(8);
            res.resok.wtmax = new uint32(32768);
            res.resok.wtpref = new uint32(32768);
            res.resok.wtmult = new uint32(8);
            res.resok.dtpref = new uint32(8192);
            res.resok.maxfilesize = new size3(new uint64(0x100000000L));
            nfstime3 time = new nfstime3();
            time.seconds = new uint32(1);
            time.nseconds = new uint32(0);
            res.resok.time_delta = time;
            res.resok.obj_attributes = new post_op_attr();
            res.resok.obj_attributes.attributes_follow = true;
            res.resok.obj_attributes.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(inode.stat(), res.resok.obj_attributes.attributes);
            res.resok.properties = new uint32(27);
        }
        catch (ChimeraFsException e) {
            res.resfail = new FSINFO3resfail();
            res.resfail.obj_attributes = HimeraNfsUtils.defaultPostOpAttr();
            res.status = 5;
            _log.error("FSINFO", (Throwable)e);
        }
        catch (Exception e) {
            _log.error("FSINFO", (Throwable)e);
            res.status = 10006;
            res.resfail = new FSINFO3resfail();
            res.resfail.obj_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        return res;
    }

    @Override
    public FSSTAT3res NFSPROC3_FSSTAT_3(RpcCall call$, FSSTAT3args arg1) {
        FSSTAT3res res = new FSSTAT3res();
        try {
            res.status = 0;
            res.resok = new FSSTAT3resok();
            FsStat fsStat = this._fs.getFsStat();
            res.resok.tbytes = new size3(new uint64(fsStat.getTotalSpace()));
            res.resok.fbytes = new size3(new uint64(fsStat.getTotalSpace() - fsStat.getUsedSpace()));
            res.resok.abytes = new size3(new uint64(fsStat.getTotalSpace() - fsStat.getUsedSpace()));
            res.resok.tfiles = new size3(new uint64(fsStat.getTotalFiles()));
            res.resok.ffiles = new size3(new uint64(fsStat.getTotalFiles() - fsStat.getUsedFiles()));
            res.resok.afiles = new size3(new uint64(fsStat.getTotalFiles() - fsStat.getUsedFiles()));
            res.resok.invarsec = new uint32(0);
            res.resok.obj_attributes = new post_op_attr();
            res.resok.obj_attributes.attributes_follow = true;
            res.resok.obj_attributes.attributes = new fattr3();
            FsInode inode = this._fs.inodeFromBytes(arg1.fsroot.data);
            HimeraNfsUtils.fill_attributes(inode.stat(), res.resok.obj_attributes.attributes);
        }
        catch (ChimeraFsException e) {
            _log.error("FSSTAT", (Throwable)e);
            res.status = 5;
            res.resfail = new FSSTAT3resfail();
            res.resfail.obj_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        catch (Exception e) {
            _log.error("FSSTAT", (Throwable)e);
            res.status = 10006;
            res.resfail = new FSSTAT3resfail();
            res.resfail.obj_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        return res;
    }

    @Override
    public GETATTR3res NFSPROC3_GETATTR_3(RpcCall call$, GETATTR3args arg1) {
        UnixUser user = NfsUser.remoteUser(call$, this._exports);
        _log.debug("NFS Request GETTATTR3 uid: {}", (Object)user);
        GETATTR3res res = new GETATTR3res();
        try {
            FsInode inode = this._fs.inodeFromBytes(arg1.object.data);
            _log.debug("NFS Request GETATTR for inode: {}", (Object)inode.toString());
            res.status = 0;
            res.resok = new GETATTR3resok();
            res.resok.obj_attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(inode.stat(), res.resok.obj_attributes);
        }
        catch (FileNotFoundHimeraFsException fnf) {
            _log.debug("GETATTR: file does not exists: {}", (Object)fnf.toString());
            res.status = 2;
        }
        catch (ChimeraFsException e) {
            _log.error("GETATTR", (Throwable)e);
            res.status = 5;
        }
        catch (Exception e) {
            _log.error("GETATTR", (Throwable)e);
            res.status = 10006;
        }
        return res;
    }

    @Override
    public LINK3res NFSPROC3_LINK_3(RpcCall call$, LINK3args arg1) {
        UnixUser user = NfsUser.remoteUser(call$, this._exports);
        _log.debug("NFS Request LINK3 uid: {}", (Object)user);
        LINK3res res = new LINK3res();
        try {
            FsInode parent = this._fs.inodeFromBytes(arg1.link.dir.data);
            String name2 = arg1.link.name.value;
            FsInode hlink = this._fs.inodeFromBytes(arg1.file.data);
            FsInode inode = null;
            boolean exists = true;
            try {
                inode = this._fs.inodeOf(parent, name2);
            }
            catch (FileNotFoundHimeraFsException hfe) {
                exists = false;
            }
            if (exists) {
                throw new ChimeraNFSException(17, "File " + name2 + " already exist.");
            }
            Stat parentStat = parent.statCache();
            UnixAcl acl = new UnixAcl(parentStat.getUid(), parentStat.getGid(), parentStat.getMode() & 0x1FF);
            if (!_permissionHandler.isAllowed((Acl)acl, (User)user, 6)) {
                throw new ChimeraNFSException(13, "Permission denied.");
            }
            this._fs.createHLink(parent, hlink, name2);
            res.resok = new LINK3resok();
            res.resok.file_attributes = new post_op_attr();
            res.resok.file_attributes.attributes_follow = true;
            res.resok.file_attributes.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(hlink.stat(), res.resok.file_attributes.attributes);
            res.resok.linkdir_wcc = new wcc_data();
            res.resok.linkdir_wcc.after = new post_op_attr();
            res.resok.linkdir_wcc.after.attributes_follow = true;
            res.resok.linkdir_wcc.after.attributes = new fattr3();
            parentStat.setNlink(parentStat.getNlink() + 1);
            parentStat.setMTime(System.currentTimeMillis());
            HimeraNfsUtils.fill_attributes(parentStat, res.resok.linkdir_wcc.after.attributes);
            res.resok.linkdir_wcc.before = new pre_op_attr();
            res.resok.linkdir_wcc.before.attributes_follow = false;
            res.status = 0;
        }
        catch (ChimeraNFSException hne) {
            res.status = hne.getStatus();
            res.resfail = new LINK3resfail();
            res.resfail.file_attributes = HimeraNfsUtils.defaultPostOpAttr();
            res.resfail.linkdir_wcc = HimeraNfsUtils.defaultWccData();
        }
        catch (ChimeraFsException e) {
            _log.error("LINK", (Throwable)e);
            res.status = 10006;
            res.resfail.file_attributes = HimeraNfsUtils.defaultPostOpAttr();
            res.resfail.linkdir_wcc = HimeraNfsUtils.defaultWccData();
        }
        catch (Exception e) {
            _log.error("LINK", (Throwable)e);
            res.status = 10006;
            res.resfail.file_attributes = HimeraNfsUtils.defaultPostOpAttr();
            res.resfail.linkdir_wcc = HimeraNfsUtils.defaultWccData();
        }
        return res;
    }

    @Override
    public LOOKUP3res NFSPROC3_LOOKUP_3(RpcCall call$, LOOKUP3args arg1) {
        LOOKUP3res res = new LOOKUP3res();
        try {
            FsInode parent = this._fs.inodeFromBytes(arg1.what.dir.data);
            String name2 = arg1.what.name.value;
            FsInode inode = null;
            try {
                inode = this._fs.inodeOf(parent, name2);
            }
            catch (ChimeraFsException hfse) {
                throw new ChimeraNFSException(2, "Path do not exist.");
            }
            res.status = 0;
            res.resok = new LOOKUP3resok();
            nfs_fh3 fh3 = new nfs_fh3();
            fh3.data = this._fs.inodeToBytes(inode);
            res.resok.object = fh3;
            res.resok.obj_attributes = new post_op_attr();
            res.resok.obj_attributes.attributes_follow = true;
            res.resok.obj_attributes.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(inode.stat(), res.resok.obj_attributes.attributes);
            res.resok.dir_attributes = new post_op_attr();
            res.resok.dir_attributes.attributes_follow = true;
            res.resok.dir_attributes.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(parent.stat(), res.resok.dir_attributes.attributes);
        }
        catch (ChimeraNFSException hne) {
            _log.debug("lookup {}", (Object)hne.toString());
            res.status = hne.getStatus();
            res.resfail = new LOOKUP3resfail();
            res.resfail.dir_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        catch (ChimeraFsException e) {
            _log.error("LOOKUP", (Throwable)e);
            res.status = 5;
            res.resfail = new LOOKUP3resfail();
            res.resfail.dir_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        catch (Exception e) {
            _log.error("LOOKUP", (Throwable)e);
            res.status = 10006;
            res.resfail = new LOOKUP3resfail();
            res.resfail.dir_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        return res;
    }

    @Override
    public MKDIR3res NFSPROC3_MKDIR_3(RpcCall call$, MKDIR3args arg1) {
        UnixUser user = NfsUser.remoteUser(call$, this._exports);
        _log.debug("NFS Request MKDIR3 uid: {}", (Object)user);
        MKDIR3res res = new MKDIR3res();
        try {
            FsInode parent = this._fs.inodeFromBytes(arg1.where.dir.data);
            String name2 = arg1.where.name.value;
            sattr3 attr = arg1.attributes;
            Stat parentStat = parent.statCache();
            UnixAcl acl = new UnixAcl(parentStat.getUid(), parentStat.getGid(), parentStat.getMode() & 0x1FF);
            if (!_permissionHandler.isAllowed((Acl)acl, (User)user, 6)) {
                throw new ChimeraNFSException(13, "Permission denied.");
            }
            FsInode inode = null;
            try {
                inode = this._fs.mkdir(parent, name2);
            }
            catch (ChimeraFsException hfe) {
                throw new ChimeraNFSException(17, "Directory already exist.");
            }
            if (attr != null) {
                attr.gid.set_it = true;
                attr.gid.gid = new gid3(new uint32(user.getGID()));
                attr.uid.set_it = true;
                attr.uid.uid = new uid3(new uint32(user.getUID()));
                attr.mode.mode.value.value |= 0x4000;
                HimeraNfsUtils.set_sattr(inode, attr);
            }
            res.resok = new MKDIR3resok();
            res.resok.obj = new post_op_fh3();
            res.resok.obj.handle_follows = true;
            res.resok.obj.handle = new nfs_fh3();
            res.resok.obj.handle.data = this._fs.inodeToBytes(inode);
            res.resok.obj_attributes = new post_op_attr();
            res.resok.obj_attributes.attributes_follow = true;
            res.resok.obj_attributes.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(inode.stat(), res.resok.obj_attributes.attributes);
            res.resok.dir_wcc = new wcc_data();
            res.resok.dir_wcc.after = new post_op_attr();
            res.resok.dir_wcc.after.attributes_follow = true;
            res.resok.dir_wcc.after.attributes = new fattr3();
            parentStat.setNlink(parentStat.getNlink() + 1);
            parentStat.setMTime(System.currentTimeMillis());
            HimeraNfsUtils.fill_attributes(parentStat, res.resok.dir_wcc.after.attributes);
            res.resok.dir_wcc.before = new pre_op_attr();
            res.resok.dir_wcc.before.attributes_follow = false;
            res.status = 0;
        }
        catch (ChimeraNFSException hne) {
            res.resfail = new MKDIR3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
            res.status = hne.getStatus();
        }
        catch (ChimeraFsException e) {
            _log.error("MKDIR", (Throwable)e);
            res.status = 10006;
            res.resfail = new MKDIR3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
        }
        catch (Exception e) {
            _log.error("MKDIR", (Throwable)e);
            res.status = 10006;
            res.resfail = new MKDIR3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
        }
        return res;
    }

    @Override
    public MKNOD3res NFSPROC3_MKNOD_3(RpcCall call$, MKNOD3args arg1) {
        MKNOD3res res = new MKNOD3res();
        res.status = 10004;
        res.resfail = new MKNOD3resfail();
        res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
        return res;
    }

    @Override
    public void NFSPROC3_NULL_3(RpcCall call$) {
    }

    @Override
    public PATHCONF3res NFSPROC3_PATHCONF_3(RpcCall call$, PATHCONF3args arg1) {
        PATHCONF3res res = new PATHCONF3res();
        res.resok = new PATHCONF3resok();
        res.resok.case_insensitive = false;
        res.resok.case_preserving = true;
        res.resok.chown_restricted = false;
        res.resok.no_trunc = true;
        res.resok.linkmax = new uint32(512);
        res.resok.name_max = new uint32(256);
        res.resok.obj_attributes = new post_op_attr();
        res.resok.obj_attributes.attributes_follow = false;
        res.status = 0;
        return res;
    }

    private cookieverf3 generateDirectoryVerifier(FsInode dir) throws IllegalArgumentException, ChimeraFsException {
        byte[] verifier = new byte[8];
        Bytes.putLong((byte[])verifier, (int)0, (long)dir.statCache().getMTime());
        return new cookieverf3(verifier);
    }

    private void checkVerifier(FsInode dir, cookieverf3 verifier) throws ChimeraNFSException, ChimeraFsException {
        long mtime = Bytes.getLong((byte[])verifier.value, (int)0);
        if (mtime > dir.statCache().getMTime()) {
            throw new ChimeraNFSException(10003, "bad cookie");
        }
    }

    @Override
    public READDIRPLUS3res NFSPROC3_READDIRPLUS_3(RpcCall call$, READDIRPLUS3args arg1) {
        UnixUser user = NfsUser.remoteUser(call$, this._exports);
        _log.debug("NFS Request READDIRPLUS3 uid: {}", (Object)user);
        READDIRPLUS3res res = new READDIRPLUS3res();
        try {
            cookieverf3 cookieverf;
            FsInode dir = this._fs.inodeFromBytes(arg1.dir.data);
            Stat dirStat = dir.statCache();
            UnixAcl acl = new UnixAcl(dirStat.getUid(), dirStat.getGid(), dirStat.getMode() & 0x1FF);
            if (!_permissionHandler.isAllowed((Acl)acl, (User)user, 4)) {
                throw new ChimeraNFSException(13, "Permission denied.");
            }
            if (!dir.exists()) {
                throw new ChimeraNFSException(2, "Path Do not exist.");
            }
            if (!dir.isDirectory()) {
                throw new ChimeraNFSException(20, "Path is not a directory.");
            }
            long startValue = arg1.cookie.value.value;
            List dirList = null;
            if (startValue != 0L) {
                ++startValue;
                cookieverf = arg1.cookieverf;
                this.checkVerifier(dir, cookieverf);
            } else {
                cookieverf = this.generateDirectoryVerifier(dir);
            }
            InodeCacheEntry<cookieverf3> cacheKey = new InodeCacheEntry<cookieverf3>(dir, cookieverf);
            dirList = (List)_dlCacheFull.get(cacheKey);
            if (dirList == null) {
                _log.debug("updating dirlist from db");
                dirList = DirectoryStreamHelper.listOf((FsInode)dir);
                _dlCacheFull.put(cacheKey, dirList);
            } else {
                _log.debug("using dirlist from cache");
            }
            if (startValue > (long)dirList.size()) {
                res.status = 10003;
                res.resfail = new READDIRPLUS3resfail();
                res.resfail.dir_attributes = new post_op_attr();
                res.resfail.dir_attributes.attributes_follow = false;
                return res;
            }
            res.status = 0;
            res.resok = new READDIRPLUS3resok();
            res.resok.reply = new dirlistplus3();
            res.resok.dir_attributes = new post_op_attr();
            res.resok.dir_attributes.attributes_follow = true;
            res.resok.dir_attributes.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(dir.statCache(), res.resok.dir_attributes.attributes);
            res.resok.cookieverf = cookieverf;
            int currcount = 104;
            int dircount = 0;
            entryplus3 currentEntry = res.resok.reply.entries = new entryplus3();
            entryplus3 lastEntry = null;
            for (long i = startValue; i < (long)dirList.size(); ++i) {
                HimeraDirectoryEntry le = (HimeraDirectoryEntry)dirList.get((int)i);
                String name2 = le.getName();
                FsInode ef = le.getInode();
                currentEntry.fileid = new fileid3(new uint64(ef.id()));
                currentEntry.name = new filename3(name2);
                currentEntry.cookie = new cookie3(new uint64(i));
                currentEntry.name_handle = new post_op_fh3();
                currentEntry.name_handle.handle_follows = true;
                currentEntry.name_handle.handle = new nfs_fh3();
                currentEntry.name_handle.handle.data = this._fs.inodeToBytes(ef);
                currentEntry.name_attributes = new post_op_attr();
                currentEntry.name_attributes.attributes_follow = true;
                currentEntry.name_attributes.attributes = new fattr3();
                HimeraNfsUtils.fill_attributes(le.getStat(), currentEntry.name_attributes.attributes);
                currentEntry.nextentry = null;
                int newSize = 124 + name2.length() + currentEntry.name_handle.handle.data.length;
                int newDirSize = name2.length();
                if (currcount + newSize > arg1.maxcount.value.value || dircount + newDirSize > arg1.dircount.value.value) {
                    res.resok.reply.eof = false;
                    lastEntry.nextentry = null;
                    _log.debug("Sending {} entries ( {} bytes from {}, dircount = {} from {} ) cookie = {} total {}", new Object[]{i - startValue, currcount, arg1.maxcount.value.value, dircount, arg1.dircount.value.value, startValue, dirList.size()});
                    return res;
                }
                dircount += newDirSize;
                currcount += newSize;
                if (i + 1L >= (long)dirList.size()) continue;
                lastEntry = currentEntry;
                currentEntry = currentEntry.nextentry = new entryplus3();
            }
            res.resok.reply.eof = true;
        }
        catch (ChimeraNFSException hne) {
            _log.debug("READDIRPLUS3 status: {}", (Object)hne.toString());
            res.resfail = new READDIRPLUS3resfail();
            res.resfail.dir_attributes = HimeraNfsUtils.defaultPostOpAttr();
            res.status = hne.getStatus();
        }
        catch (ChimeraFsException e) {
            _log.error("READDIRPLUS3", (Throwable)e);
            res.status = 10006;
            res.resfail = new READDIRPLUS3resfail();
            res.resfail.dir_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        catch (Exception e) {
            _log.error("READDIRPLUS3", (Throwable)e);
            res.status = 10006;
            res.resfail = new READDIRPLUS3resfail();
            res.resfail.dir_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        return res;
    }

    @Override
    public READDIR3res NFSPROC3_READDIR_3(RpcCall call$, READDIR3args arg1) {
        UnixUser user = NfsUser.remoteUser(call$, this._exports);
        _log.debug("NFS Request READDIR3 uid: {}", (Object)user);
        READDIR3res res = new READDIR3res();
        try {
            cookieverf3 cookieverf;
            FsInode dir = this._fs.inodeFromBytes(arg1.dir.data);
            Stat dirStat = dir.statCache();
            UnixAcl acl = new UnixAcl(dirStat.getUid(), dirStat.getGid(), dirStat.getMode() & 0x1FF);
            if (!_permissionHandler.isAllowed((Acl)acl, (User)user, 4)) {
                throw new ChimeraNFSException(13, "Permission denied.");
            }
            if (!dir.exists()) {
                throw new ChimeraNFSException(2, "Path Do not exist.");
            }
            if (!dir.isDirectory()) {
                throw new ChimeraNFSException(20, "Path is not a directory.");
            }
            long startValue = arg1.cookie.value.value;
            List dirList = null;
            if (startValue != 0L) {
                ++startValue;
                cookieverf = arg1.cookieverf;
                this.checkVerifier(dir, cookieverf);
            } else {
                cookieverf = this.generateDirectoryVerifier(dir);
            }
            InodeCacheEntry<cookieverf3> cacheKey = new InodeCacheEntry<cookieverf3>(dir, cookieverf);
            dirList = (List)_dlCacheFull.get(cacheKey);
            if (dirList == null) {
                _log.debug("updating dirlist from db");
                dirList = DirectoryStreamHelper.listOf((FsInode)dir);
                _dlCacheFull.put(cacheKey, dirList);
            } else {
                _log.debug("using dirlist from cache");
            }
            if (startValue > (long)dirList.size()) {
                res.status = 10003;
                res.resfail = new READDIR3resfail();
                res.resfail.dir_attributes = new post_op_attr();
                res.resfail.dir_attributes.attributes_follow = false;
                return res;
            }
            res.status = 0;
            res.resok = new READDIR3resok();
            res.resok.reply = new dirlist3();
            res.resok.dir_attributes = new post_op_attr();
            res.resok.dir_attributes.attributes_follow = true;
            res.resok.dir_attributes.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(dir.stat(), res.resok.dir_attributes.attributes);
            res.resok.cookieverf = cookieverf;
            int currcount = 104;
            entry3 currentEntry = res.resok.reply.entries = new entry3();
            entry3 lastEntry = null;
            for (long i = startValue; i < (long)dirList.size(); ++i) {
                HimeraDirectoryEntry le = (HimeraDirectoryEntry)dirList.get((int)i);
                String name2 = le.getName();
                FsInode ef = le.getInode();
                currentEntry.fileid = new fileid3(new uint64(ef.id()));
                currentEntry.name = new filename3(name2);
                currentEntry.cookie = new cookie3(new uint64(i));
                currentEntry.nextentry = null;
                int newSize = 24 + name2.length();
                if (currcount + newSize > arg1.count.value.value) {
                    lastEntry.nextentry = null;
                    res.resok.reply.eof = false;
                    _log.debug("Sending {} entries ( {} bytes from {}) cookie = {} total {}", new Object[]{i - startValue, currcount, arg1.count.value.value, startValue, dirList.size()});
                    return res;
                }
                currcount += newSize;
                if (i + 1L >= (long)dirList.size()) continue;
                lastEntry = currentEntry;
                currentEntry = currentEntry.nextentry = new entry3();
            }
            res.resok.reply.eof = true;
        }
        catch (ChimeraNFSException hne) {
            _log.error("READDIR: {}", (Object)hne.toString());
            res.resfail = new READDIR3resfail();
            res.resfail.dir_attributes = HimeraNfsUtils.defaultPostOpAttr();
            res.status = hne.getStatus();
        }
        catch (ChimeraFsException e) {
            _log.error("READDIR", (Throwable)e);
            res.status = 10006;
            res.resfail = new READDIR3resfail();
            res.resfail.dir_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        catch (Exception e) {
            _log.error("READDIR", (Throwable)e);
            res.status = 10006;
            res.resfail = new READDIR3resfail();
            res.resfail.dir_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        return res;
    }

    @Override
    public READLINK3res NFSPROC3_READLINK_3(RpcCall call$, READLINK3args arg1) {
        READLINK3res res = new READLINK3res();
        try {
            FsInode inode = this._fs.inodeFromBytes(arg1.symlink.data);
            res.resok = new READLINK3resok();
            res.resok.data = new nfspath3(new String(inode.readlink()));
            res.resok.symlink_attributes = new post_op_attr();
            res.resok.symlink_attributes.attributes_follow = true;
            res.resok.symlink_attributes.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(this._fs.stat(inode), res.resok.symlink_attributes.attributes);
            res.status = 0;
        }
        catch (ChimeraFsException e) {
            _log.error("READLINK", (Throwable)e);
            res.status = 10006;
            res.resfail = new READLINK3resfail();
            res.resfail.symlink_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        catch (Exception e) {
            _log.error("READLINK", (Throwable)e);
            res.status = 10006;
            res.resfail = new READLINK3resfail();
            res.resfail.symlink_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        return res;
    }

    @Override
    public READ3res NFSPROC3_READ_3(RpcCall call$, READ3args arg1) {
        READ3res res = new READ3res();
        try {
            FsInode inode = this._fs.inodeFromBytes(arg1.file.data);
            long offset = arg1.offset.value.value;
            int count = arg1.count.value.value;
            UnixUser user = NfsUser.remoteUser(call$, this._exports);
            Stat inodeStat = inode.statCache();
            UnixAcl fileAcl = new UnixAcl(inodeStat.getUid(), inodeStat.getGid(), inodeStat.getMode() & 0x1FF);
            if (!_permissionHandler.isAllowed((Acl)fileAcl, (User)user, 0)) {
                throw new ChimeraNFSException(13, "Permission denied.");
            }
            res.resok = new READ3resok();
            res.resok.data = new byte[count];
            res.resok.count = new count3();
            res.resok.count.value = new uint32();
            byte[] b = new byte[count];
            res.resok.count.value.value = inode.read(offset, b, 0, count);
            if (res.resok.count.value.value < 0) {
                throw new IOHimeraFsException("IO not allowed");
            }
            res.resok.data = new byte[res.resok.count.value.value];
            System.arraycopy(b, 0, res.resok.data, 0, res.resok.count.value.value);
            if ((long)res.resok.count.value.value + offset == inodeStat.getSize()) {
                res.resok.eof = true;
            }
            res.resok.file_attributes = new post_op_attr();
            res.resok.file_attributes.attributes_follow = true;
            res.resok.file_attributes.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(inode.stat(), res.resok.file_attributes.attributes);
        }
        catch (ChimeraNFSException hne) {
            res.status = hne.getStatus();
            res.resfail = new READ3resfail();
            res.resfail.file_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        catch (IOHimeraFsException hfe) {
            res.status = 5;
            res.resfail = new READ3resfail();
            res.resfail.file_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        catch (ChimeraFsException e) {
            res.status = 5;
            res.resfail = new READ3resfail();
            res.resfail.file_attributes = HimeraNfsUtils.defaultPostOpAttr();
            _log.error("READ", (Throwable)e);
        }
        catch (Exception e) {
            _log.error("READ", (Throwable)e);
            res.status = 10006;
            res.resfail = new READ3resfail();
            res.resfail.file_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        return res;
    }

    @Override
    public REMOVE3res NFSPROC3_REMOVE_3(RpcCall call$, REMOVE3args arg1) {
        UnixUser user = NfsUser.remoteUser(call$, this._exports);
        _log.debug("NFS Request REMOVE3 uid: {}", (Object)user);
        REMOVE3res res = new REMOVE3res();
        try {
            FsInode parent = this._fs.inodeFromBytes(arg1.object.dir.data);
            String name2 = arg1.object.name.value;
            Stat inodeStat = null;
            Stat parentStat = null;
            try {
                FsInode inode = this._fs.inodeOf(parent, name2);
                inodeStat = inode.statCache();
                parentStat = parent.statCache();
            }
            catch (ChimeraFsException hfe) {
                throw new ChimeraNFSException(2, "Path do not exist.");
            }
            UnixAcl parentAcl = new UnixAcl(parentStat.getUid(), parentStat.getGid(), parentStat.getMode() & 0x1FF);
            UnixAcl fileAcl = new UnixAcl(inodeStat.getUid(), inodeStat.getGid(), inodeStat.getMode() & 0x1FF);
            if (!_permissionHandler.isAllowed((Acl)fileAcl, (User)user, 3) && !_permissionHandler.isAllowed((Acl)parentAcl, (User)user, 3)) {
                throw new ChimeraNFSException(13, "Permission denied.");
            }
            parent.remove(name2);
            res.resok = new REMOVE3resok();
            res.status = 0;
            res.resok.dir_wcc = new wcc_data();
            res.resok.dir_wcc.before = new pre_op_attr();
            res.resok.dir_wcc.before.attributes_follow = true;
            res.resok.dir_wcc.before.attributes = new wcc_attr();
            HimeraNfsUtils.fill_attributes(parentStat, res.resok.dir_wcc.before.attributes);
            parentStat.setMTime(System.currentTimeMillis());
            parentStat.setNlink(parentStat.getNlink() - 1);
            res.resok.dir_wcc.after = new post_op_attr();
            res.resok.dir_wcc.after.attributes_follow = true;
            res.resok.dir_wcc.after.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(parentStat, res.resok.dir_wcc.after.attributes);
        }
        catch (ChimeraNFSException hne) {
            res.resfail = new REMOVE3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
            res.status = hne.getStatus();
        }
        catch (ChimeraFsException e) {
            res.status = 10006;
            res.resfail = new REMOVE3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
        }
        catch (Exception e) {
            _log.error("REMOVE", (Throwable)e);
            res.status = 10006;
            res.resfail = new REMOVE3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
        }
        return res;
    }

    @Override
    public RENAME3res NFSPROC3_RENAME_3(RpcCall call$, RENAME3args arg1) {
        UnixUser user = NfsUser.remoteUser(call$, this._exports);
        _log.debug("NFS Request RENAME3 uid: {}", (Object)user);
        RENAME3res res = new RENAME3res();
        try {
            FsInode from = this._fs.inodeFromBytes(arg1.from.dir.data);
            String file1 = arg1.from.name.value;
            FsInode to = this._fs.inodeFromBytes(arg1.to.dir.data);
            String file2 = arg1.to.name.value;
            Stat fromStat = from.stat();
            Stat toStat = to.stat();
            UnixAcl fromAcl = new UnixAcl(fromStat.getUid(), fromStat.getGid(), fromStat.getMode() & 0x1FF);
            UnixAcl toAcl = new UnixAcl(toStat.getUid(), toStat.getGid(), toStat.getMode() & 0x1FF);
            if (!_permissionHandler.isAllowed((Acl)fromAcl, (User)user, 3) || !_permissionHandler.isAllowed((Acl)toAcl, (User)user, 6)) {
                throw new ChimeraNFSException(13, "Permission denied.");
            }
            this._fs.move(from, file1, to, file2);
            res.resok = new RENAME3resok();
            res.resok.fromdir_wcc = new wcc_data();
            res.resok.fromdir_wcc.after = new post_op_attr();
            res.resok.fromdir_wcc.after.attributes_follow = true;
            res.resok.fromdir_wcc.after.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(from.stat(), res.resok.fromdir_wcc.after.attributes);
            res.resok.fromdir_wcc.before = new pre_op_attr();
            res.resok.fromdir_wcc.before.attributes_follow = false;
            res.resok.todir_wcc = new wcc_data();
            res.resok.todir_wcc.after = new post_op_attr();
            res.resok.todir_wcc.after.attributes_follow = true;
            res.resok.todir_wcc.after.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(to.stat(), res.resok.todir_wcc.after.attributes);
            res.resok.todir_wcc.before = new pre_op_attr();
            res.resok.todir_wcc.before.attributes_follow = false;
            res.status = 0;
        }
        catch (ChimeraNFSException hne) {
            res.status = hne.getStatus();
            res.resfail = new RENAME3resfail();
            res.resfail.fromdir_wcc = HimeraNfsUtils.defaultWccData();
            res.resfail.todir_wcc = HimeraNfsUtils.defaultWccData();
        }
        catch (ChimeraFsException e) {
            res.status = 10006;
            res.resfail = new RENAME3resfail();
            res.resfail.fromdir_wcc = HimeraNfsUtils.defaultWccData();
            res.resfail.todir_wcc = HimeraNfsUtils.defaultWccData();
        }
        catch (Exception e) {
            _log.error("RENAME", (Throwable)e);
            res.status = 10006;
            res.resfail = new RENAME3resfail();
            res.resfail.fromdir_wcc = HimeraNfsUtils.defaultWccData();
            res.resfail.todir_wcc = HimeraNfsUtils.defaultWccData();
        }
        return res;
    }

    @Override
    public RMDIR3res NFSPROC3_RMDIR_3(RpcCall call$, RMDIR3args arg1) {
        UnixUser user = NfsUser.remoteUser(call$, this._exports);
        _log.debug("NFS Request RMDIR3 uid: {}", (Object)user);
        RMDIR3res res = new RMDIR3res();
        try {
            FsInode parent = this._fs.inodeFromBytes(arg1.object.dir.data);
            String file = arg1.object.name.value;
            FsInode inode = this._fs.inodeOf(parent, file);
            Stat inodeStat = inode.statCache();
            Stat parentStat = parent.statCache();
            UnixAcl parentAcl = new UnixAcl(parentStat.getUid(), parentStat.getGid(), parentStat.getMode() & 0x1FF);
            UnixAcl fileAcl = new UnixAcl(inodeStat.getUid(), inodeStat.getGid(), inodeStat.getMode() & 0x1FF);
            if (!_permissionHandler.isAllowed((Acl)fileAcl, (User)user, 3) && !_permissionHandler.isAllowed((Acl)parentAcl, (User)user, 3)) {
                throw new ChimeraNFSException(13, "Permission denied.");
            }
            if (!parent.remove(file)) {
                throw new ChimeraNFSException(66, "Directory is not empty.");
            }
            res.resok = new RMDIR3resok();
            res.status = 0;
            res.resok.dir_wcc = new wcc_data();
            res.resok.dir_wcc.after = new post_op_attr();
            res.resok.dir_wcc.before = new pre_op_attr();
            res.resok.dir_wcc.before.attributes_follow = true;
            res.resok.dir_wcc.before.attributes = new wcc_attr();
            HimeraNfsUtils.fill_attributes(parentStat, res.resok.dir_wcc.before.attributes);
            res.resok.dir_wcc.after.attributes_follow = true;
            res.resok.dir_wcc.after.attributes = new fattr3();
            parentStat.setMTime(System.currentTimeMillis());
            parentStat.setNlink(parentStat.getNlink() - 1);
            HimeraNfsUtils.fill_attributes(parentStat, res.resok.dir_wcc.after.attributes);
        }
        catch (ChimeraNFSException hne) {
            res.resfail = new RMDIR3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
            res.status = hne.getStatus();
        }
        catch (ChimeraFsException e) {
            res.status = 10006;
            res.resfail = new RMDIR3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
        }
        catch (Exception e) {
            _log.error("RMDIR", (Throwable)e);
            res.status = 10006;
            res.resfail = new RMDIR3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
        }
        return res;
    }

    @Override
    public SETATTR3res NFSPROC3_SETATTR_3(RpcCall call$, SETATTR3args arg1) {
        UnixUser user = NfsUser.remoteUser(call$, this._exports);
        _log.debug("NFS Request SETATTR3 uid: {}", (Object)user);
        SETATTR3res res = new SETATTR3res();
        try {
            FsInode inode = this._fs.inodeFromBytes(arg1.object.data);
            sattr3 newAttr = arg1.new_attributes;
            Stat stat = null;
            try {
                stat = inode.statCache();
            }
            catch (ChimeraFsException hfe) {
                throw new ChimeraNFSException(2, "Path do not exist.");
            }
            UnixAcl acl = new UnixAcl(stat.getUid(), stat.getGid(), stat.getMode() & 0x1FF);
            if (!_permissionHandler.isAllowed((Acl)acl, (User)user, 5)) {
                throw new ChimeraNFSException(13, "Permission denied.");
            }
            HimeraNfsUtils.set_sattr(inode, newAttr);
            res.resok = new SETATTR3resok();
            res.resok.obj_wcc = new wcc_data();
            res.resok.obj_wcc.after = new post_op_attr();
            res.resok.obj_wcc.after.attributes_follow = true;
            res.resok.obj_wcc.after.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(inode.statCache(), res.resok.obj_wcc.after.attributes);
            res.resok.obj_wcc.before = new pre_op_attr();
            res.resok.obj_wcc.before.attributes_follow = false;
            res.status = 0;
        }
        catch (ChimeraNFSException hne) {
            res.status = hne.getStatus();
            res.resfail = new SETATTR3resfail();
            res.resfail.obj_wcc = HimeraNfsUtils.defaultWccData();
        }
        catch (ChimeraFsException e) {
            res.status = 10006;
            res.resfail = new SETATTR3resfail();
            res.resfail.obj_wcc = HimeraNfsUtils.defaultWccData();
        }
        catch (Exception e) {
            _log.error("SETATTR", (Throwable)e);
            res.status = 10006;
            res.resfail = new SETATTR3resfail();
            res.resfail.obj_wcc = HimeraNfsUtils.defaultWccData();
        }
        return res;
    }

    @Override
    public SYMLINK3res NFSPROC3_SYMLINK_3(RpcCall call$, SYMLINK3args arg1) {
        UnixUser user = NfsUser.remoteUser(call$, this._exports);
        _log.debug("NFS Request SYMLINK3 uid: {}", (Object)user);
        SYMLINK3res res = new SYMLINK3res();
        try {
            FsInode parent = this._fs.inodeFromBytes(arg1.where.dir.data);
            String file = arg1.where.name.value;
            String link = arg1.symlink.symlink_data.value;
            sattr3 linkAttr = arg1.symlink.symlink_attributes;
            FsInode inode = null;
            boolean exists = true;
            try {
                inode = this._fs.inodeOf(parent, file);
            }
            catch (FileNotFoundHimeraFsException hfe) {
                exists = false;
            }
            if (exists) {
                throw new ChimeraNFSException(17, "File " + file + " already exist.");
            }
            Stat parentStat = parent.statCache();
            UnixAcl acl = new UnixAcl(parentStat.getUid(), parentStat.getGid(), parentStat.getMode() & 0x1FF);
            if (!_permissionHandler.isAllowed((Acl)acl, (User)user, 6)) {
                throw new ChimeraNFSException(13, "Permission denied.");
            }
            inode = this._fs.createLink(parent, file, link);
            HimeraNfsUtils.set_sattr(inode, linkAttr);
            res.resok = new SYMLINK3resok();
            res.resok.obj_attributes = new post_op_attr();
            res.resok.obj_attributes.attributes_follow = true;
            res.resok.obj_attributes.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(inode.statCache(), res.resok.obj_attributes.attributes);
            res.resok.obj = new post_op_fh3();
            res.resok.obj.handle_follows = true;
            res.resok.obj.handle = new nfs_fh3();
            res.resok.obj.handle.data = this._fs.inodeToBytes(inode);
            res.resok.dir_wcc = new wcc_data();
            res.resok.dir_wcc.after = new post_op_attr();
            res.resok.dir_wcc.after.attributes_follow = true;
            res.resok.dir_wcc.after.attributes = new fattr3();
            parentStat.setNlink(parentStat.getNlink() + 1);
            parentStat.setMTime(System.currentTimeMillis());
            HimeraNfsUtils.fill_attributes(parentStat, res.resok.dir_wcc.after.attributes);
            res.resok.dir_wcc.before = new pre_op_attr();
            res.resok.dir_wcc.before.attributes_follow = false;
            res.status = 0;
        }
        catch (ChimeraNFSException hne) {
            res.status = hne.getStatus();
            res.resfail = new SYMLINK3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
        }
        catch (ChimeraFsException e) {
            res.status = 10006;
            res.resfail = new SYMLINK3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
        }
        catch (Exception e) {
            _log.error("SYMLINK", (Throwable)e);
            res.status = 10006;
            res.resfail = new SYMLINK3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
        }
        return res;
    }

    @Override
    public WRITE3res NFSPROC3_WRITE_3(RpcCall call$, WRITE3args arg1) {
        WRITE3res res = new WRITE3res();
        try {
            FsInode inode = this._fs.inodeFromBytes(arg1.file.data);
            long offset = arg1.offset.value.value;
            int count = arg1.count.value.value;
            Stat inodeStat = inode.statCache();
            UnixUser user = NfsUser.remoteUser(call$, this._exports);
            UnixAcl fileAcl = new UnixAcl(inodeStat.getUid(), inodeStat.getGid(), inodeStat.getMode() & 0x1FF);
            if (!_permissionHandler.isAllowed((Acl)fileAcl, (User)user, 2)) {
                throw new ChimeraNFSException(13, "Permission denied.");
            }
            res.resok = new WRITE3resok();
            res.status = 0;
            int ret = inode.write(offset, arg1.data, 0, count);
            if (ret < 0) {
                throw new IOHimeraFsException("IO not allowed");
            }
            res.resok.count = new count3(new uint32(ret));
            res.resok.file_wcc = new wcc_data();
            res.resok.file_wcc.after = new post_op_attr();
            res.resok.file_wcc.after.attributes_follow = true;
            res.resok.file_wcc.after.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(inode.statCache(), res.resok.file_wcc.after.attributes);
            res.resok.file_wcc.before = new pre_op_attr();
            res.resok.file_wcc.before.attributes_follow = false;
            res.resok.committed = 2;
            res.resok.verf = new writeverf3();
            res.resok.verf.value = new byte[8];
        }
        catch (ChimeraNFSException hne) {
            res.status = hne.getStatus();
            res.resfail = new WRITE3resfail();
            res.resfail.file_wcc = HimeraNfsUtils.defaultWccData();
        }
        catch (IOHimeraFsException hfe) {
            res.status = 5;
            res.resfail = new WRITE3resfail();
            res.resfail.file_wcc = HimeraNfsUtils.defaultWccData();
        }
        catch (ChimeraFsException e) {
            res.status = 5;
            res.resfail = new WRITE3resfail();
            res.resfail.file_wcc = HimeraNfsUtils.defaultWccData();
        }
        catch (Exception e) {
            _log.error("WRITE", (Throwable)e);
            res.status = 10006;
            res.resfail = new WRITE3resfail();
            res.resfail.file_wcc = HimeraNfsUtils.defaultWccData();
        }
        return res;
    }
}

