/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs;

import com.google.common.collect.Lists;
import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.RetentionPolicy;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dcache.acl.ACE;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.DirectoryStreamB;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsInode_TAG;
import org.dcache.chimera.FsStat;
import org.dcache.chimera.HimeraDirectoryEntry;
import org.dcache.chimera.IOHimeraFsException;
import org.dcache.chimera.StorageLocatable;
import org.dcache.chimera.nfs.ChimeraNFSException;
import org.dcache.chimera.nfs.ExportFile;
import org.dcache.chimera.nfs.FsExport;
import org.dcache.chimera.nfs.PseudoFsNode;
import org.dcache.chimera.posix.Stat;
import org.dcache.chimera.store.InodeStorageInformation;
import org.dcache.xdr.RpcCall;

public class PseudoFsProvider
implements FileSystemProvider {
    private final FileSystemProvider _inner;
    private final ExportFile _export;
    private final RpcCall _call;
    private final int PSEUDO_FS_ID = 255;
    private final byte[] PSEUDO_FH_SIGNATURE = Integer.toString(255).getBytes(Charset.forName("utf8"));

    public PseudoFsProvider(FileSystemProvider inner, ExportFile exportFile, RpcCall call) {
        this._inner = inner;
        this._export = exportFile;
        this._call = call;
    }

    public void addInodeLocation(FsInode inode, int type, String location) throws ChimeraFsException {
        this._inner.addInodeLocation(inode, type, location);
    }

    public void clearInodeLocation(FsInode inode, int type, String location) throws ChimeraFsException {
        this._inner.clearInodeLocation(inode, type, location);
    }

    public FsInode createFile(String path) throws ChimeraFsException {
        return this._inner.createFile(path);
    }

    public FsInode createFile(FsInode parent, String name2) throws ChimeraFsException {
        return this._inner.createFile(parent, name2);
    }

    public FsInode createFile(FsInode parent, String name2, int owner, int group, int mode) throws ChimeraFsException {
        return this._inner.createFile(parent, name2, owner, group, mode);
    }

    public FsInode createFile(FsInode parent, String name2, int owner, int group, int mode, int type) throws ChimeraFsException {
        return this._inner.createFile(parent, name2, owner, group, mode, type);
    }

    public FsInode createFileLevel(FsInode inode, int level) throws ChimeraFsException {
        return this._inner.createFileLevel(inode, level);
    }

    public void createFileWithId(FsInode parent, FsInode inode, String name2, int owner, int group, int mode, int type) throws ChimeraFsException {
        this._inner.createFileWithId(parent, inode, name2, owner, group, mode, type);
    }

    public FsInode createHLink(FsInode parent, FsInode inode, String name2) throws ChimeraFsException {
        return this._inner.createHLink(parent, inode, name2);
    }

    public FsInode createLink(String src, String dest) throws ChimeraFsException {
        return this._inner.createLink(src, dest);
    }

    public FsInode createLink(FsInode parent, String name2, String dest) throws ChimeraFsException {
        return this._inner.createLink(parent, name2, dest);
    }

    public FsInode createLink(FsInode parent, String name2, int uid, int gid, int mode, byte[] dest) throws ChimeraFsException {
        return this._inner.createLink(parent, name2, uid, gid, mode, dest);
    }

    public void createTag(FsInode inode, String name2) throws ChimeraFsException {
        this._inner.createTag(inode, name2);
    }

    public void createTag(FsInode inode, String name2, int uid, int gid, int mode) throws ChimeraFsException {
        this._inner.createTag(inode, name2, uid, gid, mode);
    }

    public AccessLatency getAccessLatency(FsInode inode) throws ChimeraFsException {
        return this._inner.getAccessLatency(inode);
    }

    public int getFsId() {
        return 255;
    }

    public FsStat getFsStat() throws ChimeraFsException {
        return this._inner.getFsStat();
    }

    public String getInfo() {
        return this._inner.getInfo();
    }

    public String getInodeChecksum(FsInode inode, int type) throws ChimeraFsException {
        return this._inner.getInodeChecksum(inode, type);
    }

    public List<StorageLocatable> getInodeLocations(FsInode inode, int type) throws ChimeraFsException {
        return this._inner.getInodeLocations(inode, type);
    }

    public FsInode getParentOf(FsInode inode) throws ChimeraFsException {
        return this._inner.getParentOf(inode);
    }

    public RetentionPolicy getRetentionPolicy(FsInode inode) throws ChimeraFsException {
        return this._inner.getRetentionPolicy(inode);
    }

    public InodeStorageInformation getSorageInfo(FsInode inode) throws ChimeraFsException {
        return this._inner.getSorageInfo(inode);
    }

    public int getTag(FsInode inode, String tagName, byte[] data, int offset, int len) throws ChimeraFsException {
        return this._inner.getTag(inode, tagName, data, offset, len);
    }

    public String inode2path(FsInode inode) throws ChimeraFsException {
        return this._inner.inode2path(inode);
    }

    public String inode2path(FsInode inode, FsInode startFrom, boolean inclusive) throws ChimeraFsException {
        return this._inner.inode2path(inode, startFrom, inclusive);
    }

    public FsInode inodeOf(FsInode parent, String name2) throws ChimeraFsException {
        if (this.isPseudoFs(parent)) {
            PseudoFsNode parentNode = this.pseudoNodeOf(parent, this._export);
            PseudoFsNode child = parentNode.getNode(name2);
            if (child == null) {
                throw new ChimeraNFSException(13, "permission denied");
            }
            if (child.isMountPoint()) {
                if (child.getExport().isReferal()) {
                    return new ReferralInode((FileSystemProvider)this, child.getExport());
                }
                if (child.getExport().isAllowed(PseudoFsProvider.remoteAddressOf(this._call))) {
                    FsInode inode = this._inner.inodeOf(parent, name2);
                    return this.makeRealInode(inode);
                }
                if (child.isLeaf()) {
                    throw new ChimeraNFSException(13, "permission denied");
                }
            }
        }
        return this._inner.inodeOf(parent, name2);
    }

    public boolean isIoEnabled(FsInode inode) throws ChimeraFsException {
        return this._inner.isIoEnabled(inode);
    }

    public FsInode mkdir(String path) throws ChimeraFsException {
        return this._inner.mkdir(path);
    }

    public FsInode mkdir(FsInode parent, String name2) throws ChimeraFsException {
        return this._inner.mkdir(parent, name2);
    }

    public FsInode mkdir(FsInode parent, String name2, int owner, int group, int mode) throws ChimeraFsException {
        return this._inner.mkdir(parent, name2, owner, group, mode);
    }

    public boolean move(String source, String dest) {
        return this._inner.move(source, dest);
    }

    public boolean move(FsInode srcDir, String source, FsInode destDir, String dest) throws ChimeraFsException {
        return this._inner.move(srcDir, source, destDir, dest);
    }

    public DirectoryStreamB<HimeraDirectoryEntry> newDirectoryStream(FsInode dir) throws IOHimeraFsException {
        try {
            PseudoFsNode dirNode;
            DirectoryStreamB directoryEntries = this._inner.newDirectoryStream(dir);
            if (this.isPseudoFs(dir) && !(dirNode = this.pseudoNodeOf(dir, this._export)).isMountPoint()) {
                ArrayList<PseudoFsNode> dirs = new ArrayList<PseudoFsNode>(dirNode.getChildren());
                return new PseudoFsDirectoryStream((DirectoryStreamB<HimeraDirectoryEntry>)directoryEntries, dirs.toArray(new PseudoFsNode[0]));
            }
            return directoryEntries;
        }
        catch (ChimeraFsException e) {
            throw new IOHimeraFsException(e.getMessage());
        }
    }

    public FsInode path2inode(String path) throws ChimeraFsException {
        FsInode inode = this._inner.path2inode(path);
        if (path.equals("/")) {
            return this.makePseudoInode(new FsInode((FileSystemProvider)this, inode.toString()));
        }
        return inode;
    }

    public FsInode path2inode(String path, FsInode startFrom) throws ChimeraFsException {
        return this._inner.path2inode(path, startFrom);
    }

    public int read(FsInode inode, int level, long beginIndex, byte[] data, int offset, int len) throws ChimeraFsException {
        return this._inner.read(inode, level, beginIndex, data, offset, len);
    }

    public byte[] readLink(String path) throws ChimeraFsException {
        return this._inner.readLink(path);
    }

    public byte[] readLink(FsInode inode) throws ChimeraFsException {
        return this._inner.readLink(inode);
    }

    public boolean remove(String path) throws ChimeraFsException {
        return this._inner.remove(path);
    }

    public boolean remove(FsInode parent, String name2) throws ChimeraFsException {
        return this._inner.remove(parent, name2);
    }

    public boolean remove(FsInode inode) throws ChimeraFsException {
        return this._inner.remove(inode);
    }

    public boolean removeFileMetadata(String path, int level) throws ChimeraFsException {
        return this._inner.removeFileMetadata(path, level);
    }

    public void removeInodeChecksum(FsInode inode, int type) throws ChimeraFsException {
        this._inner.removeInodeChecksum(inode, type);
    }

    public void removeTag(FsInode dir, String tagName) throws ChimeraFsException {
        this._inner.removeTag(dir, tagName);
    }

    public void removeTag(FsInode dir) throws ChimeraFsException {
        this._inner.removeTag(dir);
    }

    public void setAccessLatency(FsInode inode, AccessLatency accessLatency) throws ChimeraFsException {
        this._inner.setAccessLatency(inode, accessLatency);
    }

    public void setFileATime(FsInode inode, long atime) throws ChimeraFsException {
        this._inner.setFileATime(inode, atime);
    }

    public void setFileATime(FsInode inode, int level, long atime) throws ChimeraFsException {
        this._inner.setFileATime(inode, level, atime);
    }

    public void setFileCTime(FsInode inode, long ctime) throws ChimeraFsException {
        this._inner.setFileCTime(inode, ctime);
    }

    public void setFileCTime(FsInode inode, int level, long ctime) throws ChimeraFsException {
        this._inner.setFileCTime(inode, level, ctime);
    }

    public void setFileGroup(FsInode inode, int newGroup) throws ChimeraFsException {
        this._inner.setFileGroup(inode, newGroup);
    }

    public void setFileGroup(FsInode inode, int level, int newGroup) throws ChimeraFsException {
        this._inner.setFileGroup(inode, level, newGroup);
    }

    public void setFileMTime(FsInode inode, long mtime) throws ChimeraFsException {
        this._inner.setFileMTime(inode, mtime);
    }

    public void setFileMTime(FsInode inode, int level, long mtime) throws ChimeraFsException {
        this._inner.setFileMTime(inode, level, mtime);
    }

    public void setFileMode(FsInode inode, int newMode) throws ChimeraFsException {
        this._inner.setFileMode(inode, newMode);
    }

    public void setFileMode(FsInode inode, int level, int newMode) throws ChimeraFsException {
        this._inner.setFileMode(inode, level, newMode);
    }

    public void setFileName(FsInode dir, String oldName, String newName) throws ChimeraFsException {
        this._inner.setFileName(dir, oldName, newName);
    }

    public void setFileOwner(FsInode inode, int newOwner) throws ChimeraFsException {
        this._inner.setFileOwner(inode, newOwner);
    }

    public void setFileOwner(FsInode inode, int level, int newOwner) throws ChimeraFsException {
        this._inner.setFileOwner(inode, level, newOwner);
    }

    public void setFileSize(FsInode inode, long newSize) throws ChimeraFsException {
        this._inner.setFileSize(inode, newSize);
    }

    public void setInodeAttributes(FsInode inode, int level, Stat stat) throws ChimeraFsException {
        this._inner.setInodeAttributes(inode, level, stat);
    }

    public void setInodeChecksum(FsInode inode, int type, String checksum) throws ChimeraFsException {
        this._inner.setInodeChecksum(inode, type, checksum);
    }

    public void setInodeIo(FsInode inode, boolean enable) throws ChimeraFsException {
        this._inner.setInodeIo(inode, enable);
    }

    public void setRetentionPolicy(FsInode inode, RetentionPolicy retentionPolicy) throws ChimeraFsException {
        this._inner.setRetentionPolicy(inode, retentionPolicy);
    }

    public void setStorageInfo(FsInode inode, InodeStorageInformation storageInfo) throws ChimeraFsException {
        this._inner.setStorageInfo(inode, storageInfo);
    }

    public int setTag(FsInode inode, String tagName, byte[] data, int offset, int len) throws ChimeraFsException {
        return this._inner.setTag(inode, tagName, data, offset, len);
    }

    public Stat stat(String path) throws ChimeraFsException {
        return this._inner.stat(path);
    }

    public Stat stat(FsInode inode) throws ChimeraFsException {
        if (this.isPseudoFs(inode)) {
            return PseudoFsProvider.pseudoInodeStat(inode);
        }
        return this._inner.stat(inode);
    }

    public Stat stat(FsInode inode, int level) throws ChimeraFsException {
        if (this.isPseudoFs(inode)) {
            return PseudoFsProvider.pseudoInodeStat(inode);
        }
        return this._inner.stat(inode, level);
    }

    public Stat statTag(FsInode dir, String name2) throws ChimeraFsException {
        return this._inner.statTag(dir, name2);
    }

    public String[] tags(FsInode inode) throws ChimeraFsException {
        return this._inner.tags(inode);
    }

    public int write(FsInode inode, int level, long beginIndex, byte[] data, int offset, int len) throws ChimeraFsException {
        return this._inner.write(inode, level, beginIndex, data, offset, len);
    }

    public void close() throws IOException {
        this._inner.close();
    }

    public void setACL(FsInode inode, List<ACE> acl) throws ChimeraFsException {
        this._inner.setACL(inode, acl);
    }

    public List<ACE> getACL(FsInode inode) throws ChimeraFsException {
        return this._inner.getACL(inode);
    }

    private boolean isPseudoFs(FsInode inode) {
        return inode.fsId() == 255;
    }

    private FsInode makePseudoInode(FsInode inode) {
        return new PseudoInode(this, inode.toString());
    }

    private FsInode makeRealInode(FsInode inode) {
        return new FsInode(this._inner, inode.toString());
    }

    private static Stat pseudoInodeStat(FsInode inode) {
        long now = System.currentTimeMillis();
        Stat stat = new Stat();
        stat.setIno((int)inode.id());
        stat.setUid(0);
        stat.setGid(0);
        stat.setSize(512L);
        stat.setMode(16749);
        stat.setRdev(17);
        stat.setDev(17);
        stat.setATime(now);
        stat.setCTime(now);
        stat.setMTime(now);
        stat.setNlink(2);
        return stat;
    }

    public FsInode inodeFromBytes(byte[] bytes) throws ChimeraFsException {
        FsInode inode = this._inner.inodeFromBytes(bytes);
        if (PseudoFsProvider.verifyHandle(this.PSEUDO_FH_SIGNATURE, bytes, this.PSEUDO_FH_SIGNATURE.length)) {
            return this.makePseudoInode(inode);
        }
        return inode;
    }

    public byte[] inodeToBytes(FsInode inode) throws ChimeraFsException {
        if (inode instanceof ReferralInode) {
            throw new ChimeraNFSException(10019, "inode is a referral");
        }
        return this._inner.inodeToBytes(inode);
    }

    public List<FsInode> path2inodes(String path) throws ChimeraFsException {
        return this._inner.path2inodes(path);
    }

    public List<FsInode> path2inodes(String path, FsInode startFrom) throws ChimeraFsException {
        return this._inner.path2inodes(path, startFrom);
    }

    public void setTagMode(FsInode_TAG tagInode, String name2, int mode) throws ChimeraFsException {
        this._inner.setTagMode(tagInode, name2, mode);
    }

    public void setTagOwner(FsInode_TAG tagInode, String name2, int owner) throws ChimeraFsException {
        this._inner.setTagOwner(tagInode, name2, owner);
    }

    public void setTagOwnerGroup(FsInode_TAG tagInode, String name2, int owner) throws ChimeraFsException {
        this._inner.setTagOwnerGroup(tagInode, name2, owner);
    }

    private static InetAddress remoteAddressOf(RpcCall call) {
        return call.getTransport().getRemoteSocketAddress().getAddress();
    }

    private static boolean verifyHandle(byte[] original, byte[] bytes, int length) {
        assert (original.length >= length);
        if (bytes.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (original[i] == bytes[i]) continue;
            return false;
        }
        return true;
    }

    private PseudoFsNode pseudoNodeOf(FsInode input, ExportFile exportFile) throws ChimeraFsException {
        String path = this._inner.inode2path(input);
        if (path.isEmpty()) {
            path = "/";
        }
        return exportFile.getExportNode(path);
    }

    public static class PseudoInode
    extends FsInode {
        public PseudoInode(FileSystemProvider fs, String id) {
            super(fs, id);
        }

        public Stat stat() throws ChimeraFsException {
            return PseudoFsProvider.pseudoInodeStat(this);
        }

        public Stat statCache() throws ChimeraFsException {
            return this.stat();
        }
    }

    public static class ReferralInode
    extends PseudoInode {
        private final String _host;
        private final String _path;
        private final FsExport _export;

        public ReferralInode(FileSystemProvider fs, FsExport export) {
            super(fs, "");
            this._export = export;
            String referral = export.getReferal();
            int i = referral.indexOf(64);
            this._path = ReferralInode.stripLeadingSlash(referral.substring(0, i));
            this._host = referral.substring(i + 1);
        }

        @Override
        public Stat stat() throws ChimeraFsException {
            return PseudoFsProvider.pseudoInodeStat(this);
        }

        @Override
        public Stat statCache() throws ChimeraFsException {
            return this.stat();
        }

        public int fsId() {
            return super.fsId() + 1;
        }

        public String getHost() {
            return this._host;
        }

        public String getPath() {
            return this._path;
        }

        public String getExport() {
            return ReferralInode.stripLeadingSlash(this._export.getPath());
        }

        private static String stripLeadingSlash(String s) {
            return s.charAt(0) == '/' ? s.substring(1) : s;
        }
    }

    private class PseudoFsDirectoryStream
    implements DirectoryStreamB<HimeraDirectoryEntry> {
        private final List<HimeraDirectoryEntry> _filteredEntries;
        private final DirectoryStreamB<HimeraDirectoryEntry> _directoryStream;

        public PseudoFsDirectoryStream(DirectoryStreamB<HimeraDirectoryEntry> inner, PseudoFsNode[] filter) {
            this._directoryStream = inner;
            this._filteredEntries = new ArrayList<HimeraDirectoryEntry>(filter.length);
            ArrayList fsEntries = Lists.newArrayList(this._directoryStream);
            for (HimeraDirectoryEntry e : fsEntries) {
                if (!this.inPseudoFs(filter, e.getName())) continue;
                this._filteredEntries.add(new HimeraDirectoryEntry(e.getName(), PseudoFsProvider.this.makePseudoInode(e.getInode()), PseudoFsProvider.pseudoInodeStat(e.getInode())));
            }
            for (PseudoFsNode pseudoNode : filter) {
                if (!pseudoNode.isMountPoint() || !pseudoNode.getExport().isReferal()) continue;
                ReferralInode inode = new ReferralInode(PseudoFsProvider.this._inner, pseudoNode.getExport());
                this._filteredEntries.add(new HimeraDirectoryEntry(pseudoNode.getName(), (FsInode)inode, PseudoFsProvider.pseudoInodeStat(inode)));
            }
        }

        private boolean inPseudoFs(PseudoFsNode[] nodes, String probe) {
            for (PseudoFsNode node : nodes) {
                if (node.isMountPoint() && node.getExport().isReferal() || !node.getName().equals(probe)) continue;
                return true;
            }
            return false;
        }

        public Iterator<HimeraDirectoryEntry> iterator() {
            return this._filteredEntries.iterator();
        }

        public void close() throws IOException {
            this._directoryStream.close();
        }
    }
}

