/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs;

import javax.security.auth.Subject;
import org.dcache.auth.Subjects;
import org.dcache.chimera.nfs.ExportFile;
import org.dcache.chimera.posix.UnixUser;
import org.dcache.xdr.RpcCall;

public class NfsUser {
    private static final UnixUser NOBODY = new UnixUser(-1, -1, new int[0], "localhost");

    private NfsUser() {
    }

    public static UnixUser remoteUser(RpcCall call, ExportFile exports2) {
        Subject subject = call.getCredential().getSubject();
        if (subject.equals(Subjects.NOBODY)) {
            return NOBODY;
        }
        int uid = (int)Subjects.getUid((Subject)subject);
        int[] gids = NfsUser.from(Subjects.getGids((Subject)subject));
        int gid = gids.length > 0 ? gids[0] : -1;
        String host = call.getTransport().getRemoteSocketAddress().getAddress().getHostAddress();
        if (!(uid != 0 || exports2 != null && exports2.isTrusted(call.getTransport().getRemoteSocketAddress().getAddress()))) {
            uid = -1;
            gid = -1;
        }
        return new UnixUser(uid, gid, gids, host);
    }

    private static int[] from(long[] longs) {
        int[] ints = new int[longs.length];
        int i = 0;
        for (long l : longs) {
            ints[i] = (int)l;
            ++i;
        }
        return ints;
    }
}

