/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.dcache.chimera.nfs.ExportClient;
import org.dcache.util.IPMatcher;

public class FsExport {
    private final String _path;
    private final String _referal;
    private final List<ExportClient> _clients = new ArrayList<ExportClient>();

    public FsExport(String path, List<ExportClient> clients, String referral) {
        this._path = path;
        this._clients.addAll(clients);
        this._referal = referral;
    }

    public String getPath() {
        return this._path;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._path).append(":");
        if (this._clients.isEmpty()) {
            sb.append(" *");
        } else {
            for (ExportClient client : this._clients) {
                sb.append(" ").append(client.ip()).append("(").append((Object)client.io()).append(",").append((Object)client.trusted()).append(")");
            }
        }
        return sb.toString();
    }

    public boolean isAllowed(InetAddress client) {
        if (client.isLoopbackAddress()) {
            return true;
        }
        for (ExportClient exportClient : this._clients) {
            if (!IPMatcher.match((String)exportClient.ip(), (InetAddress)client)) continue;
            return true;
        }
        return false;
    }

    public boolean isTrusted(InetAddress client) {
        if (client.isLoopbackAddress()) {
            return true;
        }
        for (ExportClient exportClient : this._clients) {
            if (exportClient.trusted() != ExportClient.Root.TRUSTED || !IPMatcher.match((String)exportClient.ip(), (InetAddress)client)) continue;
            return true;
        }
        return false;
    }

    public List<String> client() {
        ArrayList<String> client = new ArrayList<String>(this._clients.size());
        for (ExportClient exportClient : this._clients) {
            client.add(exportClient.ip());
        }
        return client;
    }

    public boolean isReferal() {
        return this._referal != null;
    }

    public String getReferal() {
        return this._referal;
    }
}

