/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs;

import com.google.common.base.Splitter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.dcache.chimera.nfs.ExportClient;
import org.dcache.chimera.nfs.FsExport;
import org.dcache.chimera.nfs.PseudoFsNode;

public class ExportFile {
    private volatile PseudoFsNode _pseudoFS = new PseudoFsNode(null);
    private final URL _exportFile;

    public ExportFile(File file) throws IOException {
        this(file.toURL());
    }

    public ExportFile(URL file) throws IOException {
        this._exportFile = file;
        this._pseudoFS = this.scanExportFile(file);
    }

    public List<String> getExports() {
        ArrayList<String> out = new ArrayList<String>();
        PseudoFsNode pseudoFsRoot = this._pseudoFS;
        this.walk(out, pseudoFsRoot, null);
        return out;
    }

    private void walk(List<String> out, PseudoFsNode node, String path) {
        if (node.isMountPoint()) {
            out.add(path == null ? "/" : path);
        }
        if (node.isLeaf()) {
            return;
        }
        for (PseudoFsNode next : node.getChildren()) {
            this.walk(out, next, (path == null ? "" : path) + "/" + next.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PseudoFsNode scanExportFile(URL exportFile) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(exportFile.openStream()));
        PseudoFsNode pseudoFsRoot = new PseudoFsNode(null);
        try {
            String line;
            int lineCount = 0;
            while ((line = br.readLine()) != null) {
                FsExport export;
                ++lineCount;
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                StringTokenizer st = new StringTokenizer(line);
                String path = st.nextToken();
                String referral = null;
                if (st.hasMoreTokens()) {
                    ArrayList<ExportClient> clients = new ArrayList<ExportClient>();
                    while (st.hasMoreTokens()) {
                        String hostAndOptions = st.nextToken();
                        StringTokenizer optionsTokenizer = new StringTokenizer(hostAndOptions, "(),");
                        String host = optionsTokenizer.nextToken();
                        ExportClient.Root isTrusted = ExportClient.Root.NOTTRUSTED;
                        ExportClient.IO rw = ExportClient.IO.RO;
                        while (optionsTokenizer.hasMoreTokens()) {
                            String option = optionsTokenizer.nextToken();
                            if (option.equals("rw")) {
                                rw = ExportClient.IO.RW;
                                continue;
                            }
                            if (option.equals("no_root_squash")) {
                                isTrusted = ExportClient.Root.TRUSTED;
                                continue;
                            }
                            if (!option.startsWith("refer=")) continue;
                            referral = option.substring("refer=".length());
                        }
                        ExportClient client = new ExportClient(host, isTrusted, rw);
                        clients.add(client);
                    }
                    export = new FsExport(path, clients, referral);
                } else {
                    ExportClient everyOne = new ExportClient("*", ExportClient.Root.NOTTRUSTED, ExportClient.IO.RO);
                    ArrayList<ExportClient> clients = new ArrayList<ExportClient>(1);
                    clients.add(everyOne);
                    export = new FsExport(path, clients, referral);
                }
                this.pathToPseudoFs(pseudoFsRoot, path, export);
            }
        }
        finally {
            try {
                br.close();
            }
            catch (IOException dummy) {}
        }
        return pseudoFsRoot;
    }

    public FsExport getExport(String path) {
        PseudoFsNode node = this.getExportNode(path);
        return node == null ? null : node.getExport();
    }

    public PseudoFsNode getExportNode(String path) {
        if (path.equals("/")) {
            return this._pseudoFS;
        }
        Splitter splitter = Splitter.on((char)'/').omitEmptyStrings();
        PseudoFsNode rootNode = this._pseudoFS;
        PseudoFsNode node = null;
        for (String s : splitter.split((CharSequence)path)) {
            node = rootNode.getNode(s);
            if (node == null) {
                return null;
            }
            rootNode = node;
        }
        return node;
    }

    public boolean isTrusted(InetAddress client) {
        List<String> exports2 = this.getExports();
        for (String path : exports2) {
            FsExport fsExport = this.getExport(path);
            if (fsExport == null || !fsExport.isTrusted(client)) continue;
            return true;
        }
        return false;
    }

    private void pathToPseudoFs(PseudoFsNode parent, String path, FsExport e) {
        Splitter splitter = Splitter.on((char)'/').omitEmptyStrings();
        for (String s : splitter.split((CharSequence)path)) {
            PseudoFsNode node = parent.getNode(s);
            if (node == null) {
                node = new PseudoFsNode(s);
                parent.addChild(node);
            }
            parent = node;
        }
        parent.setExport(e);
    }

    public PseudoFsNode getPseuFsRoot() {
        return this._pseudoFS;
    }

    public void rescan() throws IOException {
        this._pseudoFS = this.scanExportFile(this._exportFile);
    }
}

