/*
 * Decompiled with CFR 0.152.
 */
package org.opensciencegrid.authz.service;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import org.apache.axis.message.MessageElement;
import org.apache.log4j.Category;
import org.opensaml.QName;
import org.opensaml.SAMLAction;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLAttributeStatement;
import org.opensaml.SAMLAuthorizationDecisionQuery;
import org.opensaml.SAMLAuthorizationDecisionStatement;
import org.opensaml.SAMLException;
import org.opensaml.SAMLQuery;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;
import org.opensaml.SAMLSubject;
import org.opensciencegrid.authz.saml.ObligatedAuthorizationDecisionStatement;
import org.opensciencegrid.authz.saml.SAMLExtensionInit;
import org.opensciencegrid.authz.saml.SAMLUtil;
import org.opensciencegrid.authz.saml.XACMLObligation;
import org.opensciencegrid.authz.service.SecurityUtil;
import org.opensciencegrid.authz.stubs.SAMLRequestPortType;
import org.opensciencegrid.authz.stubs.SAMLRequestType;
import org.opensciencegrid.authz.stubs.SAMLResponseType;
import org.w3c.dom.Element;

public abstract class SAMLAuthZServiceBase
implements SAMLRequestPortType {
    private static final QName AUTHZ_DECISION_STMT = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AuthorizationDecisionStatement");
    private static final QName OBLIG_DECISION_STMT = new QName("opensciencegrid:authorization:saml", "ObligatedAuthorizationDecisionStatement");
    private static final int ASSERTION_VALIDITY_IN_MINUTES = 10;
    static Category log = Category.getInstance((String)SAMLAuthZServiceBase.class.getName());

    protected abstract AuthzDecision authorize(SAMLSubject var1, String var2, Iterator var3, Iterator var4) throws SAMLException;

    public SAMLResponseType SAMLRequest(SAMLRequestType sAMLRequestType) throws RemoteException {
        SAMLRequest sAMLRequest = null;
        String string = null;
        SAMLAuthorizationDecisionQuery sAMLAuthorizationDecisionQuery = null;
        boolean bl = false;
        AuthzDecision authzDecision = null;
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        SAMLResponseType sAMLResponseType = null;
        try {
            SAMLExtensionInit.init();
            string = SecurityUtil.retrieveClientDN();
            log.debug((Object)("Processing incoming SAMLRequest from " + string));
            sAMLRequest = this.processSAMLRequest(sAMLRequestType);
            bl = this.checkRespondWith(sAMLRequest);
            sAMLAuthorizationDecisionQuery = this.extractAuthorizationDecisionQuery(sAMLRequest);
            boolean bl2 = false;
            if (sAMLAuthorizationDecisionQuery != null) {
                String string2 = sAMLAuthorizationDecisionQuery.getResource().replaceAll("%20", " ");
                if (!sAMLAuthorizationDecisionQuery.getResource().equals(string2)) {
                    bl2 = true;
                    sAMLAuthorizationDecisionQuery.setResource(string2);
                }
            }
            if (sAMLAuthorizationDecisionQuery != null) {
                log.debug((Object)"Extracted authorization decision query");
            }
            log.debug((Object)"Calling implementation of authorize method in the authoirzation service subclass");
            authzDecision = this.authorize(sAMLAuthorizationDecisionQuery.getSubject(), sAMLAuthorizationDecisionQuery.getResource(), sAMLAuthorizationDecisionQuery.getActions(), sAMLAuthorizationDecisionQuery.getEvidence());
            log.debug((Object)("Authorize method returned:" + authzDecision.toString()));
            if (authzDecision.decision == null || !authzDecision.decision.equals("Permit") && !authzDecision.decision.equals("Deny") && !authzDecision.decision.equals("Indeterminate")) {
                throw new Exception("Authorize method did not return valid decision value");
            }
            if (authzDecision.actions == null || authzDecision.actions.isEmpty()) {
                throw new Exception("Authorize method did not return any actions");
            }
            if (authzDecision.issuer == null || authzDecision.issuer.length() == 0) {
                throw new Exception("Authorize method did not return issuer value");
            }
            if (authzDecision.obligations != null && !authzDecision.obligations.isEmpty() && !bl) {
                authzDecision.obligations = null;
                log.warn((Object)"Response requires obligations, but the set of client-requested response formats did not include ObligatedAuthoirzationDecisionStatement");
                log.warn((Object)"Must return INDETERMINATE, as obligations cannot be conveyed with standard response");
                authzDecision.decision = "Indeterminate";
            }
            log.debug((Object)("returning AuthorizationDecisionStatement with decision= " + authzDecision.decision));
            if (bl2) {
                sAMLAuthorizationDecisionQuery.setResource(sAMLAuthorizationDecisionQuery.getResource().replaceAll(" ", "%20"));
            }
            arrayList = this.createAuthzDecisionStmt(sAMLAuthorizationDecisionQuery, authzDecision.decision, authzDecision.actions, authzDecision.obligations);
            arrayList2 = this.createAssertions(authzDecision.issuer, arrayList);
            sAMLResponseType = this.createSAMLResponse(sAMLRequest.getId(), string, arrayList2, null);
            log.debug((Object)"Returning response");
            return sAMLResponseType;
        }
        catch (Exception exception) {
            log.error((Object)("ABORT: " + exception));
            log.debug((Object)"Exception trace: ", (Throwable)exception);
            try {
                log.debug((Object)"Attempting to construct a SAML AuthoirzationDecisionStatement with decision = INDETERMINATE");
                if (authzDecision == null) {
                    authzDecision = new AuthzDecision();
                }
                if (authzDecision.actions == null) {
                    authzDecision.actions = new ArrayList(1);
                    log.debug((Object)"don't have actions set so we will duplicate requested actions");
                    Iterator iterator = sAMLAuthorizationDecisionQuery.getActions();
                    while (iterator.hasNext()) {
                        authzDecision.actions.add(iterator.next());
                    }
                }
                if (authzDecision.issuer == null) {
                    authzDecision.issuer = "Unknown";
                }
                arrayList = this.createAuthzDecisionStmt(sAMLAuthorizationDecisionQuery, "Indeterminate", authzDecision.actions, null);
                arrayList2 = this.createAssertions(authzDecision.issuer, arrayList);
                sAMLResponseType = this.createSAMLResponse(sAMLRequest.getId(), string, arrayList2, null);
                log.error((Object)"Responding with SAML AuthorizationDecisionSatement with decision = INDETERMINATE");
                return sAMLResponseType;
            }
            catch (Exception exception2) {
                log.error((Object)"Unable to create a SAML AuthorizationDecisionStatement with decision = INDETERMINATE");
                log.error((Object)("Caught exception was: " + exception2), (Throwable)exception2);
                try {
                    SAMLException sAMLException = new SAMLException(new QName("urn:oasis:names:tc:SAML:1.0:protocol", "RequestDenied"), "Please contact the system administrator of this authorization service for more information");
                    sAMLResponseType = this.createSAMLResponse(sAMLRequest.getId(), string, null, sAMLException);
                    log.error((Object)"Responding with SAML-Exception response: RequestDenied");
                    return sAMLResponseType;
                }
                catch (Exception exception3) {
                    log.error((Object)"Unable to respond to request");
                    log.error((Object)("Caught exception was: " + exception2), (Throwable)exception2);
                    throw new RemoteException("Service unable to respond to request!");
                }
            }
        }
    }

    private SAMLRequest processSAMLRequest(SAMLRequestType sAMLRequestType) throws RemoteException, SAMLException {
        SAMLRequest sAMLRequest;
        log.debug((Object)"Validating request type");
        if (sAMLRequestType == null) {
            throw new RemoteException("Received a null request");
        }
        log.debug((Object)"Extracting SAMLRequest");
        try {
            MessageElement[] messageElementArray = sAMLRequestType.get_any();
            sAMLRequest = new SAMLRequest(messageElementArray[0].getAsDOM());
            if (sAMLRequest == null) {
                throw new RemoteException("SAMLRequest returned null");
            }
        }
        catch (Exception exception) {
            throw new RemoteException("Error extracting SAML Request object: " + exception);
        }
        return sAMLRequest;
    }

    private boolean checkRespondWith(SAMLRequest sAMLRequest) throws RemoteException, SAMLException {
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = sAMLRequest.getRespondWiths();
        if (iterator == null) {
            log.debug((Object)"No respondWith elements found in request, enabling ObligatedAuthorizationDecisionStatement");
            bl2 = true;
        } else {
            while (iterator.hasNext()) {
                QName qName = (QName)iterator.next();
                if (qName.equals((Object)AUTHZ_DECISION_STMT)) {
                    bl = true;
                    log.debug((Object)("Supported respondWith: " + qName.toString()));
                    continue;
                }
                if (qName.equals((Object)OBLIG_DECISION_STMT)) {
                    bl2 = true;
                    log.debug((Object)("Supported respondWith: " + qName.toString()));
                    continue;
                }
                log.debug((Object)("Found unrecognized respondWith: " + qName.toString()));
            }
            if (!bl) {
                log.debug((Object)"Standard SAML AuthorizationDecisionStatement is not supported by client, aborting");
                throw new RemoteException("Standard SAML AuthorizationDecisionStatement is not supported by client.");
            }
        }
        return bl2;
    }

    private SAMLAuthorizationDecisionQuery extractAuthorizationDecisionQuery(SAMLRequest sAMLRequest) throws RemoteException, SAMLException {
        SAMLQuery sAMLQuery = sAMLRequest.getQuery();
        if (sAMLQuery instanceof SAMLAuthorizationDecisionQuery) {
            log.debug((Object)("FOUND SAMLAuthorizationDecisionQuery: " + sAMLQuery));
            return (SAMLAuthorizationDecisionQuery)sAMLQuery;
        }
        log.error((Object)("Request not supported: " + sAMLQuery));
        throw new RemoteException("Request not supported.");
    }

    private String getRequestUser(SAMLSubject sAMLSubject) throws SAMLException {
        String string = sAMLSubject.getName().getName();
        return string;
    }

    private ArrayList createAuthzDecisionStmt(SAMLAuthorizationDecisionQuery sAMLAuthorizationDecisionQuery, String string, ArrayList arrayList, ArrayList arrayList2) throws SAMLException {
        ArrayList<SAMLAuthorizationDecisionStatement> arrayList3 = new ArrayList<SAMLAuthorizationDecisionStatement>(1);
        SAMLAuthorizationDecisionStatement sAMLAuthorizationDecisionStatement = arrayList2 != null && !arrayList2.isEmpty() ? new ObligatedAuthorizationDecisionStatement(sAMLAuthorizationDecisionQuery.getSubject(), sAMLAuthorizationDecisionQuery.getResource(), string, arrayList, null, arrayList2) : new SAMLAuthorizationDecisionStatement(sAMLAuthorizationDecisionQuery.getSubject(), sAMLAuthorizationDecisionQuery.getResource(), string, (Collection)arrayList, null);
        arrayList3.add(sAMLAuthorizationDecisionStatement);
        return arrayList3;
    }

    private ArrayList createAssertions(String string, ArrayList arrayList) throws SAMLException {
        ArrayList<SAMLAssertion> arrayList2 = new ArrayList<SAMLAssertion>(1);
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(12, 10);
        SAMLAssertion sAMLAssertion = new SAMLAssertion(string, calendar.getTime(), calendar2.getTime(), null, null, (Collection)arrayList);
        arrayList2.add(sAMLAssertion);
        return arrayList2;
    }

    private SAMLResponseType createSAMLResponse(String string, String string2, ArrayList arrayList, SAMLException sAMLException) throws SAMLException {
        SAMLResponseType sAMLResponseType = null;
        string2 = string2 == null ? null : string2.replaceAll("\\s", "%20");
        SAMLResponse sAMLResponse = new SAMLResponse(string, string2, (Collection)arrayList, sAMLException);
        log.debug((Object)("Created SAMLResponse: " + sAMLResponse));
        sAMLResponseType = new SAMLResponseType();
        sAMLResponseType.set_any(new MessageElement[]{new MessageElement((Element)sAMLResponse.toDOM())});
        return sAMLResponseType;
    }

    protected String getFQAN(SAMLAttributeStatement sAMLAttributeStatement) throws SAMLException {
        String string = null;
        Iterator iterator = sAMLAttributeStatement.getAttributes();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SAMLAttribute)) continue;
            String string2 = ((SAMLAttribute)e).getName();
            String string3 = ((SAMLAttribute)e).getNamespace();
            log.debug((Object)("Found Evidence Attribute:  " + string2 + " with namespace: " + string3));
            if (!string2.equals("FQAN") || !string3.equals("opensciencegrid:authorization")) continue;
            string = this.getAttributeValue((SAMLAttribute)e);
        }
        if (string != null) {
            log.debug((Object)("Found FQAN Attribute: " + string));
        } else {
            log.warn((Object)"Found unsupported FQAN Attribute (it had no string value!!!)");
        }
        return string;
    }

    protected FQAN findFQANinSubjectEvidence(Iterator iterator, SAMLSubject sAMLSubject) throws SAMLException {
        FQAN fQAN = new FQAN();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SAMLAssertion)) continue;
            fQAN.issuer = ((SAMLAssertion)e).getIssuer();
            Iterator iterator2 = ((SAMLAssertion)e).getStatements();
            while (iterator2.hasNext()) {
                Object e2 = iterator2.next();
                if (!(e2 instanceof SAMLAttributeStatement) || !SAMLUtil.samlSubjectMatch(sAMLSubject, ((SAMLAttributeStatement)e2).getSubject())) continue;
                fQAN.data = this.getFQAN((SAMLAttributeStatement)e2);
                if (fQAN.data == null) continue;
                return fQAN;
            }
        }
        return null;
    }

    protected ArrayList locatePermissibleActions(Iterator iterator, ArrayList arrayList) {
        ArrayList<SAMLAction> arrayList2 = new ArrayList<SAMLAction>(1);
        log.debug((Object)"Locating permissible actions");
        block0: while (iterator.hasNext()) {
            SAMLAction sAMLAction = (SAMLAction)iterator.next();
            for (int i = 0; i < arrayList.size(); ++i) {
                SAMLAction sAMLAction2 = (SAMLAction)arrayList.get(i);
                if (!SAMLUtil.samlActionMatch(sAMLAction2, sAMLAction)) continue;
                log.debug((Object)("requested action matched permissible action: " + sAMLAction));
                arrayList2.add(sAMLAction);
                arrayList.remove(i);
                continue block0;
            }
        }
        if (arrayList2.isEmpty()) {
            return null;
        }
        return arrayList2;
    }

    private String getAttributeValue(SAMLAttribute sAMLAttribute) throws SAMLException {
        String string = null;
        Iterator iterator = sAMLAttribute.getValues();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof String)) continue;
            string = (String)e;
            break;
        }
        return string;
    }

    protected class FQAN {
        String issuer;
        String data;

        protected FQAN() {
        }
    }

    public class AuthzDecision {
        public String decision = "Indeterminate";
        public ArrayList actions;
        public ArrayList obligations;
        public String issuer;

        public String toString() {
            Object object;
            Object e;
            int n;
            String string = "Decision: " + this.decision;
            string = string.concat(", Actions: ");
            if (this.actions == null) {
                string = string.concat("null");
            } else if (this.actions.isEmpty()) {
                string = string.concat("empty");
            } else {
                for (n = 0; n < this.actions.size(); ++n) {
                    e = this.actions.get(n);
                    if (e instanceof SAMLAction) {
                        object = (SAMLAction)e;
                        string = string.concat(object.getNamespace() + " " + object.getData() + " | ");
                        continue;
                    }
                    string = string.concat(this.actions.get(n).toString() + " | ");
                }
            }
            string = string.concat(", Obligations: ");
            if (this.obligations == null) {
                string = string.concat("null");
            } else if (this.obligations.isEmpty()) {
                string = string.concat("empty");
            } else {
                for (n = 0; n < this.obligations.size(); ++n) {
                    e = this.obligations.get(n);
                    if (e instanceof XACMLObligation) {
                        object = (XACMLObligation)e;
                        string = string.concat(((XACMLObligation)object).getObligationId() + " " + ((XACMLObligation)object).getAttributeId() + "=" + ((XACMLObligation)object).getValue()) + " | ";
                        continue;
                    }
                    string = string.concat("Unsupported Obligation | ");
                }
            }
            string = string.concat(", Issuer: " + this.issuer);
            return string;
        }
    }
}

