/*
 * Decompiled with CFR 0.152.
 */
package org.opensciencegrid.authz.service;

import java.util.Enumeration;

class QuotedStringTokenizer
implements Enumeration {
    private int limit;
    private int start;
    private String str;

    public QuotedStringTokenizer(String string) {
        this.str = string;
        this.start = 0;
        this.limit = string.length();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public String nextToken() {
        while (this.start < this.limit && this.str.charAt(this.start) <= ' ') {
            ++this.start;
        }
        if (this.start == this.limit) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(this.limit - this.start);
        char c = this.str.charAt(this.start);
        if (c == '\"' || c == '\'') {
            ++this.start;
            for (int i = this.start; i < this.limit; ++i) {
                char c2 = this.str.charAt(i);
                ++this.start;
                if (c2 == c) break;
                if (c2 == '\\') {
                    stringBuffer.append(this.str.charAt(++i));
                    ++this.start;
                    continue;
                }
                stringBuffer.append(c2);
            }
            return stringBuffer.toString();
        }
        for (int i = this.start; i < this.limit; ++i) {
            char c3 = this.str.charAt(i);
            ++this.start;
            if (c3 == ' ') break;
            stringBuffer.append(c3);
        }
        return stringBuffer.toString();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public boolean hasMoreTokens() {
        while (this.start < this.limit && this.str.charAt(this.start) <= ' ') {
            ++this.start;
        }
        return this.start != this.limit;
    }

    public int countTokens() {
        int n = this.start;
        int n2 = 0;
        while (this.nextToken() != null) {
            ++n2;
        }
        this.start = n;
        return n2;
    }
}

