/*
 * Decompiled with CFR 0.152.
 */
package org.opensciencegrid.authz.service;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.log4j.Category;
import org.opensciencegrid.authz.common.GridId;
import org.opensciencegrid.authz.common.LocalId;
import org.opensciencegrid.authz.service.GRIDIdentityMappingService;
import org.opensciencegrid.authz.service.QuotedStringTokenizer;

public class GRIDIdentityMappingServiceExampleImpl
implements GRIDIdentityMappingService {
    static Category log = Category.getInstance((String)GRIDIdentityMappingServiceExampleImpl.class.getName());
    private static String STDMAPFILE = "/etc/grid-security/mapsvc-gridmap";
    private static final String COMMENT_CHARS = "#";
    private ArrayList mappings;

    public void init() {
        String string = System.getProperty("gridmap.file");
        if (string != null) {
            log.debug((Object)("Parsing gridmap file from: " + string));
        } else {
            string = STDMAPFILE;
            log.debug((Object)"System property gridmap.file not available");
            log.debug((Object)("Parsing gridmap file from standard location: " + string));
        }
        try {
            this.mappings = this.parseMappingFile(string);
        }
        catch (Exception exception) {
            log.error((Object)("Unable to parse gridmap file: " + exception));
            log.debug((Object)exception);
        }
        if (this.mappings == null || this.mappings.isEmpty()) {
            log.debug((Object)"No gridmap entries were retrieved from gridmap file");
        } else {
            log.debug((Object)("Gridmap table loaded: " + this.mappings));
        }
    }

    public LocalId mapCredentials(GridId gridId) throws Exception {
        log.debug((Object)"entered mapCredentials of mapping service");
        if (this.mappings == null) {
            this.init();
        }
        if (this.mappings == null) {
            log.debug((Object)"mapping table is empty, returning null (deny)");
            return null;
        }
        log.debug((Object)"attempting to find a mapping");
        for (int i = 0; i < this.mappings.size(); ++i) {
            MapEntry mapEntry = (MapEntry)this.mappings.get(i);
            log.debug((Object)("comparing " + mapEntry.getSubjectDN() + " to " + gridId.getUserDN()));
            if (!mapEntry.getSubjectDN().equals(gridId.getUserDN())) continue;
            log.debug((Object)"found matching subject DN in gridmap table");
            if (mapEntry.getFQAN() == null && gridId.getUserFQAN() == null) {
                log.debug((Object)("no FQANS, returning mapping for local user: " + mapEntry.getUserName()));
                return mapEntry;
            }
            if (mapEntry.getFQAN() == null || gridId.getUserFQAN() == null) {
                log.debug((Object)"FQANs don't match for this entry (null)");
                continue;
            }
            if (mapEntry.getFQAN().equals(gridId.getUserFQAN())) {
                log.debug((Object)("FQAN matches, returning mapping for local user: " + mapEntry.getUserName()));
                return mapEntry;
            }
            log.debug((Object)"FQANs don't match for this entry");
        }
        log.debug((Object)"returning null, no valid mapping could be found");
        return null;
    }

    private ArrayList parseMappingFile(String string) throws IOException {
        String string2;
        FileInputStream fileInputStream = null;
        ArrayList<MapEntry> arrayList = new ArrayList<MapEntry>(50);
        fileInputStream = new FileInputStream(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        while ((string2 = bufferedReader.readLine()) != null) {
            if ((string2 = string2.trim()).length() == 0 || string2.substring(0, 1).indexOf(COMMENT_CHARS) != -1) continue;
            MapEntry mapEntry = new MapEntry();
            QuotedStringTokenizer quotedStringTokenizer = new QuotedStringTokenizer(string2);
            if (!quotedStringTokenizer.hasMoreTokens()) {
                throw new IOException("Subject DN not defined: " + string2);
            }
            mapEntry.setSubjectDN(quotedStringTokenizer.nextToken());
            if (!quotedStringTokenizer.hasMoreTokens()) {
                throw new IOException("Local user name not defined: " + string2);
            }
            mapEntry.setUserName(quotedStringTokenizer.nextToken());
            if (quotedStringTokenizer.hasMoreTokens()) {
                mapEntry.setFQAN(quotedStringTokenizer.nextToken());
            }
            if (quotedStringTokenizer.hasMoreTokens()) {
                mapEntry.setGroupName(quotedStringTokenizer.nextToken());
            }
            if (quotedStringTokenizer.hasMoreTokens()) {
                ArrayList<String> arrayList2 = new ArrayList<String>(16);
                while (quotedStringTokenizer.hasMoreTokens()) {
                    arrayList2.add(quotedStringTokenizer.nextToken());
                }
                if (!arrayList2.isEmpty()) {
                    String[] stringArray = new String[arrayList2.size()];
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        stringArray[i] = (String)arrayList2.get(i);
                    }
                    mapEntry.setSupplementalGroupNames(stringArray);
                }
            }
            arrayList.add(mapEntry);
        }
        if (fileInputStream != null) {
            ((InputStream)fileInputStream).close();
        }
        return arrayList;
    }

    private class MapEntry
    extends LocalId {
        String subjectDN;
        String fqan;

        private MapEntry() {
        }

        public void setSubjectDN(String string) {
            this.subjectDN = string;
        }

        public String getSubjectDN() {
            return this.subjectDN;
        }

        public void setFQAN(String string) {
            this.fqan = string;
        }

        public String getFQAN() {
            return this.fqan;
        }

        public String toString() {
            String string = this.subjectDN + " " + this.getUserName() + " " + this.fqan + " " + this.getGroupName() + " ";
            String[] stringArray = this.getSupplementalGroupNames();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    string = string.concat(stringArray[i] + " ");
                }
            }
            return string;
        }
    }
}

