/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.dc;

import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;
import org.globus.ftp.Session;
import org.globus.ftp.dc.DataChannel;
import org.globus.ftp.dc.DataChannelFactory;
import org.globus.ftp.dc.SimpleSocketBox;
import org.globus.ftp.dc.SocketBox;
import org.globus.ftp.dc.Task;
import org.globus.ftp.dc.TransferContext;
import org.globus.ftp.vanilla.BasicServerControlChannel;
import org.globus.ftp.vanilla.FTPServerFacade;

public class PassiveConnectTask
extends Task {
    protected static Log logger = LogFactory.getLog((String)PassiveConnectTask.class.getName());
    protected ServerSocket myServer;
    protected SocketBox mySocketBox;
    protected DataSink sink;
    protected DataSource source;
    protected BasicServerControlChannel control;
    protected Session session;
    protected DataChannelFactory factory;
    protected TransferContext context;

    public PassiveConnectTask(ServerSocket myServer, DataSink sink, BasicServerControlChannel control, Session session, DataChannelFactory factory, TransferContext context) {
        this.sink = sink;
        this.init(myServer, control, session, factory, context);
    }

    public PassiveConnectTask(ServerSocket myServer, DataSource source, BasicServerControlChannel control, Session session, DataChannelFactory factory, TransferContext context) {
        this.source = source;
        this.init(myServer, control, session, factory, context);
    }

    private void init(ServerSocket myServer, BasicServerControlChannel control, Session session, DataChannelFactory factory, TransferContext context) {
        if (session.serverMode != 1 && session.serverMode != 3) {
            throw new IllegalStateException();
        }
        if (myServer == null) {
            throw new IllegalArgumentException("server is nul");
        }
        this.session = session;
        this.myServer = myServer;
        this.control = control;
        this.factory = factory;
        this.context = context;
    }

    public void execute() {
        block9: {
            try {
                DataChannel dataChannel = null;
                this.mySocketBox = null;
                try {
                    this.mySocketBox = this.openSocket();
                }
                catch (Exception e) {
                    FTPServerFacade.exceptionToControlChannel(e, "server.accept() failed", this.control);
                    return;
                }
                try {
                    dataChannel = this.factory.getDataChannel(this.session, this.mySocketBox);
                    if (this.sink != null) {
                        logger.debug((Object)"starting sink data channel");
                        dataChannel.startTransfer(this.sink, this.control, this.context);
                        break block9;
                    }
                    if (this.source != null) {
                        logger.debug((Object)"starting source data channel");
                        dataChannel.startTransfer(this.source, this.control, this.context);
                        break block9;
                    }
                    logger.error((Object)"not set");
                }
                catch (Exception e) {
                    FTPServerFacade.exceptionToControlChannel(e, "startTransfer() failed: ", this.control);
                    if (dataChannel != null) {
                        dataChannel.close();
                    }
                }
            }
            catch (Exception e) {
                FTPServerFacade.cannotPropagateError(e);
            }
        }
    }

    protected SocketBox openSocket() throws Exception {
        logger.debug((Object)"server.accept()");
        SimpleSocketBox sBox = new SimpleSocketBox();
        Socket newSocket = this.myServer.accept();
        sBox.setSocket(newSocket);
        return sBox;
    }

    private void close() {
    }

    public void stop() {
        this.close();
    }
}

