/*
 * Decompiled with CFR 0.152.
 */
package org.globus.common;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.ConfigUtil;

public class CoGProperties
extends Properties {
    private static Log logger = LogFactory.getLog((String)CoGProperties.class.getName());
    private static final String DEFAULT_RANDOM_PROVIDER = "cryptix.jce.provider.CryptixRandom";
    private static final String DEFAULT_RANDOM_ALGORITHM = "DevRandom";
    public static final String ENFORCE_SIGNING_POLICY = "java.security.gsi.signing.policy";
    public static final String DELEGATION_KEY_CACHE_LIFETIME = "org.globus.jglobus.delegation.cache.lifetime";
    public static final String CRL_CACHE_LIFETIME = "org.globus.jglobus.crl.cache.lifetime";
    public static final String MDSHOST = "localhost";
    public static final String MDSPORT = "2135";
    public static final String BASEDN = "Mds-Vo-name=local, o=Grid";
    public static final String CONFIG_FILE = "cog.properties";
    private static CoGProperties defaultProps = null;
    public static String configFile = null;

    public CoGProperties() {
    }

    public CoGProperties(String file) throws IOException {
        this.load(file);
    }

    public static synchronized CoGProperties getDefault() {
        if (defaultProps != null) {
            return defaultProps;
        }
        defaultProps = new CoGProperties();
        String file = System.getProperty("org.globus.config.file");
        if (file == null) {
            file = ConfigUtil.globus_dir + CONFIG_FILE;
        } else if (file.equalsIgnoreCase("none")) {
            return defaultProps;
        }
        configFile = file;
        try {
            defaultProps.load(configFile);
        }
        catch (IOException e) {
            logger.debug((Object)"Failed to load cog.properties. Using defaults.", (Throwable)e);
        }
        return defaultProps;
    }

    public static void setDefault(CoGProperties properties) {
        defaultProps = properties;
    }

    public void save() throws IOException {
        this.save(configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String file) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            this.store(out, "Java CoG Kit Configuration File");
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String file) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.load(in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void load(InputStream in) throws IOException {
        super.load(in);
        CoGProperties.fixSpace(this);
    }

    public static void fixSpace(Properties p) {
        Enumeration<Object> e = p.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            String value = p.getProperty(key);
            p.put(key, value.trim());
        }
    }

    public String getUserCertFile() {
        String location = System.getProperty("X509_USER_CERT");
        if (location != null) {
            return location;
        }
        location = this.getProperty("usercert");
        if (location != null) {
            return location;
        }
        return ConfigUtil.discoverUserCertLocation();
    }

    public void setUserCertFile(String userCertFile) {
        this.put("usercert", userCertFile);
    }

    public String getPKCS11LibraryName() {
        String lib = System.getProperty("PKCS11_LIB");
        if (lib != null) {
            return lib;
        }
        lib = this.getProperty("pkcs11lib");
        if (lib != null) {
            return lib;
        }
        return ConfigUtil.discoverPKCS11LibName();
    }

    public String getDefaultPKCS11Handle() {
        return this.getProperty("pkcs11.handle", "Globus User Credentials");
    }

    public String getUserKeyFile() {
        String location = System.getProperty("X509_USER_KEY");
        if (location != null) {
            return location;
        }
        location = this.getProperty("userkey");
        if (location != null) {
            return location;
        }
        return ConfigUtil.discoverUserKeyLocation();
    }

    public void setUserKeyFile(String userKeyFile) {
        this.put("userkey", userKeyFile);
    }

    public String getHostName() {
        String value = System.getProperty("GLOBUS_HOSTNAME");
        if (value != null) {
            return value;
        }
        return this.getProperty("hostname", null);
    }

    public void setHostName(String host) {
        this.put("hostname", host);
    }

    public String getIPAddress() {
        String value = System.getProperty("org.globus.ip");
        if (value != null) {
            return value;
        }
        value = this.getProperty("ip", null);
        if (value != null) {
            return value;
        }
        value = this.getHostName();
        if (value != null) {
            try {
                return InetAddress.getByName(value).getHostAddress();
            }
            catch (UnknownHostException e) {
                return null;
            }
        }
        return value;
    }

    public void setIPAddress(String ipAddress) {
        this.put("ip", ipAddress);
    }

    public String getCaCertFile() {
        return this.getCaCertLocations();
    }

    public String getCaCerts() {
        return this.getCaCertLocations();
    }

    public String getCaCertLocations() {
        String location = System.getProperty("X509_CERT_DIR");
        if (location != null) {
            return location;
        }
        location = this.getProperty("cacert");
        if (location != null) {
            return location;
        }
        return ConfigUtil.discoverCertDirLocation();
    }

    public void setCaCertLocations(String list) {
        this.put("cacert", list);
    }

    public String getProxyFile() {
        String location = System.getProperty("X509_USER_PROXY");
        if (location != null) {
            return location;
        }
        location = this.getProperty("proxy");
        if (location != null) {
            return location;
        }
        return ConfigUtil.discoverProxyLocation();
    }

    public void setProxyFile(String proxyFile) {
        this.put("proxy", proxyFile);
    }

    public String getTcpPortRange() {
        String value = null;
        value = System.getProperty("GLOBUS_TCP_PORT_RANGE");
        if (value != null) {
            return value;
        }
        value = System.getProperty("org.globus.tcp.port.range");
        if (value != null) {
            return value;
        }
        return this.getProperty("tcp.port.range", null);
    }

    public String getTcpSourcePortRange() {
        String value = null;
        value = System.getProperty("GLOBUS_TCP_SOURCE_PORT_RANGE");
        if (value != null) {
            return value;
        }
        value = System.getProperty("org.globus.tcp.source.port.range");
        if (value != null) {
            return value;
        }
        return this.getProperty("tcp.source.port.range", null);
    }

    public String getUdpSourcePortRange() {
        String value = null;
        value = System.getProperty("GLOBUS_UDP_SOURCE_PORT_RANGE");
        if (value != null) {
            return value;
        }
        value = System.getProperty("org.globus.udp.source.port.range");
        if (value != null) {
            return value;
        }
        return this.getProperty("udp.source.port.range", null);
    }

    public boolean useDevRandom() {
        String value = System.getProperty("org.globus.dev.random");
        if (value != null && value.equalsIgnoreCase("no")) {
            return false;
        }
        return this.getAsBoolean("org.globus.dev.random", true);
    }

    public boolean enforceSigningPolicy() {
        String value = System.getProperty(ENFORCE_SIGNING_POLICY);
        if (value != null && (value.equalsIgnoreCase("no") || value.equalsIgnoreCase("false"))) {
            return false;
        }
        return this.getAsBoolean(ENFORCE_SIGNING_POLICY, true);
    }

    public int getDelegationKeyCacheLifetime() {
        int parsedvalueInt;
        int valueInt = 0;
        String valueStr = System.getProperty(DELEGATION_KEY_CACHE_LIFETIME);
        if (valueStr != null && valueStr.length() > 0 && (parsedvalueInt = Integer.parseInt(valueStr)) > 0) {
            valueInt = parsedvalueInt;
        }
        if (valueInt == -1 && (valueStr = this.getProperty(DELEGATION_KEY_CACHE_LIFETIME)) != null && valueStr.length() > 0 && (parsedvalueInt = Integer.parseInt(valueStr)) > 0) {
            valueInt = parsedvalueInt;
        }
        return valueInt;
    }

    public long getCRLCacheLifetime() throws NumberFormatException {
        long parsedValue;
        long value = 0L;
        String property = this.getProperty(CRL_CACHE_LIFETIME);
        if (property != null && property.length() > 0 && (parsedValue = Long.parseLong(property)) > 0L) {
            value = parsedValue;
        }
        if ((property = System.getProperty(CRL_CACHE_LIFETIME)) != null && property.length() > 0 && (parsedValue = Long.parseLong(property)) > 0L) {
            value = parsedValue;
        }
        return value;
    }

    public String getSecureRandomProvider() {
        String value = System.getProperty("org.globus.random.provider");
        if (value != null) {
            return value;
        }
        return this.getProperty("random.provider", DEFAULT_RANDOM_PROVIDER);
    }

    public String getSecureRandomAlgorithm() {
        String value = System.getProperty("org.globus.random.algorithm");
        if (value != null) {
            return value;
        }
        return this.getProperty("random.algorithm", DEFAULT_RANDOM_ALGORITHM);
    }

    public int getSocketTimeout() {
        int parsedTimeoutInt;
        int timeoutInt = -1;
        String timeoutStr = System.getProperty("MYPROXY_SOCKET_TIMEOUT");
        if (timeoutStr != null && timeoutStr.length() > 0 && (parsedTimeoutInt = Integer.parseInt(timeoutStr)) >= 0) {
            timeoutInt = parsedTimeoutInt;
        }
        if (timeoutInt == -1 && (timeoutStr = this.getProperty("sockettimeout")) != null && timeoutStr.length() > 0 && (parsedTimeoutInt = Integer.parseInt(timeoutStr)) >= 0) {
            timeoutInt = parsedTimeoutInt;
        }
        if (timeoutInt == -1) {
            timeoutInt = 10;
        }
        return timeoutInt;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.put("sockettimeout", String.valueOf(socketTimeout));
    }

    public int getProxyStrength() {
        return this.getAsInt("proxy.strength", 512);
    }

    public void setProxyStrength(int strength) {
        this.put("proxy.strength", String.valueOf(strength));
    }

    public int getProxyLifeTime() {
        return this.getAsInt("proxy.lifetime", 12);
    }

    public void setProxyLifeTime(int lifeTimeInHours) {
        this.put("proxy.lifetime", String.valueOf(lifeTimeInHours));
    }

    public String getRootMDSHost() {
        return this.getProperty("mds.root.host", MDSHOST);
    }

    public String getRootMDSPort() {
        return this.getProperty("mds.root.port", MDSPORT);
    }

    public String getRootMDSBaseDN() {
        return this.getProperty("mds.root.basedn", BASEDN);
    }

    public String getOrgMDSHost() {
        return this.getProperty("mds.org.host", MDSHOST);
    }

    public String getOrgMDSPort() {
        return this.getProperty("mds.org.port", MDSPORT);
    }

    public String getOrgMDSBaseDN() {
        return this.getProperty("mds.org.basedn", BASEDN);
    }

    protected boolean getAsBoolean(String key, boolean defaultValue) {
        String tmp = this.getProperty(key);
        if (tmp == null) {
            return defaultValue;
        }
        return tmp.equalsIgnoreCase("yes") || tmp.equalsIgnoreCase("true");
    }

    protected int getAsInt(String label, int defValue) {
        String tmp = this.getProperty(label);
        return CoGProperties.isNullOrEmpty(tmp) ? defValue : Integer.parseInt(tmp);
    }

    protected static final boolean isNullOrEmpty(String tmp) {
        return tmp == null || tmp != null && tmp.length() == 0;
    }
}

