/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.commanddispatcher.test;

import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.freehep.swing.test.TestFrame;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandSourceAdapter;
import org.freehep.util.commanddispatcher.CommandTargetManager;
import org.freehep.util.commanddispatcher.test.NonPrintablePage;
import org.freehep.util.commanddispatcher.test.PrintablePage;

public class MDITest
extends TestFrame {
    private CommandTargetManager manager;
    private JDesktopPane desktop;

    public void addToMenuBar(JMenuBar bar) {
        this.manager = new CommandTargetManager();
        this.manager.add(new MDICommandProcessor());
        bar.add(new FileMenu());
        this.manager.start();
    }

    public JComponent createComponent() {
        this.desktop = new JDesktopPane();
        this.desktop.setPreferredSize(new Dimension(600, 400));
        return this.desktop;
    }

    public static void main(String[] argv) {
        new MDITest();
    }

    public class MDICommandProcessor
    extends CommandProcessor {
        public void onExit() {
            MDITest.this.quit();
        }

        public void onNewNonPrintablePage() {
            NonPrintablePage f = new NonPrintablePage(MDITest.this.manager);
            MDITest.this.desktop.add(f);
            f.setVisible(true);
        }

        public void onNewPrintablePage() {
            PrintablePage f = new PrintablePage(MDITest.this.manager);
            MDITest.this.desktop.add(f);
            f.setVisible(true);
        }

        public void onDump() {
            MDITest.this.manager.dump(System.out);
        }
    }

    class FileMenu
    extends JMenu {
        FileMenu() {
            super("File");
            this.add("New Printable Page");
            this.add("New Non Printable Page");
            this.add("Close");
            this.addSeparator();
            this.add("Print");
            this.addSeparator();
            this.add("Dump");
            this.addSeparator();
            this.add("Exit");
        }

        public JMenuItem add(String name) {
            JMenuItem item = new JMenuItem(name);
            MDITest.this.manager.add(new CommandSourceAdapter(item));
            super.add(item);
            return item;
        }
    }
}

