#!/bin/sh
#
#  A simple shell wrapper around the NameSpaceProvider performance
#  testing tool.


getCanonicalPath() # $1 = path                              
{                                                           
local link                                              
link="$1"                                               
if readlink -f . > /dev/null 2>&1; then                 
RET="$(readlink -f $link)"                          
else                                                    
RET="$(cd $(dirname $link); pwd)/$(basename $link)" 
while [ -h "$RET" ]; do                             
link="$(ls -ld $RET | sed 's/.*-> //')"         
if [ -z "${link##/*}" ]; then                   
RET="${link}"                               
else                                            
link="$(dirname $RET)/${link}"              
RET="$(cd $(dirname $link); pwd)/$(basename $link)" 
fi                                              
done                                                
fi                                                      
}                                                           

[ -f /etc/default/dcache ] && . /etc/default/dcache         
[ -f /etc/dcache.env ] && . /etc/dcache.env                 

if [ -z "$DCACHE_HOME" ]; then                              
getCanonicalPath "$0"                                     
DCACHE_HOME="${RET%/*/*}"                                 
fi                                                          
if [ ! -d "$DCACHE_HOME" ]; then                            
echo "$DCACHE_HOME is not a directory"                    
exit 2                                                    
fi                                                          

DCACHE_CLASSPATH=${DCACHE_HOME}/share/classes/*             
DCACHE_DEFAULTS=${DCACHE_HOME}/share/defaults               
DCACHE_CACHED_CONFIG=${DCACHE_HOME}/var/config/cache        
. ${DCACHE_HOME}/share/lib/loadConfig.sh

CLASSPATH="$(getProperty dcache.paths.classpath)" java \
   -Dlog=${DCACHE_LOG:-warn} \
   diskCacheV111.namespace.PerformanceTest "$@"
