#!/bin/sh
#
#  A simple wrapper around the PNFS-to-Chimera migration test tool.
#
#  To use this tool:
#
#  1. Make a file containing a list of the PNFS IDs of all
#     files you wish to test, something like:
#
#        pnfsDump -o files /tmp/all-files-in-PNFS -f
#
#     NB. pnfsDump must be run on the same machine as the PNFS dbserver
#     daemons.
#
#  2. Adjust /opt/d-cache/config/chimera-config.xml so it points to the
#     Chimera database or inform the comparator to use a different file.
#     This should only be necessary if Chimera database is not running
#     on localhost.
#
#  3. Run this script giving it the filename containing the PNFS IDs;
#     for example:
#
#        ./migration-check.sh /tmp/all-files-in-PNFS
#
#  4. the migration-check.sh will accept an option "-k".  Specifying
#     this option will prevent migration-check from halting on the
#     first error.
#
#  5. Use the "-h" option for further help.



getCanonicalPath() # $1 = path                              
{                                                           
local link                                              
link="$1"                                               
if readlink -f . > /dev/null 2>&1; then                 
RET="$(readlink -f $link)"                          
else                                                    
RET="$(cd $(dirname $link); pwd)/$(basename $link)" 
while [ -h "$RET" ]; do                             
link="$(ls -ld $RET | sed 's/.*-> //')"         
if [ -z "${link##/*}" ]; then                   
RET="${link}"                               
else                                            
link="$(dirname $RET)/${link}"              
RET="$(cd $(dirname $link); pwd)/$(basename $link)" 
fi                                              
done                                                
fi                                                      
}                                                           

[ -f /etc/default/dcache ] && . /etc/default/dcache         
[ -f /etc/dcache.env ] && . /etc/dcache.env                 

if [ -z "$DCACHE_HOME" ]; then                              
getCanonicalPath "$0"                                     
DCACHE_HOME="${RET%/*/*}"                                 
fi                                                          
if [ ! -d "$DCACHE_HOME" ]; then                            
echo "$DCACHE_HOME is not a directory"                    
exit 2                                                    
fi                                                          

DCACHE_CLASSPATH=${DCACHE_HOME}/share/classes/*             
DCACHE_DEFAULTS=${DCACHE_HOME}/share/defaults               
DCACHE_CACHED_CONFIG=${DCACHE_HOME}/var/config/cache        
. ${DCACHE_HOME}/share/lib/loadConfig.sh

CLASSPATH="$(getProperty dcache.paths.classpath)" java \
    -Dlog=${DCACHE_LOG:-warn} \
    org.dcache.chimera.migration.Comparator "$@"
