/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.tree.IN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class INArrayRep<ARRAY_BASE_TYPE, REP_ENUM_TYPE, ELEMENT_TYPE> {
    protected final IN parent;

    public INArrayRep(IN parent) {
        this.parent = parent;
    }

    public abstract REP_ENUM_TYPE getType();

    public abstract ARRAY_BASE_TYPE set(int var1, ELEMENT_TYPE var2);

    public abstract ELEMENT_TYPE get(int var1);

    public abstract int length();

    public abstract ARRAY_BASE_TYPE copy(int var1, int var2, int var3);

    public abstract ARRAY_BASE_TYPE compact();

    abstract long calculateMemorySize();

    abstract void updateCacheStats(boolean var1, Evictor var2);

    final void updateCacheStats(boolean increment) {
        if (this.parent == null) {
            return;
        }
        if (!this.parent.getInListResident()) {
            return;
        }
        DatabaseImpl database = this.parent.getDatabase();
        this.updateCacheStats(increment, database.getDbEnvironment().getEvictor());
    }

    public final void noteRepChange(INArrayRep<ARRAY_BASE_TYPE, REP_ENUM_TYPE, ELEMENT_TYPE> newRep, int keyRepDelta) {
        if (this.parent == null) {
            return;
        }
        this.parent.changeMemorySize(newRep.calculateMemorySize() - this.calculateMemorySize() + (long)keyRepDelta);
        this.updateCacheStats(false);
        newRep.updateCacheStats(true);
    }

    public final void noteRepChange(INArrayRep<ARRAY_BASE_TYPE, REP_ENUM_TYPE, ELEMENT_TYPE> newRep) {
        this.noteRepChange(newRep, 0);
    }
}

