/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.cells;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellNameServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellNameService
extends AbstractCellComponent
implements ExceptionListener {
    private static final Logger _log = LoggerFactory.getLogger(CellNameService.class);
    public static final String DESTINATION_REGISTRATION = "cells.cns.registration";
    public static final String DESTINATION_LOOKUP = "cells.cns.lookup";
    public static final String DESTINATION_REFRESH = "cells.cns.refresh";
    private ConnectionFactory _connectionFactory;
    private Connection _connection;
    private Session _session;
    private MessageProducer _producer;
    private CellNameServiceRegistry _registry;

    public void setConnectionFactory(ConnectionFactory factory) {
        this._connectionFactory = factory;
    }

    public void setCellNameServiceRegistry(CellNameServiceRegistry registry) {
        this._registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        this._connection = this._connectionFactory.createConnection();
        try {
            this._connection.setExceptionListener((ExceptionListener)this);
            this._session = this._connection.createSession(false, 3);
            this._producer = this._session.createProducer(null);
            this._producer.setDeliveryMode(1);
            this._producer.setDisableMessageID(true);
            this._producer.setDisableMessageTimestamp(true);
            this._producer.setTimeToLive(40000L);
            MessageConsumer consumer = this._session.createConsumer((Destination)this._session.createTopic(DESTINATION_REGISTRATION));
            consumer.setMessageListener((MessageListener)this._registry);
            consumer = this._session.createConsumer((Destination)this._session.createQueue(DESTINATION_LOOKUP));
            consumer.setMessageListener((MessageListener)new LookupHandler());
            try {
                CellNameService.requestUpdate(this._session);
            }
            catch (JMSException e) {
                _log.debug("Failed to request CNS update: {}", (Object)e.getMessage());
            }
        }
        finally {
            this._connection.start();
        }
    }

    public void stop() throws JMSException {
        this._connection.close();
    }

    public void onException(JMSException exception) {
        _log.error("Fatal JMS connection failure: {}", (Object)exception.getMessage());
        new Thread("CNS-recover"){

            @Override
            public void run() {
                while (true) {
                    try {
                        CellNameService.this.stop();
                    }
                    catch (JMSException e) {
                        _log.error("Failed to shut down JMS connection: {}", (Object)e.getMessage());
                    }
                    try {
                        CellNameService.this.start();
                        return;
                    }
                    catch (JMSException e) {
                        _log.error("Failed to shut down JMS connection: {}", (Object)e.getMessage());
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void requestUpdate(Session session) throws JMSException {
        try (MessageProducer producer = session.createProducer((Destination)session.createTopic(DESTINATION_REFRESH));){
            producer.setDeliveryMode(1);
            producer.setDisableMessageID(true);
            producer.setDisableMessageTimestamp(true);
            producer.setTimeToLive(120000L);
            producer.send(session.createMessage());
        }
    }

    class LookupHandler
    implements MessageListener {
        LookupHandler() {
        }

        public void onMessage(Message message) {
            try {
                TextMessage textMessage = (TextMessage)message;
                String cellName = textMessage.getText();
                String domainName = CellNameService.this._registry.getDomain(cellName);
                if (domainName != null) {
                    TextMessage reply = CellNameService.this._session.createTextMessage(domainName);
                    reply.setJMSCorrelationID(cellName);
                    CellNameService.this._producer.send(textMessage.getJMSReplyTo(), (Message)reply);
                } else {
                    TextMessage reply = CellNameService.this._session.createTextMessage("");
                    reply.setJMSCorrelationID(cellName);
                    CellNameService.this._producer.send(textMessage.getJMSReplyTo(), (Message)reply);
                }
            }
            catch (ClassCastException e) {
                _log.warn("Dropping unknown message: {}", (Object)message);
            }
            catch (JMSException e) {
                _log.error("Failed to lookup well-known cells: {}", (Object)e.getMessage());
            }
        }
    }
}

