/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.namespace;

import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.RetentionPolicy;
import diskCacheV111.vehicles.OSMStorageInfo;
import diskCacheV111.vehicles.StorageInfo;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.StorageLocatable;
import org.dcache.chimera.namespace.ChimeraHsmStorageInfoExtractor;
import org.dcache.chimera.posix.Stat;
import org.dcache.chimera.store.InodeStorageInformation;

public class ChimeraOsmStorageInfoExtractor
extends ChimeraHsmStorageInfoExtractor {
    public ChimeraOsmStorageInfoExtractor(AccessLatency defaultAL, RetentionPolicy defaultRP) {
        super(defaultAL, defaultRP);
    }

    @Override
    public StorageInfo getFileStorageInfo(FsInode inode) throws CacheException {
        OSMStorageInfo info;
        try {
            boolean isNew;
            Stat stat = inode.statCache();
            FsInode level2 = new FsInode(inode.getFs(), inode.toString(), 2);
            boolean bl = isNew = stat.getSize() == 0L && !level2.exists();
            if (!isNew) {
                List locations = inode.getFs().getInodeLocations(inode, 0);
                if (locations.isEmpty()) {
                    info = (OSMStorageInfo)this.getDirStorageInfo(inode);
                } else {
                    InodeStorageInformation inodeStorageInfo = inode.getFs().getStorageInfo(inode);
                    info = new OSMStorageInfo(inodeStorageInfo.storageGroup(), inodeStorageInfo.storageSubGroup());
                    for (StorageLocatable location : locations) {
                        if (!location.isOnline()) continue;
                        try {
                            info.addLocation(new URI(location.location()));
                        }
                        catch (URISyntaxException e) {}
                    }
                }
            } else {
                info = (OSMStorageInfo)this.getDirStorageInfo(inode);
            }
            info.setIsNew(isNew);
        }
        catch (ChimeraFsException e) {
            throw new CacheException(e.getMessage());
        }
        return info;
    }

    @Override
    public StorageInfo getDirStorageInfo(FsInode inode) throws CacheException {
        FsInode dirInode = !inode.isDirectory() ? inode.getParent() : inode;
        try {
            String[] sGroup;
            HashMap<String, String> hash = new HashMap<String, String>();
            String store = null;
            String group = null;
            String[] OSMTemplate = ChimeraOsmStorageInfoExtractor.getTag(dirInode, "OSMTemplate");
            if (OSMTemplate != null) {
                for (String line : OSMTemplate) {
                    StringTokenizer st = new StringTokenizer(line);
                    if (st.countTokens() < 2) continue;
                    hash.put(st.nextToken(), st.nextToken());
                }
                store = (String)hash.get("StoreName");
                if (store == null) {
                    throw new CacheException(37, "StoreName not found in template");
                }
            }
            if ((sGroup = ChimeraOsmStorageInfoExtractor.getTag(dirInode, "sGroup")) != null) {
                group = sGroup[0].trim();
            }
            OSMStorageInfo info = new OSMStorageInfo(store, group);
            info.addKeys(hash);
            return info;
        }
        catch (IOException e) {
            throw new CacheException(e.getMessage());
        }
    }
}

