/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.namespace;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import diskCacheV111.namespace.NameSpaceProvider;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileExistsCacheException;
import diskCacheV111.util.FileMetaData;
import diskCacheV111.util.FileNotFoundCacheException;
import diskCacheV111.util.FsPath;
import diskCacheV111.util.NotDirCacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import diskCacheV111.util.PnfsId;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.dcache.acl.ACL;
import org.dcache.acl.enums.AccessType;
import org.dcache.acl.enums.RsType;
import org.dcache.auth.Subjects;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.DirectoryStreamB;
import org.dcache.chimera.FileExistsChimeraFsException;
import org.dcache.chimera.FileNotFoundHimeraFsException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.HimeraDirectoryEntry;
import org.dcache.chimera.JdbcFs;
import org.dcache.chimera.NotDirChimeraException;
import org.dcache.chimera.StorageLocatable;
import org.dcache.chimera.UnixPermission;
import org.dcache.chimera.namespace.ChimeraCacheInfo;
import org.dcache.chimera.namespace.ChimeraStorageInfoExtractable;
import org.dcache.chimera.posix.Stat;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.FileType;
import org.dcache.namespace.ListHandler;
import org.dcache.namespace.PermissionHandler;
import org.dcache.util.Checksum;
import org.dcache.util.ChecksumType;
import org.dcache.util.Glob;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class ChimeraNameSpaceProvider
implements NameSpaceProvider {
    private JdbcFs _fs;
    private ChimeraStorageInfoExtractable _extractor;
    private static final Logger _log = LoggerFactory.getLogger(ChimeraNameSpaceProvider.class);
    private boolean _inheritFileOwnership;
    private boolean _verifyAllLookups;
    private boolean _aclEnabled;
    private PermissionHandler _permissionHandler;
    private long _atimeGap;

    @Required
    public void setExtractor(ChimeraStorageInfoExtractable extractor) {
        this._extractor = extractor;
    }

    @Required
    public void setInheritFileOwnership(boolean inherit) {
        this._inheritFileOwnership = inherit;
    }

    @Required
    public void setVerifyAllLookups(boolean verify) {
        this._verifyAllLookups = verify;
    }

    @Required
    public void setPermissionHandler(PermissionHandler handler) {
        this._permissionHandler = handler;
    }

    @Required
    public void setFileSystem(JdbcFs fs) {
        this._fs = fs;
    }

    @Required
    public void setAclEnabled(boolean isEnabled) {
        this._aclEnabled = isEnabled;
    }

    @Required
    public void setAtimeGap(long gap) {
        this._atimeGap = TimeUnit.SECONDS.toMillis(gap);
    }

    private static Stat fileMetadata2Stat(FileMetaData metaData, boolean isDir) {
        Stat stat = new Stat();
        int mode = 0;
        if (metaData.getUserPermissions().canRead()) {
            mode |= 0x100;
        }
        if (metaData.getUserPermissions().canWrite()) {
            mode |= 0x80;
        }
        if (metaData.getUserPermissions().canExecute()) {
            mode |= 0x40;
        }
        if (metaData.getGroupPermissions().canRead()) {
            mode |= 0x20;
        }
        if (metaData.getGroupPermissions().canWrite()) {
            mode |= 0x10;
        }
        if (metaData.getGroupPermissions().canExecute()) {
            mode |= 8;
        }
        if (metaData.getWorldPermissions().canRead()) {
            mode |= 4;
        }
        if (metaData.getWorldPermissions().canWrite()) {
            mode |= 2;
        }
        if (metaData.getWorldPermissions().canExecute()) {
            mode |= 1;
        }
        mode = isDir ? (mode |= 0x4000) : (mode |= 0x8000);
        ChimeraNameSpaceProvider.setModeOf(stat, mode);
        stat.setUid(metaData.getUid());
        stat.setGid(metaData.getGid());
        stat.setSize(metaData.getFileSize());
        return stat;
    }

    private FsInode pathToInode(Subject subject, String path) throws IOException, ChimeraFsException, CacheException {
        if (Subjects.isRoot((Subject)subject)) {
            return this._fs.path2inode(path);
        }
        List inodes = this._fs.path2inodes(path);
        if (this._verifyAllLookups) {
            for (FsInode inode : inodes.subList(0, inodes.size() - 1)) {
                FileAttributes attributes;
                if (!inode.isDirectory() || this._permissionHandler.canLookup(subject, attributes = this.getFileAttributesForPermissionHandler(inode)) == AccessType.ACCESS_ALLOWED) continue;
                throw new PermissionDeniedCacheException("Access denied: " + path);
            }
        } else {
            for (FsInode inode : Iterables.skip((Iterable)Lists.reverse((List)inodes), (int)1)) {
                if (!inode.isDirectory()) continue;
                FileAttributes attributes = this.getFileAttributesForPermissionHandler(inode);
                if (this._permissionHandler.canLookup(subject, attributes) != AccessType.ACCESS_ALLOWED) {
                    throw new PermissionDeniedCacheException("Access denied: " + path);
                }
                break;
            }
        }
        return (FsInode)inodes.get(inodes.size() - 1);
    }

    public PnfsId createEntry(Subject subject, String path, int uid, int gid, int mode, boolean isDir) throws CacheException {
        FsInode inode;
        try {
            File newEntryFile = new File(path);
            String parentPath = newEntryFile.getParent();
            if (parentPath == null) {
                throw new FileExistsCacheException("File exists: " + path);
            }
            FsInode parent = this.pathToInode(subject, parentPath);
            if (!Subjects.isRoot((Subject)subject)) {
                FileAttributes attributes = this.getFileAttributesForPermissionHandler(parent);
                if (isDir ? this._permissionHandler.canCreateSubDir(subject, attributes) != AccessType.ACCESS_ALLOWED : this._permissionHandler.canCreateFile(subject, attributes) != AccessType.ACCESS_ALLOWED) {
                    throw new PermissionDeniedCacheException("Access denied: " + path);
                }
            }
            if (uid == -1) {
                uid = Subjects.isNobody((Subject)subject) || this._inheritFileOwnership ? parent.statCache().getUid() : (int)Subjects.getUid((Subject)subject);
            }
            if (gid == -1) {
                gid = Subjects.isNobody((Subject)subject) || this._inheritFileOwnership ? parent.statCache().getGid() : (int)Subjects.getPrimaryGid((Subject)subject);
            }
            if (mode == -1) {
                mode = parent.statCache().getMode();
                mode = isDir ? (mode &= 0x1FF) : (mode &= 0x1B6);
            }
            inode = isDir ? this._fs.mkdir(parent, newEntryFile.getName(), uid, gid, mode) : this._fs.createFile(parent, newEntryFile.getName(), uid, gid, mode);
        }
        catch (NotDirChimeraException e) {
            throw new NotDirCacheException("Not a directory: " + path);
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new FileNotFoundCacheException("No such file or directory: " + path);
        }
        catch (FileExistsChimeraFsException e) {
            throw new FileExistsCacheException("File exists: " + path);
        }
        catch (IOException e) {
            throw new CacheException(10011, e.getMessage());
        }
        return new PnfsId(inode.toString());
    }

    public void deleteEntry(Subject subject, PnfsId pnfsId) throws CacheException {
        boolean removed;
        try {
            FsInode inode = new FsInode((FileSystemProvider)this._fs, pnfsId.toIdString());
            if (!Subjects.isRoot((Subject)subject)) {
                FsInode inodeParent = this._fs.getParentOf(inode);
                FileAttributes parentAttributes = this.getFileAttributesForPermissionHandler(inodeParent);
                FileAttributes fileAttributes = this.getFileAttributesForPermissionHandler(inode);
                if (inode.isDirectory() ? this._permissionHandler.canDeleteDir(subject, parentAttributes, fileAttributes) != AccessType.ACCESS_ALLOWED : this._permissionHandler.canDeleteFile(subject, parentAttributes, fileAttributes) != AccessType.ACCESS_ALLOWED) {
                    throw new PermissionDeniedCacheException("Access denied: " + pnfsId);
                }
            }
            removed = this._fs.remove(inode);
        }
        catch (FileNotFoundHimeraFsException fnf) {
            throw new FileNotFoundCacheException("No such file or directory: " + pnfsId);
        }
        catch (IOException e) {
            throw new CacheException(10011, e.getMessage());
        }
        if (!removed) {
            throw new CacheException(10011, "Entry could not be removed: " + pnfsId);
        }
    }

    public void deleteEntry(Subject subject, String path) throws CacheException {
        boolean removed;
        try {
            File file;
            String parentPath;
            if (!Subjects.isRoot((Subject)subject) && (parentPath = (file = new File(path)).getParent()) != null) {
                FsInode inode = this.pathToInode(subject, path);
                FsInode inodeParent = this._fs.path2inode(parentPath);
                FileAttributes parentAttributes = this.getFileAttributesForPermissionHandler(inodeParent);
                FileAttributes fileAttributes = this.getFileAttributesForPermissionHandler(inode);
                if (inode.isDirectory() ? this._permissionHandler.canDeleteDir(subject, parentAttributes, fileAttributes) != AccessType.ACCESS_ALLOWED : this._permissionHandler.canDeleteFile(subject, parentAttributes, fileAttributes) != AccessType.ACCESS_ALLOWED) {
                    throw new PermissionDeniedCacheException("Access denied: " + path);
                }
            }
            removed = this._fs.remove(path);
        }
        catch (FileNotFoundHimeraFsException fnf) {
            throw new FileNotFoundCacheException("No such file or directory: " + path);
        }
        catch (IOException e) {
            throw new CacheException(10011, e.getMessage());
        }
        if (!removed) {
            throw new CacheException(10011, "Entry could not be removed: " + path);
        }
    }

    public void renameEntry(Subject subject, PnfsId pnfsId, String newName, boolean overwrite) throws CacheException {
        try {
            FileAttributes destDirAttributes;
            FsInode destDir;
            FsInode inode = new FsInode((FileSystemProvider)this._fs, pnfsId.toIdString());
            FsPath source = new FsPath(this._fs.inode2path(inode));
            if (source.isEmpty()) {
                throw new PermissionDeniedCacheException("Access denied: " + source);
            }
            FsInode sourceDir = this._fs.getParentOf(inode);
            FileAttributes sourceDirAttributes = this.getFileAttributesForPermissionHandler(sourceDir);
            FsPath dest = new FsPath(newName);
            if (dest.isEmpty()) {
                throw new PermissionDeniedCacheException("Access denied: " + dest);
            }
            try {
                if (dest.getParent().equals((Object)source.getParent())) {
                    destDir = sourceDir;
                    destDirAttributes = sourceDirAttributes;
                } else {
                    destDir = this.pathToInode(subject, dest.getParent().toString());
                    destDirAttributes = this.getFileAttributesForPermissionHandler(destDir);
                }
            }
            catch (FileNotFoundHimeraFsException e) {
                throw new NotDirCacheException("No such directory: " + dest.getParent());
            }
            if (!Subjects.isRoot((Subject)subject) && this._permissionHandler.canRename(subject, sourceDirAttributes, destDirAttributes, inode.isDirectory()) != AccessType.ACCESS_ALLOWED) {
                throw new PermissionDeniedCacheException("Access denied: " + pnfsId);
            }
            if (Subjects.isRoot((Subject)subject) && overwrite) {
                this._fs.move(sourceDir, source.getName(), destDir, dest.getName());
                return;
            }
            try {
                FsInode destInode = this._fs.path2inode(newName);
                if (!overwrite) {
                    throw new FileExistsCacheException("File exists:" + newName);
                }
                FileAttributes destAttributes = this.getFileAttributesForPermissionHandler(destInode);
                if (destInode.isDirectory() ? this._permissionHandler.canDeleteDir(subject, destDirAttributes, destAttributes) != AccessType.ACCESS_ALLOWED : this._permissionHandler.canDeleteFile(subject, destDirAttributes, destAttributes) != AccessType.ACCESS_ALLOWED) {
                    throw new PermissionDeniedCacheException("Access denied: " + newName);
                }
            }
            catch (FileNotFoundHimeraFsException e) {
                // empty catch block
            }
            this._fs.move(sourceDir, source.getName(), destDir, dest.getName());
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new FileNotFoundCacheException("No such file or directory: " + pnfsId);
        }
        catch (FileExistsChimeraFsException e) {
            throw new FileExistsCacheException("File exists:" + newName);
        }
        catch (IOException e) {
            throw new CacheException(10011, e.getMessage());
        }
    }

    public void addCacheLocation(Subject subject, PnfsId pnfsId, String cacheLocation) throws CacheException {
        _log.debug("add cache location {} for {}", (Object)cacheLocation, (Object)pnfsId);
        try {
            FsInode inode = new FsInode((FileSystemProvider)this._fs, pnfsId.toIdString());
            this._fs.addInodeLocation(inode, 1, cacheLocation);
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new FileNotFoundCacheException("No such file: " + pnfsId);
        }
        catch (ChimeraFsException e) {
            _log.error("Exception in addCacheLocation {}", (Throwable)e);
            throw new CacheException(10011, e.getMessage());
        }
    }

    public List<String> getCacheLocation(Subject subject, PnfsId pnfsId) throws CacheException {
        try {
            ArrayList<String> locations = new ArrayList<String>();
            FsInode inode = new FsInode((FileSystemProvider)this._fs, pnfsId.toIdString());
            List localyManagerLocations = this._fs.getInodeLocations(inode, 1);
            for (StorageLocatable location : localyManagerLocations) {
                locations.add(location.location());
            }
            return locations;
        }
        catch (ChimeraFsException e) {
            throw new CacheException(10011, e.getMessage());
        }
    }

    public void clearCacheLocation(Subject subject, PnfsId pnfsId, String cacheLocation, boolean removeIfLast) throws CacheException {
        _log.debug("clearCacheLocation : {} for {}", (Object)cacheLocation, (Object)pnfsId);
        try {
            List locations;
            FsInode inode = new FsInode((FileSystemProvider)this._fs, pnfsId.toIdString());
            this._fs.clearInodeLocation(inode, 1, cacheLocation);
            if (removeIfLast && (locations = this._fs.getInodeLocations(inode, 1)).isEmpty()) {
                _log.debug("last location cleaned. removing file {}", (Object)inode);
                this._fs.remove(inode);
            }
        }
        catch (ChimeraFsException e) {
            _log.error("Exception in clearCacheLocation for {} : {}", (Object)pnfsId, (Object)e);
            throw new CacheException(10011, e.getMessage());
        }
    }

    public String pnfsidToPath(Subject subject, PnfsId pnfsId) throws CacheException {
        try {
            FsInode inode = new FsInode((FileSystemProvider)this._fs, pnfsId.toIdString());
            if (!inode.exists()) {
                throw new FileNotFoundCacheException("No such file or directory: " + pnfsId);
            }
            return this._fs.inode2path(inode);
        }
        catch (ChimeraFsException e) {
            throw new CacheException(10011, e.getMessage());
        }
    }

    public PnfsId pathToPnfsid(Subject subject, String path, boolean followLink) throws CacheException {
        FsInode inode;
        try {
            inode = this.pathToInode(subject, path);
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new FileNotFoundCacheException("No such file or directory " + path);
        }
        catch (IOException e) {
            throw new CacheException(10011, e.getMessage());
        }
        return new PnfsId(inode.toString());
    }

    public void removeFileAttribute(Subject subject, PnfsId pnfsId, String attribute) throws CacheException {
        try {
            FsInode inode = new FsInode((FileSystemProvider)this._fs, pnfsId.toString(), 2);
            ChimeraCacheInfo info = new ChimeraCacheInfo(inode);
            ChimeraCacheInfo.CacheFlags flags = info.getFlags();
            flags.remove(attribute);
            info.writeCacheInfo(inode);
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new FileNotFoundCacheException("No such file or directory " + pnfsId);
        }
        catch (IOException e) {
            throw new CacheException(10011, e.getMessage());
        }
    }

    public void removeChecksum(Subject subject, PnfsId pnfsId, ChecksumType type) throws CacheException {
        try {
            this._fs.removeInodeChecksum(new FsInode((FileSystemProvider)this._fs, pnfsId.toString()), type.getType());
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new FileNotFoundCacheException("No such file or directory: " + pnfsId);
        }
        catch (ChimeraFsException e) {
            throw new CacheException(10011, e.getMessage());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("$Id: ChimeraNameSpaceProvider.java,v 1.7 2007-10-01 12:28:03 tigran Exp $ \n");
        sb.append("Acl Enabled: ").append(this._aclEnabled).append("\n");
        sb.append("atime precision: ").append(this._atimeGap < 0L ? "Disabled" : Long.valueOf(TimeUnit.MILLISECONDS.toSeconds(this._atimeGap))).append("\n");
        sb.append(this._fs.getInfo());
        return sb.toString();
    }

    public PnfsId getParentOf(Subject subject, PnfsId pnfsId) throws CacheException {
        FsInode inodeParent;
        FsInode inodeOfResource = new FsInode((FileSystemProvider)this._fs, pnfsId.toIdString());
        try {
            inodeParent = this._fs.getParentOf(inodeOfResource);
        }
        catch (ChimeraFsException e) {
            _log.error("getParentOf failed : {}", (Throwable)e);
            throw new CacheException(10011, e.getMessage());
        }
        if (inodeParent == null) {
            throw new FileNotFoundCacheException("No such file or directory: " + pnfsId);
        }
        return new PnfsId(inodeParent.toString());
    }

    private FileAttributes getFileAttributesForPermissionHandler(FsInode inode) throws IOException, ChimeraFsException, CacheException {
        return inode == null ? null : this.getFileAttributes(Subjects.ROOT, inode, (Set<FileAttribute>)this._permissionHandler.getRequiredAttributes());
    }

    private FileAttributes getFileAttributes(Subject subject, FsInode inode, Set<FileAttribute> attr) throws IOException, ChimeraFsException, CacheException {
        if (!inode.exists()) {
            throw new FileNotFoundHimeraFsException();
        }
        FileAttributes attributes = new FileAttributes();
        block18: for (FileAttribute attribute : attr) {
            switch (attribute) {
                case ACL: {
                    if (this._aclEnabled) {
                        RsType rsType = inode.isDirectory() ? RsType.DIR : RsType.FILE;
                        List acl = this._fs.getACL(inode);
                        attributes.setAcl(new ACL(rsType, acl));
                        continue block18;
                    }
                    attributes.setAcl(null);
                    continue block18;
                }
                case ACCESS_LATENCY: {
                    attributes.setAccessLatency(this._extractor.getAccessLatency(inode));
                    continue block18;
                }
                case ACCESS_TIME: {
                    Stat stat = inode.statCache();
                    attributes.setAccessTime(stat.getATime());
                    continue block18;
                }
                case RETENTION_POLICY: {
                    attributes.setRetentionPolicy(this._extractor.getRetentionPolicy(inode));
                    continue block18;
                }
                case SIZE: {
                    Stat stat = inode.statCache();
                    attributes.setSize(stat.getSize());
                    continue block18;
                }
                case CREATION_TIME: {
                    Stat stat = inode.statCache();
                    attributes.setCreationTime(stat.getCTime());
                    continue block18;
                }
                case MODIFICATION_TIME: {
                    Stat stat = inode.statCache();
                    attributes.setModificationTime(stat.getMTime());
                    continue block18;
                }
                case OWNER: {
                    Stat stat = inode.statCache();
                    attributes.setOwner(stat.getUid());
                    continue block18;
                }
                case OWNER_GROUP: {
                    Stat stat = inode.statCache();
                    attributes.setGroup(stat.getGid());
                    continue block18;
                }
                case CHECKSUM: {
                    HashSet<Checksum> checksums = new HashSet<Checksum>();
                    for (ChecksumType type : ChecksumType.values()) {
                        String value = this._fs.getInodeChecksum(inode, type.getType());
                        if (value == null) continue;
                        checksums.add(new Checksum(type, value));
                    }
                    attributes.setChecksums(checksums);
                    continue block18;
                }
                case LOCATIONS: {
                    ArrayList<String> locations = new ArrayList<String>();
                    List localyManagerLocations = this._fs.getInodeLocations(inode, 1);
                    for (StorageLocatable location : localyManagerLocations) {
                        locations.add(location.location());
                    }
                    attributes.setLocations(locations);
                    continue block18;
                }
                case FLAGS: {
                    FsInode level2 = new FsInode((FileSystemProvider)this._fs, inode.toString(), 2);
                    ChimeraCacheInfo info = new ChimeraCacheInfo(level2);
                    HashMap<String, String> flags = new HashMap<String, String>();
                    for (Map.Entry<String, String> e : info.getFlags().entrySet()) {
                        flags.put(e.getKey(), e.getValue());
                    }
                    attributes.setFlags(flags);
                    continue block18;
                }
                case SIMPLE_TYPE: 
                case TYPE: {
                    Stat stat = inode.statCache();
                    UnixPermission perm = new UnixPermission(stat.getMode());
                    if (perm.isReg()) {
                        attributes.setFileType(FileType.REGULAR);
                        continue block18;
                    }
                    if (perm.isDir()) {
                        attributes.setFileType(FileType.DIR);
                        continue block18;
                    }
                    if (perm.isSymLink()) {
                        attributes.setFileType(FileType.LINK);
                        continue block18;
                    }
                    attributes.setFileType(FileType.SPECIAL);
                    continue block18;
                }
                case MODE: {
                    Stat stat = inode.statCache();
                    attributes.setMode(stat.getMode());
                    continue block18;
                }
                case PNFSID: {
                    attributes.setPnfsId(new PnfsId(inode.toString()));
                    continue block18;
                }
                case STORAGEINFO: {
                    attributes.setStorageInfo(this._extractor.getStorageInfo(inode));
                    continue block18;
                }
            }
            throw new UnsupportedOperationException("Attribute " + attribute + " not supported yet.");
        }
        return attributes;
    }

    public FileAttributes getFileAttributes(Subject subject, PnfsId pnfsId, Set<FileAttribute> attr) throws CacheException {
        try {
            FsInode inode = new FsInode((FileSystemProvider)this._fs, pnfsId.toIdString());
            if (Subjects.isRoot((Subject)subject)) {
                return this.getFileAttributes(subject, inode, attr);
            }
            EnumSet<FileAttribute> required = EnumSet.noneOf(FileAttribute.class);
            required.addAll(this._permissionHandler.getRequiredAttributes());
            required.addAll(attr);
            FileAttributes fileAttributes = this.getFileAttributes(subject, inode, required);
            FsInode inodeParent = this._fs.getParentOf(inode);
            FileAttributes parent = this.getFileAttributesForPermissionHandler(inodeParent);
            if (this._permissionHandler.canGetAttributes(subject, parent, fileAttributes, attr) != AccessType.ACCESS_ALLOWED) {
                throw new PermissionDeniedCacheException("Access denied: " + pnfsId);
            }
            return fileAttributes;
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new FileNotFoundCacheException("No such file or directory: " + pnfsId);
        }
        catch (IOException e) {
            throw new CacheException(10011, e.getMessage());
        }
    }

    public void setFileAttributes(Subject subject, PnfsId pnfsId, FileAttributes attr) throws CacheException {
        _log.debug("File attributes update: {}", (Object)attr.getDefinedAttributes());
        FsInode inode = new FsInode((FileSystemProvider)this._fs, pnfsId.toIdString());
        try {
            FileAttributes attributes;
            FsInode inodeParent;
            FileAttributes parentAttributes;
            if (!Subjects.isRoot((Subject)subject) && this._permissionHandler.canSetAttributes(subject, parentAttributes = this.getFileAttributesForPermissionHandler(inodeParent = this._fs.getParentOf(inode)), attributes = this.getFileAttributesForPermissionHandler(inode), attr.getDefinedAttributes()) != AccessType.ACCESS_ALLOWED) {
                throw new PermissionDeniedCacheException("Access denied: " + pnfsId);
            }
            Object dir = null;
            Stat stat = null;
            block17: for (FileAttribute attribute : attr.getDefinedAttributes()) {
                switch (attribute) {
                    case LOCATIONS: {
                        for (String location : attr.getLocations()) {
                            this._fs.addInodeLocation(inode, 1, location);
                        }
                        continue block17;
                    }
                    case SIZE: {
                        if (stat == null) {
                            stat = inode.statCache();
                        }
                        stat.setSize(attr.getSize());
                        break;
                    }
                    case MODE: {
                        if (stat == null) {
                            stat = inode.statCache();
                        }
                        ChimeraNameSpaceProvider.setModeOf(stat, attr.getMode());
                        break;
                    }
                    case ACCESS_TIME: {
                        Stat atimeStat;
                        if (this._atimeGap < 0L || Math.abs((atimeStat = stat == null ? inode.statCache() : stat).getATime() - attr.getAccessTime()) <= this._atimeGap) continue block17;
                        atimeStat.setATime(attr.getAccessTime());
                        stat = atimeStat;
                        break;
                    }
                    case OWNER: {
                        if (stat == null) {
                            stat = inode.statCache();
                        }
                        stat.setUid(attr.getOwner());
                        break;
                    }
                    case OWNER_GROUP: {
                        if (stat == null) {
                            stat = inode.statCache();
                        }
                        stat.setGid(attr.getGroup());
                        break;
                    }
                    case CHECKSUM: {
                        for (Checksum sum : attr.getChecksums()) {
                            int type = sum.getType().getType();
                            String value = sum.getValue();
                            String existingValue = this._fs.getInodeChecksum(inode, type);
                            if (existingValue == null) {
                                this._fs.setInodeChecksum(inode, type, value);
                                continue;
                            }
                            if (existingValue.equals(value)) continue;
                            throw new CacheException(10015, "Checksum mismatch");
                        }
                        continue block17;
                    }
                    case ACCESS_LATENCY: {
                        this._fs.setAccessLatency(inode, attr.getAccessLatency());
                        break;
                    }
                    case RETENTION_POLICY: {
                        this._fs.setRetentionPolicy(inode, attr.getRetentionPolicy());
                        break;
                    }
                    case FLAGS: {
                        FsInode level2 = new FsInode((FileSystemProvider)this._fs, pnfsId.toString(), 2);
                        ChimeraCacheInfo cacheInfo = new ChimeraCacheInfo(level2);
                        for (Map.Entry flag : attr.getFlags().entrySet()) {
                            cacheInfo.getFlags().put((String)flag.getKey(), (String)flag.getValue());
                        }
                        cacheInfo.writeCacheInfo(level2);
                        break;
                    }
                    case ACL: {
                        if (!this._aclEnabled) continue block17;
                        ACL acl = attr.getAcl();
                        this._fs.setACL(inode, acl.getList());
                        break;
                    }
                    case STORAGEINFO: {
                        this._extractor.setStorageInfo(inode, attr.getStorageInfo());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Attribute " + attribute + " not supported yet.");
                    }
                }
            }
            if (stat != null) {
                inode.setStat(stat);
            }
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new FileNotFoundCacheException("No such file or directory: " + pnfsId);
        }
        catch (IOException e) {
            _log.error("Exception in setFileAttributes: {}", (Throwable)e);
            throw new CacheException(10011, e.getMessage());
        }
    }

    private static void setModeOf(Stat stat, int mode) {
        int newMode = mode & 0x1FF | stat.getMode() & 0xFFFFFE00;
        stat.setMode(newMode);
    }

    public void list(Subject subject, String path, Glob glob, Range<Integer> range, Set<FileAttribute> attrs, ListHandler handler) throws CacheException {
        try {
            Pattern pattern = glob == null ? null : glob.toPattern();
            FsInode dir = this.pathToInode(subject, path);
            if (!dir.isDirectory()) {
                throw new NotDirCacheException("Not a directory: " + path);
            }
            if (!Subjects.isRoot((Subject)subject)) {
                FileAttributes attributes = this.getFileAttributesForPermissionHandler(dir);
                if (!dir.isDirectory()) {
                    throw new NotDirCacheException("Not a directory");
                }
                if (this._permissionHandler.canListDir(subject, attributes) != AccessType.ACCESS_ALLOWED) {
                    throw new PermissionDeniedCacheException("Access denied: " + path);
                }
            }
            int counter = 0;
            try (DirectoryStreamB dirStream = dir.newDirectoryStream();){
                for (HimeraDirectoryEntry entry : dirStream) {
                    try {
                        String name = entry.getName();
                        if (name.equals(".") || name.equals("..") || pattern != null && !pattern.matcher(name).matches() || !range.contains((Comparable)Integer.valueOf(counter++))) continue;
                        FileAttributes fa = attrs.isEmpty() ? null : this.getFileAttributes(subject, entry.getInode(), attrs);
                        handler.addEntry(name, fa);
                    }
                    catch (FileNotFoundHimeraFsException e) {}
                }
            }
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new FileNotFoundCacheException("No such file or directory: " + path);
        }
        catch (IOException e) {
            _log.error("Exception in list: {}", (Throwable)e);
            throw new CacheException(10011, e.getMessage());
        }
    }
}

