/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.namespace;

import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.RetentionPolicy;
import diskCacheV111.vehicles.EnstoreStorageInfo;
import diskCacheV111.vehicles.StorageInfo;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.StorageLocatable;
import org.dcache.chimera.namespace.ChimeraHsmStorageInfoExtractor;
import org.dcache.chimera.posix.Stat;
import org.dcache.chimera.store.InodeStorageInformation;
import org.springframework.web.util.UriComponentsBuilder;

public class ChimeraEnstoreStorageInfoExtractor
extends ChimeraHsmStorageInfoExtractor {
    public ChimeraEnstoreStorageInfoExtractor(AccessLatency defaultAL, RetentionPolicy defaultRP) {
        super(defaultAL, defaultRP);
    }

    @Override
    public StorageInfo getFileStorageInfo(FsInode inode) throws CacheException {
        EnstoreStorageInfo info;
        FsInode level2 = new FsInode(inode.getFs(), inode.toString(), 2);
        try {
            List locations = inode.getFs().getInodeLocations(inode, 0);
            EnstoreStorageInfo parentStorageInfo = (EnstoreStorageInfo)this.getDirStorageInfo(inode);
            if (locations.isEmpty()) {
                info = parentStorageInfo;
            } else {
                InodeStorageInformation inodeStorageInfo = inode.getFs().getStorageInfo(inode);
                info = new EnstoreStorageInfo(parentStorageInfo.getStorageGroup(), parentStorageInfo.getFileFamily());
                info.setIsNew(false);
                for (StorageLocatable location : locations) {
                    if (!location.isOnline()) continue;
                    String locationStr = location.location();
                    UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)locationStr);
                    try {
                        URI uri = builder.build(ChimeraEnstoreStorageInfoExtractor.isEncoded(locationStr)).toUri();
                        info.addLocation(uri);
                        block17: for (String part : uri.getQuery().split("&")) {
                            String[] data = part.split("=");
                            String key = data[0];
                            String value = data.length == 2 ? data[1] : "";
                            switch (key) {
                                case "bfid": {
                                    info.setBitfileId(value);
                                    continue block17;
                                }
                                case "volume": {
                                    info.setVolume(value);
                                    continue block17;
                                }
                                case "location_cookie": {
                                    info.setLocation(value);
                                    continue block17;
                                }
                                case "original_name": {
                                    info.setPath(value);
                                }
                            }
                        }
                    }
                    catch (UnsupportedEncodingException ignore) {
                    }
                }
            }
            Stat stat = inode.stat();
            info.setIsNew(stat.getSize() == 0L && !level2.exists());
        }
        catch (ChimeraFsException e) {
            throw new CacheException(e.getMessage());
        }
        return info;
    }

    @Override
    public StorageInfo getDirStorageInfo(FsInode inode) throws CacheException {
        FsInode dirInode = !inode.isDirectory() ? inode.getParent() : inode;
        try {
            String ff;
            String sg;
            HashMap<String, String> hash = new HashMap<String, String>();
            String[] OSMTemplate = ChimeraEnstoreStorageInfoExtractor.getTag(dirInode, "OSMTemplate");
            String[] group = ChimeraEnstoreStorageInfoExtractor.getTag(dirInode, "storage_group");
            String[] family = ChimeraEnstoreStorageInfoExtractor.getTag(dirInode, "file_family");
            if (OSMTemplate != null) {
                for (String line : OSMTemplate) {
                    StringTokenizer st = new StringTokenizer(line);
                    if (st.countTokens() < 2) continue;
                    hash.put(st.nextToken(), st.nextToken());
                }
            }
            sg = group == null || group.length == 0 || (sg = group[0].trim()).equals("") ? "none" : sg;
            ff = family == null || family.length == 0 || (ff = family[0].trim()).equals("") ? "none" : ff;
            EnstoreStorageInfo info = new EnstoreStorageInfo(sg, ff);
            info.addKeys(hash);
            return info;
        }
        catch (IOException e) {
            throw new CacheException(e.getMessage());
        }
    }

    private static boolean isEncoded(String s) throws UnsupportedEncodingException {
        return !s.equals(URLDecoder.decode(s, "UTF-8"));
    }
}

