/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileLocality;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.vehicles.Message;
import diskCacheV111.vehicles.PoolManagerGetPoolMonitor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.dcache.acl.enums.AccessMask;
import org.dcache.cells.CellStub;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsInode_PGET;
import org.dcache.chimera.JdbcFs;
import org.dcache.namespace.FileAttribute;
import org.dcache.poolmanager.PoolMonitor;
import org.dcache.vehicles.FileAttributes;

public class DCacheAwareJdbcFs
extends JdbcFs {
    private static final String LOCALITY = "locality";
    private static String host;
    private CellStub poolManagerStub;
    private PnfsHandler pnfsHandler;
    private final LoadingCache<LocalityArgs, FsInode_PGET> CACHE = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).maximumSize(64L).softValues().build((CacheLoader)new LocalityLoader());

    public DCacheAwareJdbcFs(DataSource dataSource, String dialect) {
        super(dataSource, dialect);
    }

    public DCacheAwareJdbcFs(DataSource dataSource, String dialect, int id) {
        super(dataSource, dialect, id);
    }

    public void setPnfsHandler(PnfsHandler pnfsHandler) {
        this.pnfsHandler = pnfsHandler;
    }

    public void setPoolManagerStub(CellStub poolManagerStub) {
        this.poolManagerStub = poolManagerStub;
    }

    protected FsInode_PGET getPGET(FsInode parent, String[] cmd) throws ChimeraFsException {
        try {
            return (FsInode_PGET)this.CACHE.get((Object)new LocalityArgs(parent, cmd));
        }
        catch (ExecutionException t) {
            Throwable cause = t.getCause();
            if (cause instanceof ChimeraFsException) {
                throw (ChimeraFsException)cause;
            }
            throw new ChimeraFsException(t.toString());
        }
    }

    protected FsInode_PGET getPGET(String id, String[] cmd) throws ChimeraFsException {
        try {
            return (FsInode_PGET)this.CACHE.get((Object)new LocalityArgs(this, id, cmd));
        }
        catch (ExecutionException t) {
            Throwable cause = t.getCause();
            if (cause instanceof ChimeraFsException) {
                throw (ChimeraFsException)cause;
            }
            throw new ChimeraFsException(t.toString());
        }
    }

    private String getFileLocality(String filePath) throws IOException {
        FileLocality locality = FileLocality.UNAVAILABLE;
        try {
            PoolMonitor _poolMonitor = ((PoolManagerGetPoolMonitor)this.poolManagerStub.sendAndWait((Message)new PoolManagerGetPoolMonitor())).getPoolMonitor();
            EnumSet<FileAttribute> requestedAttributes = EnumSet.of(FileAttribute.TYPE, FileAttribute.SIZE, FileAttribute.STORAGEINFO, FileAttribute.LOCATIONS);
            EnumSet<AccessMask> accessMask = EnumSet.of(AccessMask.READ_DATA);
            FileAttributes attributes = this.pnfsHandler.getFileAttributes(filePath, requestedAttributes, accessMask);
            locality = _poolMonitor.getFileLocality(attributes, host);
        }
        catch (CacheException | InterruptedException t) {
            throw new IOException(t);
        }
        return locality.toString();
    }

    private FsInode_PGET getSuperPGET(FsInode parent, String[] cmd) throws ChimeraFsException {
        return super.getPGET(parent, cmd);
    }

    static {
        try {
            host = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            host = "<unknown host>";
        }
    }

    private final class LocalityLoader
    extends CacheLoader<LocalityArgs, FsInode_PGET> {
        private LocalityLoader() {
        }

        public FsInode_PGET load(LocalityArgs key) throws Exception {
            FsInode_PGET pget = DCacheAwareJdbcFs.this.getSuperPGET(key.parent, key.args);
            if (pget.hasMetadataFor(DCacheAwareJdbcFs.LOCALITY)) {
                FsInode pathInode = DCacheAwareJdbcFs.this.inodeOf(key.parent, pget.getName());
                String path = DCacheAwareJdbcFs.this.inode2path(pathInode);
                String locality = DCacheAwareJdbcFs.this.getFileLocality(path);
                pget.setMetadata(DCacheAwareJdbcFs.LOCALITY, locality);
                pget.stat();
            }
            return pget;
        }
    }

    private final class LocalityArgs {
        private final FsInode parent;
        private final String id;
        private final String[] args;

        private LocalityArgs(FsInode parent, String[] args) {
            this.parent = parent;
            this.id = parent.toString();
            this.args = (String[])args.clone();
        }

        private LocalityArgs(JdbcFs fs, String id, String[] args) {
            this.parent = new FsInode((FileSystemProvider)fs, id);
            this.id = id;
            this.args = (String[])args.clone();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LocalityArgs)) {
                return false;
            }
            LocalityArgs largs = (LocalityArgs)o;
            if (!this.id.equals(largs.id)) {
                return false;
            }
            return Arrays.equals(this.args, largs.args);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return this.id + Arrays.asList(this.args);
        }
    }
}

