/*
 * Decompiled with CFR 0.152.
 */
package javatunnel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javatunnel.Convertable;
import javatunnel.TunnelInputStream;
import javatunnel.TunnelOutputStream;
import javatunnel.UserBindible;
import javax.security.auth.Subject;

public class TunnelSocket
extends Socket
implements UserBindible {
    private TunnelOutputStream _out;
    private TunnelInputStream _in;
    private Convertable _tunnel;
    private Subject _subject = new Subject();
    private final List<String> _roles = new ArrayList<String>();

    TunnelSocket(Convertable tunnel) {
        this._tunnel = tunnel;
        if (this.isConnected()) {
            try {
                this._tunnel.auth(this.getRawInputStream(), this.getRawOutputStream(), this);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    TunnelSocket(SocketImpl impl, Convertable tunnel) throws SocketException {
        super(impl);
        this._tunnel = tunnel;
        if (this.isConnected()) {
            try {
                this._tunnel.auth(this.getRawInputStream(), this.getRawOutputStream(), this);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    TunnelSocket(InetAddress address, int port, Convertable tunnel) throws IOException {
        super(address, port);
        this._tunnel = tunnel;
        if (this.isConnected()) {
            try {
                this._tunnel.auth(this.getRawInputStream(), this.getRawOutputStream(), this);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    TunnelSocket(InetAddress address, int port, InetAddress localAddr, int localPort, Convertable tunnel) throws IOException {
        super(address, port, localAddr, localPort);
        this._tunnel = tunnel;
        if (this.isConnected()) {
            try {
                this._tunnel.auth(this.getRawInputStream(), this.getRawOutputStream(), this);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    TunnelSocket(String host, int port, Convertable tunnel) throws UnknownHostException, IOException {
        super(host, port);
        this._tunnel = tunnel;
        if (this.isConnected()) {
            try {
                this._tunnel.auth(this.getRawInputStream(), this.getRawOutputStream(), this);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    TunnelSocket(String host, int port, InetAddress localAddr, int localPort, Convertable tunnel) throws IOException {
        super(host, port, localAddr, localPort);
        this._tunnel = tunnel;
        if (this.isConnected()) {
            try {
                this._tunnel.auth(this.getRawInputStream(), this.getRawOutputStream(), this);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this._out == null) {
            this._out = new TunnelOutputStream(super.getOutputStream(), this._tunnel);
        }
        return this._out;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this._in == null) {
            this._in = new TunnelInputStream(super.getInputStream(), this._tunnel);
        }
        return this._in;
    }

    public OutputStream getRawOutputStream() throws IOException {
        return super.getOutputStream();
    }

    public InputStream getRawInputStream() throws IOException {
        return super.getInputStream();
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.connect(endpoint, 0);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        super.connect(endpoint, timeout);
        if (this._tunnel != null) {
            try {
                this._tunnel.auth(this.getRawInputStream(), this.getRawOutputStream(), this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setSubject(Subject subject) {
        this._subject = subject;
    }

    @Override
    public Subject getSubject() {
        return this._subject;
    }

    public void setRoles(List<String> newRoles) {
        this._roles.addAll(newRoles);
    }

    public boolean verify() throws IOException {
        if (this._tunnel != null) {
            if (this._tunnel.verify(this.getRawInputStream(), this.getRawOutputStream(), this)) {
                this.setSubject(this._tunnel.getSubject());
                return true;
            }
            return false;
        }
        return true;
    }
}

