/*
 * Decompiled with CFR 0.152.
 */
package javatunnel;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import javatunnel.Convertable;
import javatunnel.TunnelSocket;

class TunnelServerSocket
extends ServerSocket {
    private Convertable _tunnel;

    public TunnelServerSocket(Convertable tunnel) throws IOException {
        this._tunnel = tunnel;
    }

    public TunnelServerSocket(int port, Convertable tunnel) throws IOException {
        super(port);
        this._tunnel = tunnel;
    }

    public TunnelServerSocket(int port, int backlog, Convertable tunnel) throws IOException {
        super(port, backlog);
        this._tunnel = tunnel;
    }

    public TunnelServerSocket(int port, int backlog, InetAddress bindAddr, Convertable tunnel) throws IOException {
        super(port, backlog, bindAddr);
        this._tunnel = tunnel;
    }

    @Override
    public Socket accept() throws IOException {
        Convertable tunnelCopy = this._tunnel.makeCopy();
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isBound()) {
            throw new SocketException("Socket is not bound yet");
        }
        TunnelSocket s = new TunnelSocket(tunnelCopy);
        this.implAccept(s);
        return s;
    }
}

