/*
 * Decompiled with CFR 0.152.
 */
package javatunnel;

import java.io.IOException;
import java.io.OutputStream;
import javatunnel.Convertable;

class TunnelOutputStream
extends OutputStream {
    private static final int ARRAYMAXLEN = 4096;
    private OutputStream _out;
    private Convertable _converter;
    private byte[] _buffer = new byte[4096];
    private int _pos;

    public TunnelOutputStream(OutputStream out, Convertable converter) {
        this._out = out;
        this._converter = converter;
    }

    @Override
    public void write(int b) throws IOException {
        this._buffer[this._pos] = (byte)b;
        ++this._pos;
        if (this._pos >= 4096) {
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        this._converter.encode(this._buffer, this._pos, this._out);
        this._pos = 0;
    }

    @Override
    public void close() throws IOException {
        this._out.close();
    }
}

