/*
 * Decompiled with CFR 0.152.
 */
package javatunnel;

import dmg.util.UserValidatable;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.util.Map;
import javatunnel.SSLTunnelServerSocket;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;

public class SSLServerSocketCreator
extends ServerSocketFactory {
    private SSLServerSocketFactory ssf;
    private UserValidatable uv;

    public SSLServerSocketCreator(String[] args, Map<?, UserValidatable> map) throws IOException {
        this(args);
        this.uv = map.get("UserValidatable");
    }

    public SSLServerSocketCreator(String[] args) throws IOException {
        try {
            char[] passphrase = null;
            if (args.length > 1 && args[1] != null) {
                passphrase = args[1].toCharArray();
            }
            SSLContext ctx = SSLContext.getInstance("TLS");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(args[0]), passphrase);
            kmf.init(ks, passphrase);
            ctx.init(kmf.getKeyManagers(), null, null);
            this.ssf = ctx.getServerSocketFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("ssl failed");
        }
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        return new SSLTunnelServerSocket(port, this.ssf, this.uv);
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        return new SSLTunnelServerSocket(this.ssf, this.uv);
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return new SSLTunnelServerSocket(port, backlog, this.ssf, this.uv);
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        return new SSLTunnelServerSocket(port, backlog, ifAddress, this.ssf, this.uv);
    }

    public static void main(String[] args) {
        try {
            SSLServerSocketCreator sc = new SSLServerSocketCreator(args);
            ServerSocket ss = sc.createServerSocket(1717);
            ss.accept();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

